/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ssh2;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSchException;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.NoRouteToHostException;
import java.net.UnknownHostException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.IServerConnection;
import org.eclipse.team.internal.ccvs.core.connection.CVSAuthenticationException;
import org.eclipse.team.internal.ccvs.ssh.SSHServerConnection;
import org.eclipse.team.internal.ccvs.ssh2.CVSSSH2Messages;
import org.eclipse.team.internal.ccvs.ssh2.JSchSession;
import org.eclipse.team.internal.core.streams.PollingInputStream;
import org.eclipse.team.internal.core.streams.PollingOutputStream;
import org.eclipse.team.internal.core.streams.TimeoutInputStream;
import org.eclipse.team.internal.core.streams.TimeoutOutputStream;

public class CVSSSH2ServerConnection
implements IServerConnection {
    private static final String COMMAND = "cvs server";
    private ICVSRepositoryLocation location;
    private String password;
    private InputStream inputStream;
    private OutputStream outputStream;
    private JSchSession session;
    private Channel channel;
    private IServerConnection ssh1;

    protected CVSSSH2ServerConnection(ICVSRepositoryLocation location, String password) {
        this.location = location;
        this.password = password;
    }

    public void close() throws IOException {
        if (this.ssh1 != null) {
            this.ssh1.close();
            this.ssh1 = null;
            return;
        }
        try {
            if (this.inputStream != null) {
                try {
                    this.inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        catch (Throwable throwable) {
            try {
                if (this.outputStream != null) {
                    try {
                        this.outputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            finally {
                if (this.channel != null) {
                    this.channel.disconnect();
                }
            }
            throw throwable;
        }
        try {
            if (this.outputStream != null) {
                try {
                    this.outputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            if (this.channel != null) {
                this.channel.disconnect();
            }
        }
    }

    public InputStream getInputStream() {
        if (this.ssh1 != null) {
            return this.ssh1.getInputStream();
        }
        return this.inputStream;
    }

    public OutputStream getOutputStream() {
        if (this.ssh1 != null) {
            return this.ssh1.getOutputStream();
        }
        return this.outputStream;
    }

    public void open(IProgressMonitor monitor) throws IOException, CVSAuthenticationException {
        if (this.ssh1 != null) {
            this.ssh1.open(monitor);
            return;
        }
        monitor.subTask(NLS.bind((String)CVSSSH2Messages.CVSSSH2ServerConnection_open, (Object[])new String[]{this.location.getHost()}));
        monitor.worked(1);
        this.internalOpen(monitor);
    }

    private void internalOpen(IProgressMonitor monitor) throws IOException, CVSAuthenticationException {
        try {
            OutputStream channel_out = null;
            InputStream channel_in = null;
            boolean firstTime = true;
            boolean tryAgain = false;
            while (firstTime || tryAgain) {
                tryAgain = false;
                this.session = JSchSession.getSession(this.location, this.location.getUsername(), this.password, this.location.getHost(), this.location.getPort(), monitor);
                this.channel = this.session.getSession().openChannel("exec");
                ((ChannelExec)this.channel).setCommand(COMMAND);
                channel_out = this.channel.getOutputStream();
                channel_in = this.channel.getInputStream();
                try {
                    this.channel.connect();
                }
                catch (JSchException ee) {
                    try {
                        if (firstTime && (this.isSessionDownError(ee) || this.isChannelNotOpenError(ee))) {
                            tryAgain = true;
                        }
                        if (!tryAgain) {
                            throw ee;
                        }
                    }
                    finally {
                        this.session.dispose();
                    }
                    {
                    }
                }
                firstTime = false;
            }
            int timeout = this.location.getTimeout();
            this.inputStream = new PollingInputStream((InputStream)new TimeoutInputStream((InputStream)new FilterInputStream(channel_in){

                public void close() {
                }
            }, 8192, (long)(timeout > 0 ? 1000 : 0), -1L, true), timeout > 0 ? timeout : 1, monitor);
            this.outputStream = new PollingOutputStream((OutputStream)new TimeoutOutputStream((OutputStream)new FilterOutputStream(channel_out){

                public void close() {
                }
            }, 8192, (long)(timeout > 0 ? 1000 : 0), (long)(timeout > 0 ? 1000 : 0)), timeout > 0 ? timeout : 1, monitor);
        }
        catch (JSchException e) {
            int end;
            int start;
            if (this.isSSH2Unsupported(e)) {
                this.ssh1 = new SSHServerConnection(this.location, this.password);
                if (this.ssh1 == null) {
                    throw new SSH2IOException(e.toString(), e);
                }
                this.ssh1.open(monitor);
            }
            String message = e.getMessage();
            if (JSchSession.isAuthenticationFailure(e)) {
                throw new CVSAuthenticationException(CVSSSH2Messages.CVSSSH2ServerConnection_0, 2, this.location, (Exception)((Object)e));
            }
            if (message.startsWith("Session.connect: ") && (start = message.indexOf(": ") + 1) != -1 && (end = message.indexOf(": ", start)) != -1) {
                String exception = message.substring(start, end).trim();
                if (exception.indexOf("NoRouteToHostException") != -1) {
                    message = NLS.bind((String)CVSSSH2Messages.CVSSSH2ServerConnection_1, (Object[])new String[]{this.location.getHost()});
                    throw new NoRouteToHostException(message);
                }
                if (exception.indexOf("java.net.UnknownHostException") != -1) {
                    throw new UnknownHostException(this.location.getHost());
                }
                message = message.substring(end + 1).trim();
            }
            throw new SSH2IOException(message, e);
        }
    }

    private boolean isChannelNotOpenError(JSchException ee) {
        return ee.getMessage().indexOf("channel is not opened") != -1;
    }

    private boolean isSessionDownError(JSchException ee) {
        return ee.getMessage().equals("session is down");
    }

    private boolean isSSH2Unsupported(JSchException e) {
        return e.toString().indexOf("invalid server's version string") != -1;
    }

    private final class SSH2IOException
    extends IOException {
        private static final long serialVersionUID = 1L;
        private final JSchException e;

        SSH2IOException(String s, JSchException e) {
            super(s);
            this.e = e;
        }

        public Throwable getCause() {
            return this.e;
        }
    }
}

