/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.validation.ui.internal.preferences;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.wst.validation.Validator;
import org.eclipse.wst.validation.internal.ConfigurationManager;
import org.eclipse.wst.validation.internal.GlobalConfiguration;
import org.eclipse.wst.validation.internal.ProjectConfiguration;
import org.eclipse.wst.validation.internal.ValManager;
import org.eclipse.wst.validation.internal.ValPrefManagerProject;
import org.eclipse.wst.validation.internal.ValidatorMetaData;
import org.eclipse.wst.validation.internal.model.ProjectPreferences;
import org.eclipse.wst.validation.internal.operations.ValidatorManager;
import org.eclipse.wst.validation.internal.plugin.ValidationPlugin;
import org.eclipse.wst.validation.internal.ui.DelegatingValidatorPreferencesDialog;
import org.eclipse.wst.validation.internal.ui.plugin.ValidationUIPlugin;
import org.eclipse.wst.validation.ui.internal.ValUIMessages;
import org.eclipse.wst.validation.ui.internal.dialog.FilterDialog;

public class ValidationPropertyPage
extends PropertyPage {
    private IValidationPage _pageImpl;
    private Shell _shell;

    protected Control createContents(Composite parent) {
        try {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.wst.validation.ui.jvpp0000");
            this._shell = parent.getShell();
            this._pageImpl = new ValidatorListPage(parent);
        }
        catch (Exception exc) {
            this._pageImpl = new InvalidPage(parent);
            this.displayAndLogError(ValUIMessages.VBF_EXC_INTERNAL_TITLE, ValUIMessages.VBF_EXC_INTERNAL_PAGE, exc);
        }
        return this._pageImpl.getControl();
    }

    protected void performDefaults() {
        super.performDefaults();
        try {
            this._pageImpl.performDefaults();
        }
        catch (Exception exc) {
            this.displayAndLogError(ValUIMessages.VBF_EXC_INTERNAL_TITLE, ValUIMessages.VBF_EXC_INTERNAL_PAGE, exc);
        }
    }

    public boolean performOk() {
        try {
            return this._pageImpl.performOk();
        }
        catch (Exception exc) {
            this.displayAndLogError(ValUIMessages.VBF_EXC_INTERNAL_TITLE, ValUIMessages.VBF_EXC_INTERNAL_PAGE, exc);
            return false;
        }
    }

    public void dispose() {
        super.dispose();
        try {
            if (this._pageImpl != null) {
                this._pageImpl.dispose();
                this._pageImpl = null;
            }
        }
        catch (Exception exc) {
            this.displayAndLogError(ValUIMessages.VBF_EXC_INTERNAL_TITLE, ValUIMessages.VBF_EXC_INTERNAL_PAGE, exc);
        }
    }

    private void logError(Throwable exc) {
        ValidationUIPlugin.getPlugin().handleException(exc);
    }

    void displayAndLogError(String title, String message, Throwable exc) {
        this.logError(exc);
        this.displayMessage(title, message, 1);
    }

    private void displayMessage(String title, String message, int iIconType) {
        MessageBox messageBox = new MessageBox(this.getShell(), 0x20 | iIconType | 0x10000);
        messageBox.setMessage(message);
        messageBox.setText(title);
        messageBox.open();
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (this._pageImpl == null) {
            return;
        }
        if (visible) {
            this._pageImpl.gainFocus();
        } else {
            this._pageImpl.loseFocus();
        }
    }

    protected Button getDefaultsButton() {
        return super.getDefaultsButton();
    }

    public IProject getProject() {
        IAdaptable selectedElement = this.getElement();
        if (selectedElement == null) {
            return null;
        }
        if (selectedElement instanceof IProject) {
            return (IProject)selectedElement;
        }
        Object adaptedObject = selectedElement.getAdapter(IProject.class);
        if (adaptedObject instanceof IProject) {
            return (IProject)adaptedObject;
        }
        return null;
    }

    public static interface IValidationPage {
        public Composite createPage(Composite var1) throws InvocationTargetException;

        public boolean performOk() throws InvocationTargetException;

        public boolean performDefaults() throws InvocationTargetException;

        public Composite getControl();

        public void dispose();

        public void loseFocus();

        public void gainFocus();
    }

    public class InvalidPage
    implements IValidationPage {
        private Composite page = null;
        private Composite composite = null;
        private GridLayout layout = null;
        private Label messageLabel = null;

        public InvalidPage(Composite parent) {
            this.page = this.createPage(parent);
        }

        public Composite createPage(Composite parent) {
            ValidationPropertyPage.this.noDefaultAndApplyButton();
            ScrolledComposite sc1 = new ScrolledComposite(parent, 768);
            sc1.setLayoutData((Object)new GridData(1808));
            this.composite = new Composite((Composite)sc1, 0);
            sc1.setContent((Control)this.composite);
            this.layout = new GridLayout();
            this.composite.setLayout((Layout)this.layout);
            this.messageLabel = new Label(this.composite, 0);
            this.messageLabel.setText(ValUIMessages.VBF_EXC_INVALID_REGISTER);
            this.composite.setSize(this.composite.computeSize(-1, -1));
            return this.composite;
        }

        public boolean performDefaults() {
            return true;
        }

        public boolean performOk() {
            return true;
        }

        public Composite getControl() {
            return this.page;
        }

        public void dispose() {
            this.messageLabel.dispose();
            this.composite.dispose();
        }

        public void loseFocus() {
        }

        public void gainFocus() {
        }
    }

    private class ValidatorListPage
    implements IValidationPage {
        private Composite _page;
        private TableViewer _validatorList;
        private Button _enableAllButton;
        private Button _disableAllButton;
        private Button _override;
        private Button _suspend;
        private Link _configLink;
        private Button _addValidationBuilder;
        private Table _validatorsTable;
        private Validator[] _validators;

        public ValidatorListPage(Composite parent) throws InvocationTargetException {
            this._page = this.createPage(parent);
        }

        private void setupTableColumns(Table table) {
            TableColumn validatorColumn = new TableColumn(table, 0);
            validatorColumn.setText(ValUIMessages.VALIDATOR);
            validatorColumn.setWidth(245);
            TableColumn manualColumn = new TableColumn(table, 0x1000000);
            manualColumn.setText(ValUIMessages.MANUAL);
            manualColumn.pack();
            TableColumn buildColumn = new TableColumn(table, 0x1000000);
            buildColumn.setText(ValUIMessages.BUILD);
            buildColumn.pack();
            TableColumn settingsColumn = new TableColumn(table, 0x1000000);
            settingsColumn.setText(ValUIMessages.SETTINGS);
            settingsColumn.pack();
        }

        public Composite createPage(Composite parent) throws InvocationTargetException {
            this._validators = this.copyValidators(ValManager.getDefault().getValidators(ValidationPropertyPage.this.getProject(), false));
            Composite validatorGroup = new Composite(parent, 0);
            GridLayout validatorGroupLayout = new GridLayout();
            validatorGroupLayout.numColumns = 2;
            validatorGroup.setLayout((Layout)validatorGroupLayout);
            GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)validatorGroup);
            this.addOverride(validatorGroup);
            this.addConfigLink(validatorGroup);
            this.addSuspend(validatorGroup);
            this.addValidationBuilder(validatorGroup);
            new Label(validatorGroup, 0).setLayoutData((Object)new GridData());
            Label listLabel = new Label(validatorGroup, 0);
            GridData listLabelData = new GridData(768);
            listLabelData.horizontalSpan = 2;
            listLabel.setLayoutData((Object)listLabelData);
            listLabel.setText(ValUIMessages.PREF_VALLIST_TITLE);
            this._validatorsTable = new Table(validatorGroup, 67584);
            Point preferredSize = this._validatorsTable.computeSize(-1, -1);
            GridDataFactory.fillDefaults().grab(true, true).hint(preferredSize).span(2, 1).applyTo((Control)this._validatorsTable);
            this._validatorsTable.setHeaderVisible(true);
            this._validatorsTable.setLinesVisible(true);
            this._validatorList = new TableViewer(this._validatorsTable);
            this._validatorList.setLabelProvider((IBaseLabelProvider)new ValidationLabelProvider());
            this._validatorList.setContentProvider((IContentProvider)new ValidationContentProvider());
            this._validatorList.setSorter(new ViewerSorter());
            this.setupTableColumns(this._validatorsTable);
            this._validatorList.setInput((Object)this._validators);
            this._validatorsTable.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDown(MouseEvent e) {
                    int columnNumber;
                    if (e.button != 1) {
                        return;
                    }
                    TableItem tableItem = ValidatorListPage.this._validatorsTable.getItem(new Point(e.x, e.y));
                    if (tableItem == null || tableItem.isDisposed()) {
                        return;
                    }
                    int columnsCount = ValidatorListPage.this._validatorsTable.getColumnCount();
                    if (columnsCount == 0) {
                        columnNumber = 0;
                    } else {
                        columnNumber = -1;
                        int i = 0;
                        while (i < columnsCount) {
                            Rectangle bounds = tableItem.getBounds(i);
                            if (bounds.contains(e.x, e.y)) {
                                columnNumber = i;
                                break;
                            }
                            ++i;
                        }
                        if (columnNumber == -1) {
                            return;
                        }
                    }
                    ValidatorListPage.this.columnClicked(columnNumber);
                }
            });
            this._validatorsTable.setMenu(this.createContextMenu());
            this._validatorsTable.addFocusListener((FocusListener)new FocusAdapter(){

                public void focusGained(FocusEvent e) {
                    super.focusGained(e);
                    if (ValidatorListPage.this._validatorsTable.getSelectionCount() == 0) {
                        ValidatorListPage.this._validatorsTable.select(0);
                    }
                }
            });
            this.addButtons(validatorGroup);
            validatorGroup.setTabList(new Control[]{this._override, this._suspend});
            this.updateWidgets();
            ValidationPropertyPage.this.applyDialogFont(validatorGroup);
            validatorGroup.setSize(validatorGroup.computeSize(-1, -1));
            return validatorGroup;
        }

        private void addButtons(Composite validatorGroup) {
            Composite buttons = new Composite(validatorGroup, 0);
            GridData gd = new GridData(768);
            gd.horizontalSpan = 2;
            buttons.setLayout((Layout)new RowLayout());
            this._enableAllButton = new Button(buttons, 8);
            this._enableAllButton.setText(ValUIMessages.PREF_BUTTON_ENABLEALL);
            this._enableAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    try {
                        ValidatorListPage.this.performEnableAll();
                    }
                    catch (InvocationTargetException exc) {
                        ValidationPropertyPage.this.displayAndLogError(ValUIMessages.VBF_EXC_INTERNAL_TITLE, ValUIMessages.VBF_EXC_INTERNAL_PAGE, exc);
                    }
                }
            });
            this._disableAllButton = new Button(buttons, 8);
            this._disableAllButton.setText(ValUIMessages.PREF_BUTTON_DISABLEALL);
            this._disableAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    try {
                        ValidatorListPage.this.performDisableAll();
                    }
                    catch (InvocationTargetException exc) {
                        ValidationPropertyPage.this.displayAndLogError(ValUIMessages.VBF_EXC_INTERNAL_TITLE, ValUIMessages.VBF_EXC_INTERNAL_PAGE, exc);
                    }
                }
            });
        }

        private void addSuspend(Composite validatorGroup) {
            GridData gd = new GridData(768);
            gd.horizontalSpan = 2;
            this._suspend = new Button(validatorGroup, 32);
            this._suspend.setLayoutData((Object)gd);
            this._suspend.setText(ValUIMessages.DISABLE_VALIDATION);
            this._suspend.setSelection(this.getProjectPreferences().getSuspend());
            this._suspend.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ValidatorListPage.this._suspend.setFocus();
                    ValidatorListPage.this.enableDisableWidgets();
                    ValidatorListPage.this._validatorList.refresh();
                }
            });
        }

        private void addConfigLink(Composite validatorGroup) {
            this._configLink = new Link(validatorGroup, 0);
            GridData layout = new GridData(128);
            this._configLink.setLayoutData((Object)layout);
            this._configLink.setText("<A>" + ValUIMessages.ConfigWsSettings + "</A>");
            this._configLink.addSelectionListener(new SelectionListener(){
                public static final String DATA_NO_LINK = "PropertyAndPreferencePage.nolink";

                public void doLinkActivated(Link e) {
                    String id = this.getPreferencePageID();
                    PreferencesUtil.createPreferenceDialogOn((Shell)ValidationPropertyPage.this.getShell(), (String)id, (String[])new String[]{id}, (Object)DATA_NO_LINK).open();
                    try {
                        ValidatorListPage.this.updateWidgets();
                    }
                    catch (InvocationTargetException invocationTargetException) {}
                }

                private String getPreferencePageID() {
                    return "ValidationPreferencePage";
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.doLinkActivated((Link)e.widget);
                }

                public void widgetSelected(SelectionEvent e) {
                    this.doLinkActivated((Link)e.widget);
                }
            });
        }

        private void addBuilder() {
            if (this._addValidationBuilder != null && this._addValidationBuilder.getSelection()) {
                ValidatorManager.addProjectBuildValidationSupport((IProject)ValidationPropertyPage.this.getProject());
            }
        }

        private void addValidationBuilder(Composite validatorGroup) {
            if (this.hasValidationBuilder()) {
                return;
            }
            GridData gd = new GridData(768);
            gd.horizontalSpan = 2;
            this._addValidationBuilder = new Button(validatorGroup, 32);
            this._addValidationBuilder.setLayoutData((Object)gd);
            this._addValidationBuilder.setText(ValUIMessages.ADD_VALIDATION_BUILDER);
            this._addValidationBuilder.setSelection(false);
        }

        private Validator[] copyValidators(Validator[] vals) {
            Validator[] validators = new Validator[vals.length];
            int i = 0;
            while (i < vals.length) {
                validators[i] = vals[i].copy();
                ++i;
            }
            return validators;
        }

        boolean hasSettings(Validator v) {
            if (v.asV2Validator() != null) {
                return true;
            }
            return v.getDelegatingId() != null;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private boolean hasValidationBuilder() {
            try {
                IProjectDescription description = ValidationPropertyPage.this.getProject().getDescription();
                ICommand[] commands = description.getBuildSpec();
                int i = 0;
                while (true) {
                    if (i >= commands.length) {
                        return false;
                    }
                    if (commands[i].getBuilderName().equals("org.eclipse.wst.validation.validationbuilder")) {
                        return true;
                    }
                    ++i;
                }
            }
            catch (CoreException e) {
                ValidationPlugin.getPlugin().handleException((Throwable)e);
                return false;
            }
        }

        private void addOverride(Composite validatorGroup) {
            GridData gd = new GridData(768);
            this._override = new Button(validatorGroup, 32);
            this._override.setLayoutData((Object)gd);
            this._override.setText(ValUIMessages.LabelEnableProjectSpecific);
            this._override.setSelection(this.getProjectPreferences().getOverride());
            this._override.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ValidatorListPage.this._override.setFocus();
                    if (ValManager.getDefault().getGlobalPreferences().getOverride()) {
                        ValidatorListPage.this.enableDisableWidgets();
                        ValidatorListPage.this._validatorList.refresh();
                    } else {
                        MessageDialog.openWarning((Shell)ValidationPropertyPage.this._shell, (String)ValUIMessages.Validation, (String)ValUIMessages.ProjectOverridesNotAllowed);
                    }
                }
            });
        }

        protected Menu createContextMenu() {
            Menu menu = new Menu((Decorations)this._validatorsTable.getShell(), 8);
            final MenuItem manualItem = new MenuItem(menu, 32);
            manualItem.setText(ValUIMessages.PREF_MNU_MANUAL);
            final MenuItem buildItem = new MenuItem(menu, 32);
            buildItem.setText(ValUIMessages.PREF_MNU_BUILD);
            final MenuItem settingsItem = new MenuItem(menu, 8);
            settingsItem.setText(ValUIMessages.PREF_MNU_SETTINGS);
            class MenuItemListener
            extends SelectionAdapter {
                private final /* synthetic */ Menu val$menu;

                MenuItemListener(Menu menu) {
                    this.val$menu = menu;
                }

                public void widgetSelected(SelectionEvent e) {
                    MenuItem menuItem = (MenuItem)e.getSource();
                    int index = this.val$menu.indexOf(menuItem) + 1;
                    ValidatorListPage.this.columnClicked(index);
                }
            }
            MenuItemListener listener = new MenuItemListener(menu);
            manualItem.addSelectionListener((SelectionListener)listener);
            buildItem.addSelectionListener((SelectionListener)listener);
            settingsItem.addSelectionListener((SelectionListener)listener);
            menu.addMenuListener((MenuListener)new MenuAdapter(){

                public void menuShown(MenuEvent e) {
                    IStructuredSelection selection = (IStructuredSelection)ValidatorListPage.this._validatorList.getSelection();
                    Validator val = (Validator)selection.getFirstElement();
                    manualItem.setSelection(val.isManualValidation());
                    buildItem.setSelection(val.isBuildValidation());
                    settingsItem.setEnabled(ValidatorListPage.this.hasSettings(val));
                }
            });
            return menu;
        }

        protected void columnClicked(int columnToEdit) {
            IStructuredSelection selection = (IStructuredSelection)this._validatorList.getSelection();
            Validator val = (Validator)selection.getFirstElement();
            switch (columnToEdit) {
                case 1: {
                    val.setManualValidation(!val.isManualValidation());
                    break;
                }
                case 2: {
                    val.setBuildValidation(!val.isBuildValidation());
                    break;
                }
                case 3: {
                    Validator.V2 v2 = val.asV2Validator();
                    if (v2 != null) {
                        FilterDialog fd = new FilterDialog(ValidationPropertyPage.this._shell, val, ValidationPropertyPage.this.getProject());
                        if (fd.open() != 0) break;
                        val.become(fd.getValidator());
                        break;
                    }
                    this.handleOldDelegate(val);
                    break;
                }
            }
            this._validatorList.refresh();
        }

        private void handleOldDelegate(Validator val) {
            try {
                Validator.V1 v1 = val.asV1Validator();
                if (v1 == null) {
                    return;
                }
                ValidatorMetaData vmd = v1.getVmd();
                if (!vmd.isDelegating()) {
                    return;
                }
                GlobalConfiguration gc = ConfigurationManager.getManager().getGlobalConfiguration();
                String delegateID = gc.getDelegateUniqueName(vmd);
                Shell shell = Display.getCurrent().getActiveShell();
                DelegatingValidatorPreferencesDialog dialog = new DelegatingValidatorPreferencesDialog(shell, vmd, delegateID);
                dialog.setBlockOnOpen(true);
                dialog.create();
                int result = dialog.open();
                if (result == 0) {
                    gc.setDelegateUniqueName(vmd, dialog.getDelegateID());
                }
            }
            catch (InvocationTargetException invocationTargetException) {}
        }

        protected void updateWidgets() throws InvocationTargetException {
            this.updateAllWidgets();
            this.updateHelp();
        }

        protected void updateWidgetsForDefaults() throws InvocationTargetException {
            this.updateAllWidgets();
            this.updateHelp();
        }

        private void updateAllWidgets() throws InvocationTargetException {
            this._suspend.setSelection(this.getProjectPreferences().getSuspend());
            this._override.setSelection(this.getProjectPreferences().getOverride());
            this.enableDisableWidgets();
            this._validatorList.setInput((Object)this._validators);
            this._validatorList.refresh();
        }

        public boolean performOk() throws InvocationTargetException {
            this.addBuilder();
            if (!ValManager.getDefault().getGlobalPreferences().getOverride() && this._override.getSelection()) {
                MessageDialog.openWarning((Shell)ValidationPropertyPage.this._shell, (String)ValUIMessages.Validation, (String)ValUIMessages.ProjectOverridesNotAllowed);
                return false;
            }
            this.updateV1ProjectSettings();
            this.getProjectPreferences().setSuspend(this._suspend.getSelection());
            this.getProjectPreferences().setOverride(this._override.getSelection());
            IProject project = ValidationPropertyPage.this.getProject();
            ValPrefManagerProject vpm = new ValPrefManagerProject(project);
            vpm.savePreferences(this.getProjectPreferences(), this._validators);
            return true;
        }

        private void updateV1ProjectSettings() {
            try {
                ProjectConfiguration pc = ConfigurationManager.getManager().getProjectConfiguration(ValidationPropertyPage.this.getProject());
                pc.setDoesProjectOverride(this._override.getSelection());
                pc.setDisableAllValidation(this._suspend.getSelection());
            }
            catch (InvocationTargetException e) {
                ValidationPlugin.getPlugin().handleException((Throwable)e);
            }
        }

        private ProjectPreferences getProjectPreferences() {
            return ValManager.getDefault().getProjectPreferences(ValidationPropertyPage.this.getProject());
        }

        public boolean performDefaults() throws InvocationTargetException {
            this._validators = this.copyValidators(ValManager.getDefaultValidators((IProject)ValidationPropertyPage.this.getProject()));
            this.updateWidgetsForDefaults();
            ValidationPropertyPage.this.getDefaultsButton().setFocus();
            return true;
        }

        public boolean performEnableAll() throws InvocationTargetException {
            this.setAllValidators(true);
            this._enableAllButton.setFocus();
            this._validatorList.refresh();
            return true;
        }

        private void setAllValidators(boolean bool) {
            TableItem[] tableItemArray = this._validatorsTable.getItems();
            int n = tableItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem item = tableItemArray[n2];
                Validator val = (Validator)item.getData();
                val.setManualValidation(bool);
                val.setBuildValidation(bool);
                ++n2;
            }
        }

        public boolean performDisableAll() throws InvocationTargetException {
            this.setAllValidators(false);
            this._disableAllButton.setFocus();
            this._validatorList.refresh();
            return true;
        }

        protected void updateHelp() {
        }

        public Composite getControl() {
            return this._page;
        }

        public void dispose() {
            this._override.dispose();
            this._suspend.dispose();
            this._configLink.dispose();
            this._disableAllButton.dispose();
            this._enableAllButton.dispose();
            this._validatorList.getTable().dispose();
        }

        private void enableDisableWidgets() {
            boolean globalOverride = ValManager.getDefault().getGlobalPreferences().getOverride();
            boolean enable = !this._suspend.getSelection() & this._override.getSelection() & globalOverride;
            this._suspend.setEnabled(this._override.getSelection() & globalOverride);
            this._validatorsTable.setEnabled(enable);
            this._enableAllButton.setEnabled(enable);
            this._disableAllButton.setEnabled(enable);
            this._configLink.setEnabled(!globalOverride || !this._override.getSelection());
        }

        public void loseFocus() {
        }

        public void gainFocus() {
        }

        public class ValidationContentProvider
        implements IStructuredContentProvider {
            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof Validator[]) {
                    return (Validator[])inputElement;
                }
                return new Object[0];
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        }

        public class ValidationLabelProvider
        extends LabelProvider
        implements ITableLabelProvider {
            public String getText(Object element) {
                if (element == null) {
                    return "";
                }
                if (element instanceof Validator) {
                    return ((Validator)element).getName();
                }
                return super.getText(element);
            }

            private Image getImage(String imageName) {
                boolean isDisabled;
                boolean bl = isDisabled = !ValidatorListPage.this._validatorsTable.isEnabled();
                if (isDisabled) {
                    imageName = String.valueOf(imageName) + "_disabled";
                }
                return ValidationUIPlugin.getPlugin().getImage(imageName);
            }

            public Image getColumnImage(Object element, int columnIndex) {
                Validator v = (Validator)element;
                if (columnIndex == 1) {
                    return this.getImage(v.isManualValidation() ? "ok_tbl" : "fail_tbl");
                }
                if (columnIndex == 2) {
                    return this.getImage(v.isBuildValidation() ? "ok_tbl" : "fail_tbl");
                }
                if (columnIndex == 3) {
                    if (ValidatorListPage.this.hasSettings(v)) {
                        return this.getImage("settings");
                    }
                    return null;
                }
                return null;
            }

            public String getColumnText(Object element, int columnIndex) {
                if (columnIndex == 0) {
                    return ((Validator)element).getName();
                }
                return null;
            }
        }
    }
}

