/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.context.ui.wizards;

import java.text.DateFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.mylyn.internal.tasks.ui.util.AttachmentUtil;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.ITaskAttachment;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TaskElementLabelProvider;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class ContextRetrieveWizardPage
extends WizardPage {
    private static final String WIZARD_TITLE = "Retrieve context";
    private static final String DESCRIPTION = "Select a context to retrieve from table below.";
    private static final String COLUMN_COMMENT = "Description";
    private static final String COLUMN_AUTHOR = "Author";
    private static final String COLUMN_DATE = "Date";
    private final TaskRepository repository;
    private final ITask task;
    private final TaskElementLabelProvider labelProvider = new TaskElementLabelProvider(false);
    private ITaskAttachment selectedContextAttachment;

    protected ContextRetrieveWizardPage(TaskRepository repository, ITask task) {
        super(WIZARD_TITLE);
        this.repository = repository;
        this.task = task;
        this.setDescription(DESCRIPTION);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        Text summary = new Text(composite, 0);
        summary.setText("Task: " + this.labelProvider.getText((Object)this.task));
        summary.setEditable(false);
        final Table contextTable = new Table(composite, 67584);
        contextTable.setHeaderVisible(true);
        contextTable.setLinesVisible(true);
        contextTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (contextTable.getSelectionIndex() > -1) {
                    ContextRetrieveWizardPage.this.selectedContextAttachment = (ITaskAttachment)contextTable.getItem(contextTable.getSelectionIndex()).getData();
                    ContextRetrieveWizardPage.this.getWizard().getContainer().updateButtons();
                }
            }
        });
        contextTable.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
                ContextRetrieveWizardPage.this.selectedContextAttachment = (ITaskAttachment)contextTable.getItem(contextTable.getSelectionIndex()).getData();
                ContextRetrieveWizardPage.this.getWizard().getContainer().updateButtons();
                ContextRetrieveWizardPage.this.getWizard().performFinish();
                ContextRetrieveWizardPage.this.getWizard().getContainer().getShell().close();
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
            }
        });
        List contextAttachments = AttachmentUtil.getContextAttachments((TaskRepository)this.repository, (ITask)this.task);
        Collections.sort(contextAttachments, new Comparator<ITaskAttachment>(){

            @Override
            public int compare(ITaskAttachment attachment1, ITaskAttachment attachment2) {
                Date created1 = null;
                Date created2 = null;
                created1 = attachment1.getCreationDate();
                created2 = attachment2.getCreationDate();
                if (created1 != null && created2 != null) {
                    return -1 * created1.compareTo(created2);
                }
                if (created1 == null && created2 != null) {
                    return 1;
                }
                if (created1 != null && created2 == null) {
                    return -1;
                }
                return 0;
            }
        });
        TableColumn[] columns = new TableColumn[3];
        columns[0] = new TableColumn(contextTable, 16384);
        columns[0].setText(COLUMN_DATE);
        columns[1] = new TableColumn(contextTable, 16384);
        columns[1].setText(COLUMN_AUTHOR);
        columns[2] = new TableColumn(contextTable, 0x1000000);
        columns[2].setText(COLUMN_COMMENT);
        for (ITaskAttachment attachment : contextAttachments) {
            TableItem item = new TableItem(contextTable, 0);
            item.setText(0, DateFormat.getInstance().format(attachment.getCreationDate()));
            item.setText(1, attachment.getAuthor().getName());
            item.setText(2, attachment.getDescription());
            item.setData((Object)attachment);
        }
        TableColumn[] tableColumnArray = columns;
        int n = columns.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn column = tableColumnArray[n2];
            column.pack();
            ++n2;
        }
        contextTable.setLayoutData((Object)new GridData(1808));
        this.setControl((Control)composite);
        if (contextAttachments.size() > 0) {
            contextTable.setSelection(0);
            this.selectedContextAttachment = (ITaskAttachment)contextAttachments.get(0);
            this.getWizard().getContainer().updateButtons();
        }
        contextTable.setFocus();
    }

    public ITaskAttachment getSelectedContext() {
        return this.selectedContextAttachment;
    }

    public boolean isPageComplete() {
        if (this.selectedContextAttachment == null) {
            return false;
        }
        return super.isPageComplete();
    }
}

