/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.context.ui.commands;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.mylyn.context.core.ContextCore;
import org.eclipse.mylyn.context.core.IInteractionContext;
import org.eclipse.mylyn.internal.tasks.ui.actions.TaskSelectionDialog;
import org.eclipse.mylyn.internal.tasks.ui.commands.AbstractTaskHandler;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class CopyContextHandler
extends AbstractTaskHandler {
    private static final String TITLE_DIALOG = "Copy Context";

    protected void execute(ExecutionEvent event, ITask sourceTask) throws ExecutionException {
        if (sourceTask == null) {
            MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)TITLE_DIALOG, (String)"No source task selected.");
            return;
        }
        TaskSelectionDialog dialog = new TaskSelectionDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        dialog.setNeedsCreateTask(false);
        dialog.setTitle("Select Target Task");
        dialog.setMessage("&Select the target task (? = any character, * = any String):");
        if (dialog.open() != 0) {
            return;
        }
        Object result = dialog.getFirstResult();
        if (result instanceof ITask) {
            ITask targetTask = (ITask)result;
            TasksUi.getTaskActivityManager().deactivateActiveTask();
            if (targetTask.equals(sourceTask)) {
                MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)TITLE_DIALOG, (String)"Target task can not be the same as source task.");
            } else {
                IInteractionContext context = ContextCore.getContextStore().cloneContext(sourceTask.getHandleIdentifier(), targetTask.getHandleIdentifier());
                if (context == null) {
                    MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)TITLE_DIALOG, (String)"Source task does not have a context.");
                } else {
                    TasksUi.getTaskActivityManager().activateTask(targetTask);
                }
            }
        } else {
            MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)TITLE_DIALOG, (String)"No target task selected.");
        }
    }
}

