/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.project.facet.core.internal;

import java.util.Collection;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.IVersionExpr;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.internal.FacetCorePlugin;
import org.eclipse.wst.common.project.facet.core.internal.FacetedProjectFrameworkImpl;
import org.eclipse.wst.common.project.facet.core.internal.ProjectFacet;
import org.eclipse.wst.common.project.facet.core.util.internal.PluginUtil;
import org.eclipse.wst.common.project.facet.core.util.internal.VersionExpr;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProjectFacetRef {
    private static final String ATTR_ID = "id";
    private static final String ATTR_VERSION = "version";
    private final IProjectFacet f;
    private final VersionExpr<IProjectFacetVersion> vexpr;

    public ProjectFacetRef(IProjectFacet f, IVersionExpr vexpr) {
        this(f, (VersionExpr)vexpr);
    }

    public ProjectFacetRef(IProjectFacet f, VersionExpr<IProjectFacetVersion> vexpr) {
        this.f = f;
        this.vexpr = vexpr;
    }

    public IProjectFacet getProjectFacet() {
        return this.f;
    }

    public boolean hasVersionExpr() {
        return this.vexpr != null;
    }

    public boolean check(IProjectFacetVersion fv) {
        if (this.f == fv.getProjectFacet()) {
            if (this.vexpr != null) {
                return this.vexpr.check(fv);
            }
            return true;
        }
        return false;
    }

    public boolean check(Collection<IProjectFacetVersion> facets) {
        for (IProjectFacetVersion fv : facets) {
            if (!this.check(fv)) continue;
            return true;
        }
        return false;
    }

    public static ProjectFacetRef read(IConfigurationElement config) {
        String id = config.getAttribute(ATTR_ID);
        if (id == null) {
            PluginUtil.reportMissingAttribute(config, ATTR_ID);
            return null;
        }
        if (!ProjectFacetsManager.isProjectFacetDefined(id)) {
            FacetedProjectFrameworkImpl.reportMissingFacet(id, config.getContributor().getName());
            return null;
        }
        IProjectFacet f = ProjectFacetsManager.getProjectFacet(id);
        String v = config.getAttribute(ATTR_VERSION);
        VersionExpr vexpr = null;
        if (v != null) {
            try {
                String pluginId = config.getContributor().getName();
                vexpr = new VersionExpr(f, v, pluginId);
            }
            catch (CoreException e) {
                FacetCorePlugin.log(e.getStatus());
                return null;
            }
        }
        return new ProjectFacetRef(f, (IVersionExpr)vexpr);
    }

    public String toString() {
        if (this.vexpr == null || ((ProjectFacet)this.f).isVersionHidden()) {
            return this.f.getLabel();
        }
        if (this.vexpr.isSingleVersionMatch()) {
            return NLS.bind((String)Resources.exactVersion, (Object)this.f.getLabel(), (Object)this.vexpr.toString());
        }
        if (this.vexpr.isSimpleAllowNewer()) {
            return NLS.bind((String)Resources.allowNewer, (Object)this.f.getLabel(), (Object)this.vexpr.getFirstVersion());
        }
        if (this.vexpr.isWildcard()) {
            return NLS.bind((String)Resources.wildcard, (Object)this.f.getLabel());
        }
        return NLS.bind((String)Resources.versionExpr, (Object)this.f.getLabel(), (Object)this.vexpr.toString());
    }

    private static final class Resources
    extends NLS {
        public static String exactVersion;
        public static String allowNewer;
        public static String wildcard;
        public static String versionExpr;

        static {
            Resources.initializeMessages((String)ProjectFacetRef.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

