/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.usagedata.internal.recording.uploading;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.epp.usagedata.internal.gathering.events.UsageDataEvent;

public class UsageDataFileReader {
    private final BufferedReader reader;

    public UsageDataFileReader(File file) throws IOException {
        this(new FileInputStream(file));
    }

    public UsageDataFileReader(InputStream inputStream) throws IOException {
        this(new InputStreamReader(inputStream));
    }

    public UsageDataFileReader(Reader reader) throws IOException {
        this(new BufferedReader(reader));
    }

    public UsageDataFileReader(BufferedReader bufferedReader) throws IOException {
        this.reader = bufferedReader;
    }

    private UsageDataEvent createUsageDataEvent(String line) {
        String[] tokens = line.split("\\,");
        UsageDataEvent usageDataEvent = new UsageDataEvent(tokens[0], tokens[1], tokens[4], tokens[2], tokens[3], Long.valueOf(tokens[5]).longValue());
        return usageDataEvent;
    }

    public void close() throws IOException {
        this.reader.close();
    }

    public void iterate(Iterator iterator) throws Exception {
        this.iterate((IProgressMonitor)new NullProgressMonitor(), iterator);
    }

    public void iterate(IProgressMonitor monitor, Iterator iterator) throws Exception {
        monitor.beginTask("Iterate over usage data file", -1);
        try {
            iterator.header(this.reader.readLine());
            while (!monitor.isCanceled()) {
                String line = this.reader.readLine();
                if (line == null) {
                    break;
                }
                UsageDataEvent event = this.createUsageDataEvent(line);
                iterator.event(line, event);
            }
        }
        finally {
            monitor.done();
        }
    }

    public static interface Iterator {
        public void header(String var1) throws Exception;

        public void event(String var1, UsageDataEvent var2) throws Exception;
    }
}

