/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.ui.wizards;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.tasks.core.RepositoryQuery;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.IRepositoryElement;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.mylyn.tasks.ui.TasksUiImages;
import org.eclipse.mylyn.tasks.ui.wizards.AbstractRepositoryQueryPage;

public class RepositoryQueryWizard
extends Wizard {
    private static final String TITLE = "Edit Repository Query";
    private final TaskRepository repository;

    public RepositoryQueryWizard(TaskRepository repository) {
        Assert.isNotNull((Object)repository);
        this.repository = repository;
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(TITLE);
        this.setDefaultPageImageDescriptor(TasksUiImages.BANNER_REPOSITORY);
    }

    public boolean canFinish() {
        IWizardPage currentPage = this.getContainer().getCurrentPage();
        if (currentPage instanceof AbstractRepositoryQueryPage) {
            return currentPage.isPageComplete();
        }
        return false;
    }

    public boolean performFinish() {
        IWizardPage currentPage = this.getContainer().getCurrentPage();
        if (!(currentPage instanceof AbstractRepositoryQueryPage)) {
            StatusHandler.fail((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Current wizard page does not extends AbstractRepositoryQueryPage"));
            return false;
        }
        AbstractRepositoryQueryPage page = (AbstractRepositoryQueryPage)currentPage;
        IRepositoryQuery query = page.getQuery();
        if (query != null) {
            page.applyTo(query);
            if (query instanceof RepositoryQuery) {
                TasksUiPlugin.getTaskList().notifyElementChanged((IRepositoryElement)((RepositoryQuery)query));
            }
        } else {
            query = page.createQuery();
            TasksUiInternal.getTaskList().addQuery((RepositoryQuery)query);
        }
        AbstractRepositoryConnector connector = TasksUi.getRepositoryManager().getRepositoryConnector(this.getTaskRepository().getConnectorKind());
        TasksUiInternal.synchronizeQuery(connector, (RepositoryQuery)query, null, true);
        return true;
    }

    public TaskRepository getTaskRepository() {
        return this.repository;
    }
}

