/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.tasks.ui.RefactorRepositoryUrlOperation;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.AbstractRepositoryConnectorUi;
import org.eclipse.mylyn.tasks.ui.TasksUiImages;
import org.eclipse.mylyn.tasks.ui.wizards.AbstractRepositorySettingsPage;
import org.eclipse.mylyn.tasks.ui.wizards.ITaskRepositoryPage;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class EditRepositoryWizard
extends Wizard
implements INewWizard {
    private static final String TITLE = "Properties for Task Repository";
    private ITaskRepositoryPage settingsPage;
    private final TaskRepository repository;

    public EditRepositoryWizard(TaskRepository repository) {
        this.repository = repository;
        this.setNeedsProgressMonitor(true);
        this.setDefaultPageImageDescriptor(TasksUiImages.BANNER_REPOSITORY_SETTINGS);
        this.setWindowTitle(TITLE);
    }

    public boolean performFinish() {
        if (this.canFinish()) {
            String oldUrl = this.repository.getRepositoryUrl();
            String newUrl = this.settingsPage.getRepositoryUrl();
            if (oldUrl != null && newUrl != null && !oldUrl.equals(newUrl)) {
                TasksUiPlugin.getTaskListManager().deactivateAllTasks();
                RefactorRepositoryUrlOperation operation = new RefactorRepositoryUrlOperation(oldUrl, newUrl);
                try {
                    this.getContainer().run(true, false, (IRunnableWithProgress)operation);
                }
                catch (InvocationTargetException invocationTargetException) {
                    StatusHandler.fail((IStatus)new Status(2, "org.eclipse.mylyn.tasks.ui", "Failed to refactor repository urls"));
                    return false;
                }
                catch (InterruptedException interruptedException) {}
            }
            this.repository.flushAuthenticationCredentials();
            this.repository.setRepositoryUrl(newUrl);
            this.settingsPage.applyTo(this.repository);
            if (oldUrl != null && newUrl != null && !oldUrl.equals(newUrl)) {
                TasksUiPlugin.getRepositoryManager().notifyRepositoryUrlChanged(this.repository, oldUrl);
            }
            TasksUiPlugin.getRepositoryManager().notifyRepositorySettingsChanged(this.repository);
            TasksUiPlugin.getExternalizationManager().requestSave();
            return true;
        }
        return false;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public void addPages() {
        AbstractRepositoryConnectorUi connectorUi = TasksUiPlugin.getConnectorUi(this.repository.getConnectorKind());
        this.settingsPage = connectorUi.getSettingsPage(null);
        if (this.settingsPage instanceof AbstractRepositorySettingsPage) {
            ((AbstractRepositorySettingsPage)this.settingsPage).setRepository(this.repository);
            ((AbstractRepositorySettingsPage)this.settingsPage).setVersion(this.repository.getVersion());
        }
        this.settingsPage.setWizard((IWizard)this);
        this.addPage(this.settingsPage);
    }

    public boolean canFinish() {
        return this.settingsPage.isPageComplete();
    }

    public ITaskRepositoryPage getSettingsPage() {
        return this.settingsPage;
    }

    public TaskRepository getRepository() {
        return this.repository;
    }
}

