/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.util;

import java.io.File;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.mylyn.internal.tasks.ui.util.CopyAttachmentToClipboardJob;
import org.eclipse.mylyn.internal.tasks.ui.util.DownloadAttachmentJob;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.tasks.core.ITaskAttachment;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class TasksUiMenus {
    private static final String ATTACHMENT_DEFAULT_NAME = "attachment";
    private static final String CTYPE_ZIP = "zip";
    private static final String CTYPE_OCTET_STREAM = "octet-stream";
    private static final String CTYPE_TEXT = "text";
    private static final String CTYPE_HTML = "html";
    private static final String LABEL_COPY_URL_TO_CLIPBOARD = "Copy &URL";
    private static final String LABEL_COPY_TO_CLIPBOARD = "Copy Contents";
    private static final String LABEL_SAVE = "Save...";

    public static void fillTaskAttachmentMenu(IMenuManager manager) {
        Action saveAction = new Action(LABEL_SAVE){

            public void run() {
                ITaskAttachment attachment = TasksUiMenus.getSelectedAttachment();
                if (attachment == null) {
                    return;
                }
                FileDialog fileChooser = new FileDialog(TasksUiInternal.getShell(), 8192);
                String fname = attachment.getFileName();
                if (fname.equals("")) {
                    String ctype = attachment.getContentType();
                    fname = ctype.endsWith(TasksUiMenus.CTYPE_HTML) ? "attachment.html" : (ctype.startsWith(TasksUiMenus.CTYPE_TEXT) ? "attachment.txt" : (ctype.endsWith(TasksUiMenus.CTYPE_OCTET_STREAM) ? TasksUiMenus.ATTACHMENT_DEFAULT_NAME : (ctype.endsWith(TasksUiMenus.CTYPE_ZIP) ? "attachment.zip" : "attachment." + ctype.substring(ctype.indexOf("/") + 1))));
                }
                fileChooser.setFileName(fname);
                String filePath = fileChooser.open();
                if (filePath == null) {
                    return;
                }
                File file = new File(filePath);
                if (file.exists() && !MessageDialog.openConfirm((Shell)TasksUiInternal.getShell(), (String)"File exists!", (String)("Overwrite existing file?\n" + file.getName()))) {
                    return;
                }
                DownloadAttachmentJob job = new DownloadAttachmentJob(attachment, file);
                job.setUser(true);
                job.schedule();
            }
        };
        Action copyURLToClipAction = new Action(LABEL_COPY_URL_TO_CLIPBOARD){

            public void run() {
                ITaskAttachment attachment = TasksUiMenus.getSelectedAttachment();
                if (attachment != null) {
                    Clipboard clip = new Clipboard(PlatformUI.getWorkbench().getDisplay());
                    clip.setContents(new Object[]{attachment.getUrl()}, new Transfer[]{TextTransfer.getInstance()});
                    clip.dispose();
                }
            }
        };
        Action copyToClipAction = new Action(LABEL_COPY_TO_CLIPBOARD){

            public void run() {
                ITaskAttachment attachment = TasksUiMenus.getSelectedAttachment();
                if (attachment != null) {
                    CopyAttachmentToClipboardJob job = new CopyAttachmentToClipboardJob(attachment);
                    job.setUser(true);
                    job.schedule();
                }
            }
        };
        manager.add((IContributionItem)new Separator("group.open"));
        manager.add((IContributionItem)new Separator("group.save"));
        manager.add((IAction)saveAction);
        manager.add((IAction)copyURLToClipAction);
        manager.add((IAction)copyToClipAction);
        manager.add((IContributionItem)new Separator("additions"));
    }

    private static ITaskAttachment getSelectedAttachment() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        ISelection windowSelection = window.getSelectionService().getSelection();
        IStructuredSelection selection = null;
        if (windowSelection instanceof IStructuredSelection) {
            selection = (IStructuredSelection)windowSelection;
        }
        if (selection == null || selection.isEmpty()) {
            return null;
        }
        if (selection.getFirstElement() instanceof ITaskAttachment) {
            return (ITaskAttachment)selection.getFirstElement();
        }
        return null;
    }
}

