/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.context.core.ContextCorePlugin;
import org.eclipse.mylyn.internal.context.core.InteractionContextExternalizer;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.AbstractTaskCategory;
import org.eclipse.mylyn.internal.tasks.core.AbstractTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.RepositoryModel;
import org.eclipse.mylyn.internal.tasks.core.RepositoryQuery;
import org.eclipse.mylyn.internal.tasks.core.TaskExternalizationException;
import org.eclipse.mylyn.internal.tasks.core.TaskList;
import org.eclipse.mylyn.internal.tasks.core.TaskRepositoriesExternalizer;
import org.eclipse.mylyn.internal.tasks.core.TaskRepositoryManager;
import org.eclipse.mylyn.internal.tasks.core.deprecated.AbstractTaskListFactory;
import org.eclipse.mylyn.internal.tasks.core.externalization.DelegatingTaskExternalizer;
import org.eclipse.mylyn.tasks.core.AbstractTaskListMigrator;
import org.eclipse.mylyn.tasks.core.IRepositoryManager;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class TaskListElementImporter {
    private static final String TRANSFORM_PROPERTY_VERSION = "version";
    private static final String XML_VERSION = "1.0";
    public static final String ATTRIBUTE_VERSION = "Version";
    public static final String ELEMENT_TASK_LIST = "TaskList";
    private static final String VALUE_VERSION = "1.0.1";
    private static final String VALUE_VERSION_1_0_0 = "1.0.0";
    private static final String FILE_SUFFIX_SAVE = "save.xml";
    private List<AbstractTaskListFactory> externalizers;
    private DelegatingTaskExternalizer delegatingExternalizer;
    private final TaskRepositoriesExternalizer repositoriesExternalizer;
    private final InteractionContextExternalizer contextExternalizer;
    private final List<Node> orphanedTaskNodes = new ArrayList<Node>();
    private final List<Node> orphanedQueryNodes = new ArrayList<Node>();
    private String readVersion = "";
    private boolean hasCaughtException = false;
    private final TaskRepositoryManager repositoryManager;
    private static final String MESSAGE_RESTORE = "Could not read task list.  Consider restoring via File -> Import -> Mylyn Task Data";

    public TaskListElementImporter(TaskRepositoryManager repositoryManager, RepositoryModel repositoryModel) {
        this.repositoryManager = repositoryManager;
        this.delegatingExternalizer = new DelegatingTaskExternalizer(repositoryModel, (IRepositoryManager)repositoryManager);
        this.repositoriesExternalizer = new TaskRepositoriesExternalizer();
        this.contextExternalizer = new InteractionContextExternalizer();
    }

    public void setDelegateExternalizers(List<AbstractTaskListFactory> externalizers, List<AbstractTaskListMigrator> migrators) {
        this.externalizers = externalizers;
        this.delegatingExternalizer.initialize(externalizers, migrators);
    }

    public void setDelegateExternalizers(List<AbstractTaskListFactory> externalizers) {
        this.externalizers = externalizers;
        this.delegatingExternalizer.initialize(externalizers, new ArrayList(0));
    }

    public void writeTaskList(TaskList taskList, File outFile) {
        try {
            FileOutputStream outStream = new FileOutputStream(outFile);
            try {
                this.writeTaskList(taskList, outStream);
            }
            finally {
                outStream.close();
            }
        }
        catch (Exception e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Task data was not written", (Throwable)e));
        }
    }

    public void writeTaskList(TaskList taskList, OutputStream outputStream) throws IOException {
        Node tempNode;
        Document doc = this.createTaskListDocument();
        if (doc == null) {
            return;
        }
        Element root = this.createTaskListRoot(doc);
        for (AbstractTask task : taskList.getAllTasks()) {
            this.delegatingExternalizer.createTaskElement(task, doc, root);
        }
        for (AbstractTaskCategory category : taskList.getCategories()) {
            this.delegatingExternalizer.createCategoryElement(category, doc, root);
        }
        for (RepositoryQuery query : taskList.getQueries()) {
            try {
                this.delegatingExternalizer.createQueryElement(query, doc, root);
            }
            catch (Throwable t) {
                StatusHandler.fail((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Did not externalize: " + query.getSummary(), t));
            }
        }
        for (Node orphanedTaskNode : this.orphanedTaskNodes) {
            tempNode = doc.importNode(orphanedTaskNode, true);
            if (tempNode == null) continue;
            root.appendChild(tempNode);
        }
        for (Node orphanedQueryNode : this.orphanedQueryNodes) {
            tempNode = doc.importNode(orphanedQueryNode, true);
            if (tempNode == null) continue;
            root.appendChild(tempNode);
        }
        ZipOutputStream zipOutStream = new ZipOutputStream(outputStream);
        this.writeTaskList(doc, zipOutStream);
        zipOutStream.finish();
    }

    private void writeTaskList(Document doc, ZipOutputStream outputStream) throws IOException {
        ZipEntry zipEntry = new ZipEntry("tasklist.xml");
        outputStream.putNextEntry(zipEntry);
        outputStream.setMethod(8);
        this.writeDOMtoStream(doc, outputStream);
        outputStream.flush();
        outputStream.closeEntry();
    }

    private void writeDOMtoStream(Document doc, OutputStream outputStream) {
        DOMSource source = new DOMSource(doc);
        StreamResult result = new StreamResult(outputStream);
        Transformer xformer = null;
        try {
            xformer = TransformerFactory.newInstance().newTransformer();
            xformer.setOutputProperty(TRANSFORM_PROPERTY_VERSION, XML_VERSION);
            xformer.transform(source, result);
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
        }
        catch (TransformerFactoryConfigurationError e) {
            e.printStackTrace();
        }
        catch (TransformerException e1) {
            e1.printStackTrace();
        }
    }

    @Deprecated
    public void readTaskList(TaskList taskList, File inFile) {
        block24: {
            this.hasCaughtException = false;
            this.delegatingExternalizer.getLegacyParentCategoryMap().clear();
            HashMap<AbstractTask, NodeList> tasksWithSubtasks = new HashMap<AbstractTask, NodeList>();
            this.orphanedTaskNodes.clear();
            this.orphanedQueryNodes.clear();
            try {
                Object child;
                if (!inFile.exists()) {
                    return;
                }
                Document doc = this.openAsDOM(inFile, false);
                if (doc == null) {
                    this.handleException(inFile, null, (Exception)new TaskExternalizationException("TaskList was not well formed XML"));
                    return;
                }
                Element root = doc.getDocumentElement();
                this.readVersion = root.getAttribute(ATTRIBUTE_VERSION);
                if (this.readVersion.equals(VALUE_VERSION_1_0_0)) {
                    StatusHandler.log((IStatus)new Status(1, "org.eclipse.mylyn.tasks.ui", "Task list version \"" + this.readVersion + "\" not supported"));
                    break block24;
                }
                NodeList list = root.getChildNodes();
                int i = 0;
                while (i < list.getLength()) {
                    child = list.item(i);
                    try {
                        if (!child.getNodeName().endsWith("Category") && !child.getNodeName().endsWith("Query")) {
                            AbstractTask task = this.delegatingExternalizer.readTask((Node)child, null, null);
                            if (task == null) {
                                this.orphanedTaskNodes.add((Node)child);
                            } else {
                                taskList.addTask((ITask)task);
                                if (child.getChildNodes() != null && child.getChildNodes().getLength() > 0) {
                                    tasksWithSubtasks.put(task, child.getChildNodes());
                                }
                            }
                        }
                    }
                    catch (Exception e) {
                        this.handleException(inFile, (Node)child, e);
                    }
                    ++i;
                }
                for (AbstractTask task : tasksWithSubtasks.keySet()) {
                    NodeList nodes = (NodeList)tasksWithSubtasks.get(task);
                    this.delegatingExternalizer.readTaskReferences((AbstractTaskContainer)task, nodes, taskList);
                }
                i = 0;
                while (i < list.getLength()) {
                    child = list.item(i);
                    try {
                        if (child.getNodeName().endsWith("Query")) {
                            this.delegatingExternalizer.readQuery((Node)child);
                        }
                    }
                    catch (Exception e) {
                        this.handleException(inFile, (Node)child, e);
                    }
                    ++i;
                }
                i = 0;
                while (i < list.getLength()) {
                    child = list.item(i);
                    try {
                        if (child.getNodeName().endsWith("Category")) {
                            this.delegatingExternalizer.readCategory((Node)child, taskList);
                        }
                    }
                    catch (Exception e) {
                        this.handleException(inFile, (Node)child, e);
                    }
                    ++i;
                }
                if (this.delegatingExternalizer.getLegacyParentCategoryMap().size() > 0) {
                    for (AbstractTask task : this.delegatingExternalizer.getLegacyParentCategoryMap().keySet()) {
                        AbstractTaskCategory category = taskList.getContainerForHandle((String)this.delegatingExternalizer.getLegacyParentCategoryMap().get(task));
                        if (category == null) continue;
                        taskList.addTask((ITask)task, (AbstractTaskContainer)category);
                    }
                }
            }
            catch (Exception e) {
                this.handleException(inFile, null, e);
            }
        }
        if (this.hasCaughtException) {
            this.writeTaskList(taskList, inFile);
        }
    }

    private Document createTaskListDocument() {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        Document doc = null;
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            doc = db.newDocument();
        }
        catch (ParserConfigurationException e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Could not create document", (Throwable)e));
            return doc;
        }
        return doc;
    }

    private Element createTaskListRoot(Document doc) {
        Element root = doc.createElement(ELEMENT_TASK_LIST);
        root.setAttribute(ATTRIBUTE_VERSION, VALUE_VERSION);
        doc.appendChild(root);
        return root;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Document openAsDOM(File inputFile, boolean propagateException) throws IOException {
        void var6_10;
        Document document;
        DocumentBuilder builder;
        block7: {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            builder = null;
            document = null;
            try {
                builder = factory.newDocumentBuilder();
            }
            catch (ParserConfigurationException parserConfigurationException) {
                inputFile.renameTo(new File(String.valueOf(inputFile.getName()) + FILE_SUFFIX_SAVE));
                IOException ioe = new IOException("Failed to load XML file");
                ioe.initCause(parserConfigurationException);
                throw ioe;
            }
            Object var6_7 = null;
            if (!inputFile.getName().endsWith(".xml.zip")) break block7;
            ZipInputStream zipInputStream = new ZipInputStream(new FileInputStream(inputFile));
            ZipEntry entry = zipInputStream.getNextEntry();
            while (entry != null) {
                if ("tasklist.xml".equals(entry.getName())) break;
                entry = zipInputStream.getNextEntry();
            }
            if (entry != null) return builder.parse((InputStream)var6_10);
            return null;
        }
        try {
            FileInputStream fileInputStream = new FileInputStream(inputFile);
            return builder.parse((InputStream)var6_10);
        }
        catch (SAXException sAXException) {
            if (propagateException) {
                throw new IOException("The task list format is invalid");
            }
            MessageDialog.openWarning(null, (String)"Mylyn task list corrupt", (String)"Unable to read the Mylyn task list. Please restore from previous backup via File > Import > Mylyn Task Data");
        }
        return document;
    }

    private void handleException(File inFile, Node child, Exception e) {
        this.hasCaughtException = true;
        String name = inFile.getAbsolutePath();
        Date date = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat();
        sdf.applyPattern("yy-MM-dd-ss");
        name = String.valueOf(name.substring(0, name.lastIndexOf(46))) + "-failed-" + sdf.format(date) + ".zip";
        File save = new File(name);
        if (save.exists() && !save.delete()) {
            StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.tasks.ui", "Unable to delete old backup tasklist file"));
            return;
        }
        if (!this.copy(inFile, save)) {
            inFile.renameTo(new File(name));
        }
        if (child == null) {
            StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.tasks.ui", MESSAGE_RESTORE, (Throwable)e));
        } else {
            StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.tasks.ui", "Tasks may have been lost from " + child.getNodeName(), (Throwable)e));
        }
    }

    private boolean copy(File src, File dst) {
        try {
            int len;
            FileInputStream in = new FileInputStream(src);
            FileOutputStream out = new FileOutputStream(dst);
            byte[] buf = new byte[1024];
            while ((len = ((InputStream)in).read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            ((InputStream)in).close();
            ((OutputStream)out).close();
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public void setDelegatingExternalizer(DelegatingTaskExternalizer delagatingExternalizer) {
        this.delegatingExternalizer = delagatingExternalizer;
    }

    public List<AbstractTaskListFactory> getExternalizers() {
        return this.externalizers;
    }

    public void writeQueries(List<RepositoryQuery> queries, File outFile) {
        HashSet<TaskRepository> repositories = new HashSet<TaskRepository>();
        for (IRepositoryQuery iRepositoryQuery : queries) {
            TaskRepository repository = TasksUi.getRepositoryManager().getRepository(iRepositoryQuery.getConnectorKind(), iRepositoryQuery.getRepositoryUrl());
            if (repository == null) continue;
            repositories.add(repository);
        }
        Document document = this.createQueryDocument(queries);
        if (document != null) {
            try {
                ZipOutputStream outputStream = new ZipOutputStream(new FileOutputStream(outFile));
                this.writeTaskList(document, outputStream);
                this.repositoriesExternalizer.writeRepositories(repositories, outputStream);
                outputStream.close();
            }
            catch (Exception e) {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Task list could not be found", (Throwable)e));
            }
        }
    }

    public Document createQueryDocument(List<RepositoryQuery> queries) {
        Document doc = this.createTaskListDocument();
        if (doc == null) {
            return null;
        }
        Element root = this.createTaskListRoot(doc);
        for (RepositoryQuery query : queries) {
            try {
                this.delegatingExternalizer.createQueryElement(query, doc, root);
            }
            catch (Throwable t) {
                StatusHandler.fail((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Did not externalize: " + query.getSummary(), t));
                return null;
            }
        }
        return doc;
    }

    public List<RepositoryQuery> readQueries(File inFile) throws IOException {
        if (!inFile.exists()) {
            throw new FileNotFoundException("File does not exist: " + inFile);
        }
        Document doc = this.openAsDOM(inFile, true);
        if (doc == null) {
            throw new IOException("TaskList was not well formed XML");
        }
        return this.readQueryDocument(doc);
    }

    public List<RepositoryQuery> readQueryDocument(Document doc) {
        ArrayList<RepositoryQuery> queries = new ArrayList<RepositoryQuery>();
        Element root = doc.getDocumentElement();
        this.readVersion = root.getAttribute(ATTRIBUTE_VERSION);
        if (!this.readVersion.equals(VALUE_VERSION_1_0_0)) {
            NodeList list = root.getChildNodes();
            int i = 0;
            while (i < list.getLength()) {
                Node child = list.item(i);
                try {
                    RepositoryQuery query;
                    if (child.getNodeName().endsWith("Query") && (query = this.delegatingExternalizer.readQuery(child)) != null) {
                        queries.add(query);
                    }
                }
                catch (Exception e) {
                    StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.tasks.ui", "Tasks may have been lost from " + child.getNodeName(), (Throwable)e));
                }
                ++i;
            }
        } else {
            StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.tasks.ui", "Version \"" + this.readVersion + "\" not supported"));
        }
        return queries;
    }

    public Set<TaskRepository> readRepositories(File file) {
        HashSet repository = this.repositoriesExternalizer.readRepositoriesFromXML(file);
        if (repository == null) {
            repository = new HashSet();
        }
        return repository;
    }

    public void writeTask(AbstractTask task, File outFile) {
        try {
            this.writeTask(task, new FileOutputStream(outFile));
        }
        catch (Exception e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Task data was not written", (Throwable)e));
        }
    }

    public void writeTask(AbstractTask task, OutputStream stream) {
        Document doc;
        HashSet<TaskRepository> repositories = new HashSet<TaskRepository>();
        if (!task.isLocal()) {
            repositories.add(this.repositoryManager.getRepository(task.getConnectorKind(), task.getRepositoryUrl()));
        }
        if ((doc = this.createTaskListDocument()) == null) {
            return;
        }
        Element root = this.createTaskListRoot(doc);
        this.delegatingExternalizer.createTaskElement(task, doc, root);
        try {
            ZipOutputStream outputStream = new ZipOutputStream(stream);
            this.writeTaskList(doc, outputStream);
            ContextCorePlugin.getContextStore().export(task.getHandleIdentifier(), outputStream);
            if (repositories.size() > 0) {
                this.repositoriesExternalizer.writeRepositories(repositories, outputStream);
            }
            outputStream.close();
        }
        catch (Exception e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Task data was not written", (Throwable)e));
        }
    }

    public List<AbstractTask> readTasks(File inFile) {
        ArrayList<AbstractTask> tasks;
        block9: {
            tasks = new ArrayList<AbstractTask>();
            try {
                if (!inFile.exists()) {
                    return tasks;
                }
                Document doc = this.openAsDOM(inFile, false);
                if (doc == null) {
                    this.handleException(inFile, null, (Exception)new TaskExternalizationException("TaskList was not well formed XML"));
                    return tasks;
                }
                Element root = doc.getDocumentElement();
                this.readVersion = root.getAttribute(ATTRIBUTE_VERSION);
                if (!this.readVersion.equals(VALUE_VERSION_1_0_0)) {
                    NodeList list = root.getChildNodes();
                    int i = 0;
                    while (i < list.getLength()) {
                        Node child = list.item(i);
                        try {
                            AbstractTask task;
                            if (!child.getNodeName().endsWith("Category") && !child.getNodeName().endsWith("Query") && (task = this.delegatingExternalizer.readTask(child, null, null)) != null) {
                                tasks.add(task);
                            }
                        }
                        catch (Exception e) {
                            StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.tasks.ui", "Tasks may have been lost from " + child.getNodeName(), (Throwable)e));
                        }
                        ++i;
                    }
                    break block9;
                }
                StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.tasks.ui", "Version \"" + this.readVersion + "\" not supported"));
            }
            catch (Exception e) {
                this.handleException(inFile, null, e);
            }
        }
        return tasks;
    }
}

