/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.util;

import java.io.ByteArrayOutputStream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.mylyn.internal.tasks.ui.util.AttachmentUtil;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.tasks.core.ITaskAttachment;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.ui.PlatformUI;

public class CopyAttachmentToClipboardJob
extends Job {
    private final ITaskAttachment attachment;

    public CopyAttachmentToClipboardJob(ITaskAttachment attachment) {
        super("Copying Attachment to Clipboard");
        this.attachment = attachment;
    }

    protected IStatus run(IProgressMonitor monitor) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            AttachmentUtil.downloadAttachment(this.attachment, out, monitor);
        }
        catch (CoreException e) {
            TasksUiInternal.asyncDisplayStatus("Copy Attachment to Clipboard", e.getStatus());
            return Status.OK_STATUS;
        }
        String contents = new String(out.toByteArray());
        contents = contents.replaceAll("\r\n|\n", System.getProperty("line.separator"));
        this.copyToClipboard(contents);
        return Status.OK_STATUS;
    }

    private void copyToClipboard(final String contents) {
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            public void run() {
                Clipboard clipboard = new Clipboard(PlatformUI.getWorkbench().getDisplay());
                clipboard.setContents(new Object[]{contents}, new Transfer[]{TextTransfer.getInstance()});
                clipboard.dispose();
            }
        });
    }
}

