/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.search;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.internal.tasks.core.ITaskList;
import org.eclipse.mylyn.internal.tasks.ui.search.RepositorySearchResult;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.RepositoryStatus;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.core.data.TaskDataCollector;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.search.ui.text.Match;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchHitCollector
extends TaskDataCollector
implements ISearchQuery {
    private static final String LABEL_MAX_HITS_REACHED = "Max allowed number of hits returned exceeded. Some hits may not be displayed. Please narrow query scope.";
    private static final String QUERYING_REPOSITORY = "Querying Repository...";
    private final Set<ITask> taskResults = new HashSet<ITask>();
    private final ITaskList taskList;
    private final TaskRepository repository;
    private final IRepositoryQuery repositoryQuery;
    private final RepositorySearchResult searchResult;
    private AbstractRepositoryConnector connector;

    public SearchHitCollector(ITaskList tasklist, TaskRepository repository, IRepositoryQuery repositoryQuery) {
        this.taskList = tasklist;
        this.repository = repository;
        this.repositoryQuery = repositoryQuery;
        this.searchResult = new RepositorySearchResult(this);
    }

    public void aboutToStart() {
        this.taskResults.clear();
        this.searchResult.removeAll();
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            public void run() {
                NewSearchUI.activateSearchResultView();
            }
        });
    }

    public void accept(TaskData taskData) {
        ITask task = this.taskList.getTask(this.repository.getRepositoryUrl(), taskData.getTaskId());
        if (task == null) {
            task = TasksUi.getRepositoryModel().createTask(this.repository, taskData.getTaskId());
            if (this.connector != null) {
                this.connector.updateTaskFromTaskData(this.repository, task, taskData);
            }
        }
        this.taskResults.add(task);
        this.searchResult.addMatch(new Match((Object)task, 0, 0));
    }

    public String getLabel() {
        return QUERYING_REPOSITORY;
    }

    public boolean canRerun() {
        return true;
    }

    public boolean canRunInBackground() {
        return true;
    }

    public ISearchResult getSearchResult() {
        if (this.searchResult.getMatchCount() >= 5000) {
            TasksUiInternal.displayStatus("Maximum hits reached", (IStatus)RepositoryStatus.createStatus((String)this.repository.getRepositoryUrl(), (int)2, (String)"org.eclipse.mylyn.tasks.ui", (String)LABEL_MAX_HITS_REACHED));
        }
        return this.searchResult;
    }

    public IStatus run(IProgressMonitor monitor) throws OperationCanceledException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        this.aboutToStart();
        if (monitor.isCanceled()) {
            throw new OperationCanceledException("Search cancelled");
        }
        this.connector = TasksUi.getRepositoryManager().getRepositoryConnector(this.repositoryQuery.getConnectorKind());
        if (this.connector != null) {
            final IStatus status = this.connector.performQuery(this.repository, this.repositoryQuery, (TaskDataCollector)this, null, monitor);
            if (!status.isOK()) {
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        TasksUiInternal.displayStatus("Search failed", status);
                    }
                });
            }
        } else {
            return new Status(4, "org.eclipse.mylyn.tasks.ui", 0, "repository connector could not be found", null);
        }
        return Status.OK_STATUS;
    }

    public Set<ITask> getTasks() {
        return this.taskResults;
    }

    public IRepositoryQuery getRepositoryQuery() {
        return this.repositoryQuery;
    }
}

