/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.search;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.mylyn.internal.provisional.commons.ui.SubstringPatternFilter;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.AbstractTaskCategory;
import org.eclipse.mylyn.internal.tasks.core.TaskGroup;
import org.eclipse.mylyn.internal.tasks.core.UnmatchedTaskContainer;
import org.eclipse.mylyn.internal.tasks.ui.AddExistingTaskJob;
import org.eclipse.mylyn.internal.tasks.ui.actions.OpenTaskSearchAction;
import org.eclipse.mylyn.internal.tasks.ui.search.CreateQueryFromSearchAction;
import org.eclipse.mylyn.internal.tasks.ui.search.OpenSearchResultAction;
import org.eclipse.mylyn.internal.tasks.ui.search.SearchResultContentProvider;
import org.eclipse.mylyn.internal.tasks.ui.search.SearchResultSortAction;
import org.eclipse.mylyn.internal.tasks.ui.search.SearchResultSorterDescription;
import org.eclipse.mylyn.internal.tasks.ui.search.SearchResultSorterId;
import org.eclipse.mylyn.internal.tasks.ui.search.SearchResultSorterPriority;
import org.eclipse.mylyn.internal.tasks.ui.search.SearchResultTreeContentProvider;
import org.eclipse.mylyn.internal.tasks.ui.search.SearchResultsLabelProvider;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskListToolTip;
import org.eclipse.mylyn.tasks.core.IRepositoryElement;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.mylyn.tasks.ui.TasksUiImages;
import org.eclipse.search.internal.ui.SearchMessages;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.text.AbstractTextSearchViewPage;
import org.eclipse.search.ui.text.Match;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.part.IShowInTargetList;
import org.eclipse.ui.progress.IProgressService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositorySearchResultView
extends AbstractTextSearchViewPage
implements IAdaptable {
    public static final int ORDER_PRIORITY = 1;
    public static final int ORDER_DESCRIPTION = 2;
    public static final int ORDER_SEVERITY = 3;
    public static final int ORDER_STATUS = 4;
    public static final int ORDER_ID = 5;
    public static final int ORDER_DEFAULT = 1;
    private static final String KEY_SORTING = "org.eclipse.mylyn.tasks.ui.search.resultpage.sorting";
    private SearchResultContentProvider searchResultProvider;
    private int currentSortOrder = 1;
    private final SearchResultSortAction sortByPriorityAction = new SearchResultSortAction("Task Priority", this, 1);
    private final SearchResultSortAction sortByDescriptionAction = new SearchResultSortAction("Task Summary", this, 2);
    private final OpenSearchResultAction openInEditorAction = new OpenSearchResultAction("Open in Editor", this);
    private final CreateQueryFromSearchAction addTaskListAction = new CreateQueryFromSearchAction("Create Query from Search...", this);
    private final Action refineSearchAction = new OpenTaskSearchAction();
    private static final String[] SHOW_IN_TARGETS = new String[]{"org.eclipse.ui.views.ResourceNavigator"};
    private TaskListToolTip toolTip;
    private final List<GroupingAction> groupingActions;
    private final List<FilteringAction> filterActions;
    private static final IShowInTargetList SHOW_IN_TARGET_LIST = new IShowInTargetList(){

        public String[] getShowInTargetIds() {
            return SHOW_IN_TARGETS;
        }
    };

    public RepositorySearchResultView() {
        super(2);
        this.refineSearchAction.setText("Refine Search...");
        this.groupingActions = new ArrayList<GroupingAction>();
        new GroupingAction("Group By Owner", SearchResultTreeContentProvider.GroupBy.OWNER);
        this.filterActions = new ArrayList<FilteringAction>();
        new FilteringAction("Filter Completed Tasks", new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof ITask) {
                    return !((ITask)element).isCompleted();
                }
                if (element instanceof TaskGroup) {
                    TaskGroup taskGroup = (TaskGroup)element;
                    return taskGroup.getHandleIdentifier().equals("group-incompleteIncomplete");
                }
                return true;
            }
        });
    }

    protected void elementsChanged(Object[] objects) {
        if (this.searchResultProvider != null) {
            this.searchResultProvider.elementsChanged(objects);
            this.getViewer().refresh();
        }
    }

    protected void clear() {
        if (this.searchResultProvider != null) {
            this.searchResultProvider.clear();
            this.getViewer().refresh();
        }
    }

    public StructuredViewer getViewer() {
        return super.getViewer();
    }

    protected void configureTreeViewer(TreeViewer viewer) {
        viewer.setUseHashlookup(true);
        this.searchResultProvider = new SearchResultTreeContentProvider();
        viewer.setContentProvider((IContentProvider)this.searchResultProvider);
        DecoratingLabelProvider labelProvider = new DecoratingLabelProvider((ILabelProvider)new SearchResultsLabelProvider(this.searchResultProvider, viewer), PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator());
        viewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.setSortOrder(this.currentSortOrder);
        this.toolTip = new TaskListToolTip(viewer.getControl());
    }

    protected TreeViewer createTreeViewer(Composite parent) {
        Composite treeComposite = parent;
        Layout parentLayout = parent.getLayout();
        if (!(parentLayout instanceof GridLayout)) {
            treeComposite = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            treeComposite.setLayout((Layout)layout);
        }
        FilteredTree searchTree = new FilteredTree(treeComposite, 770, (PatternFilter)new SubstringPatternFilter());
        return searchTree.getViewer();
    }

    protected void configureTableViewer(TableViewer viewer) {
    }

    public void dispose() {
        this.toolTip.dispose();
        super.dispose();
    }

    public void setSortOrder(int sortOrder) {
        StructuredViewer viewer = this.getViewer();
        switch (sortOrder) {
            case 5: {
                viewer.setSorter((ViewerSorter)new SearchResultSorterId());
                break;
            }
            case 2: {
                viewer.setSorter((ViewerSorter)new SearchResultSorterDescription());
                break;
            }
            case 1: {
                viewer.setSorter((ViewerSorter)new SearchResultSorterPriority());
                break;
            }
            default: {
                sortOrder = 1;
                viewer.setSorter((ViewerSorter)new SearchResultSorterPriority());
            }
        }
        this.currentSortOrder = sortOrder;
        this.getSettings().put(KEY_SORTING, this.currentSortOrder);
    }

    public Object getAdapter(Class adapter) {
        return this.getAdapterDelegate(adapter);
    }

    private Object getAdapterDelegate(Class<?> adapter) {
        if (IShowInTargetList.class.equals(adapter)) {
            return SHOW_IN_TARGET_LIST;
        }
        return null;
    }

    protected void showMatch(Match match, int currentOffset, int currentLength, boolean activate) throws PartInitException {
        AbstractTask repositoryHit = (AbstractTask)match.getElement();
        TasksUiInternal.refreshAndOpenTaskListElement((IRepositoryElement)repositoryHit);
    }

    protected void fillContextMenu(IMenuManager menuManager) {
        super.fillContextMenu(menuManager);
        MenuManager sortMenuManager = new MenuManager(SearchMessages.SortDropDownAction_label);
        sortMenuManager.add((IAction)this.sortByPriorityAction);
        sortMenuManager.add((IAction)this.sortByDescriptionAction);
        this.sortByPriorityAction.setChecked(this.currentSortOrder == this.sortByPriorityAction.getSortOrder());
        this.sortByDescriptionAction.setChecked(this.currentSortOrder == this.sortByDescriptionAction.getSortOrder());
        menuManager.appendToGroup("group.viewerSetup", (IContributionItem)sortMenuManager);
        for (Action action : this.groupingActions) {
            menuManager.appendToGroup("group.viewerSetup", (IAction)action);
        }
        for (Action action : this.filterActions) {
            menuManager.appendToGroup("group.viewerSetup", (IAction)action);
        }
        menuManager.appendToGroup("group.open", (IAction)this.openInEditorAction);
        menuManager.appendToGroup("group.open", (IAction)this.addTaskListAction);
        menuManager.appendToGroup("group.open", (IAction)this.refineSearchAction);
        MenuManager menuManager2 = new MenuManager("Add to Task List Category");
        ArrayList categories = new ArrayList(TasksUiInternal.getTaskList().getCategories());
        Collections.sort(categories);
        for (final AbstractTaskCategory category : categories) {
            if (category instanceof UnmatchedTaskContainer) continue;
            Action action = new Action(){

                public void run() {
                    RepositorySearchResultView.this.moveToCategory(category);
                }
            };
            String text = category.getSummary();
            action.setText(text);
            action.setImageDescriptor(TasksUiImages.CATEGORY);
            menuManager2.add((IAction)action);
        }
        menuManager.appendToGroup("group.open", (IContributionItem)menuManager2);
    }

    private void moveToCategory(AbstractTaskCategory category) {
        final IProgressService progressService = PlatformUI.getWorkbench().getProgressService();
        StructuredSelection selection = (StructuredSelection)this.getViewer().getSelection();
        for (Object selectedObject : selection) {
            if (!(selectedObject instanceof ITask)) continue;
            ITask task = (ITask)selectedObject;
            TaskRepository repository = TasksUi.getRepositoryManager().getRepository(task.getConnectorKind(), task.getRepositoryUrl());
            final AddExistingTaskJob job = new AddExistingTaskJob(repository, task.getTaskId(), category);
            job.schedule();
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    progressService.showInDialog(RepositorySearchResultView.this.getSite().getShell(), (Job)job);
                }
            });
        }
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        IMenuManager menuManager = this.getSite().getActionBars().getMenuManager();
        for (Action action : this.groupingActions) {
            menuManager.appendToGroup("group.viewerSetup", (IAction)action);
        }
        menuManager.appendToGroup("group.viewerSetup", (IContributionItem)new Separator());
        for (Action action : this.filterActions) {
            menuManager.appendToGroup("group.viewerSetup", (IAction)action);
        }
    }

    public void setInput(ISearchResult newSearch, Object viewState) {
        super.setInput(newSearch, viewState);
    }

    private class FilteringAction
    extends Action {
        private final ViewerFilter filter;

        public FilteringAction(String text, ViewerFilter filter) {
            super(text, 2);
            this.filter = filter;
            RepositorySearchResultView.this.filterActions.add(this);
        }

        public void runWithEvent(Event event) {
            if (this.isChecked()) {
                RepositorySearchResultView.this.getViewer().addFilter(this.filter);
            } else {
                RepositorySearchResultView.this.getViewer().removeFilter(this.filter);
            }
        }
    }

    private class GroupingAction
    extends Action {
        private final SearchResultTreeContentProvider.GroupBy groupBy;

        public GroupingAction(String text, SearchResultTreeContentProvider.GroupBy groupBy) {
            super(text, 2);
            this.groupBy = groupBy;
            RepositorySearchResultView.this.groupingActions.add(this);
        }

        public SearchResultTreeContentProvider.GroupBy getGroupBy() {
            return this.groupBy;
        }

        public void run() {
            for (GroupingAction action : RepositorySearchResultView.this.groupingActions) {
                action.setChecked(false);
            }
            SearchResultTreeContentProvider contentProvider = (SearchResultTreeContentProvider)RepositorySearchResultView.this.getViewer().getContentProvider();
            if (contentProvider.getSelectedGroup() == this.groupBy) {
                contentProvider.setSelectedGroup(SearchResultTreeContentProvider.GroupBy.NONE);
            } else {
                contentProvider.setSelectedGroup(this.groupBy);
                this.setChecked(true);
            }
            RepositorySearchResultView.this.getViewer().refresh();
        }
    }
}

