/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.editors;

import org.eclipse.mylyn.internal.tasks.ui.editors.EditorUtil;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskDataModel;
import org.eclipse.mylyn.tasks.ui.editors.AbstractAttributeEditor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class TextAttributeEditor
extends AbstractAttributeEditor {
    private Text text;

    public TextAttributeEditor(TaskDataModel manager, TaskAttribute taskAttribute) {
        super(manager, taskAttribute);
    }

    protected Text getText() {
        return this.text;
    }

    public void createControl(Composite parent, FormToolkit toolkit) {
        if (this.isReadOnly()) {
            this.text = new Text(parent, 0x800008);
            this.text.setFont(EditorUtil.TEXT_FONT);
            this.text.setData("FormWidgetFactory.drawBorder", (Object)Boolean.FALSE);
            this.text.setText(this.getValue());
        } else {
            this.text = toolkit.createText(parent, this.getValue(), 0x800000);
            this.text.setFont(EditorUtil.TEXT_FONT);
            this.text.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    TextAttributeEditor.this.setValue(TextAttributeEditor.this.text.getText());
                    EditorUtil.ensureVisible((Control)TextAttributeEditor.this.text);
                }
            });
        }
        toolkit.adapt((Control)this.text, false, false);
        this.setControl((Control)this.text);
    }

    public String getValue() {
        return this.getAttributeMapper().getValue(this.getTaskAttribute());
    }

    public void setValue(String text) {
        this.getAttributeMapper().setValue(this.getTaskAttribute(), text);
        this.attributeChanged();
    }
}

