/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.editors;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.mylyn.internal.tasks.ui.notifications.TaskDiffUtil;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.internal.tasks.ui.views.UpdateRepositoryConfigurationAction;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMetaData;
import org.eclipse.mylyn.tasks.core.sync.TaskJob;
import org.eclipse.mylyn.tasks.ui.TasksUiImages;
import org.eclipse.mylyn.tasks.ui.editors.AbstractAttributeEditor;
import org.eclipse.mylyn.tasks.ui.editors.AbstractTaskEditorPart;
import org.eclipse.mylyn.tasks.ui.editors.LayoutHint;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class TaskEditorAttributePart
extends AbstractTaskEditorPart {
    private static final int LABEL_WIDTH = 100;
    private static final int COLUMN_WIDTH = 140;
    private static final int COLUMN_GAP = 5;
    private static final int MULTI_COLUMN_WIDTH = 395;
    private static final int MULTI_ROW_HEIGHT = 55;
    private List<AbstractAttributeEditor> attributeEditors;
    private boolean hasIncoming;
    private Composite attributesComposite;

    public TaskEditorAttributePart() {
        this.setPartName("Attributes");
    }

    private void createAttributeControls(Composite attributesComposite, FormToolkit toolkit, int columnCount) {
        int currentColumn = 1;
        int currentPriority = 0;
        for (AbstractAttributeEditor attributeEditor : this.attributeEditors) {
            int priority;
            int n = priority = attributeEditor.getLayoutHint() != null ? attributeEditor.getLayoutHint().getPriority() : 10;
            if (priority != currentPriority) {
                currentPriority = priority;
                if (currentColumn > 1) {
                    while (currentColumn <= columnCount) {
                        this.getManagedForm().getToolkit().createLabel(attributesComposite, "");
                        ++currentColumn;
                    }
                    currentColumn = 1;
                }
            }
            if (attributeEditor.hasLabel()) {
                attributeEditor.createLabelControl(attributesComposite, toolkit);
                Label label = attributeEditor.getLabelControl();
                String text = label.getText();
                String shortenText = TaskDiffUtil.shortenText((Drawable)label, text, 100);
                label.setText(shortenText);
                if (!text.equals(shortenText)) {
                    label.setToolTipText(text);
                }
                GridData gd = GridDataFactory.fillDefaults().align(131072, 0x1000000).hint(100, -1).create();
                if (currentColumn > 1) {
                    gd.horizontalIndent = 5;
                    gd.widthHint = 105;
                }
                label.setLayoutData((Object)gd);
                ++currentColumn;
            }
            attributeEditor.createControl(attributesComposite, toolkit);
            LayoutHint layoutHint = attributeEditor.getLayoutHint();
            GridData gd = new GridData(4, 0x1000000, false, false);
            if (layoutHint != null && (layoutHint.rowSpan != LayoutHint.RowSpan.SINGLE || layoutHint.columnSpan != LayoutHint.ColumnSpan.SINGLE)) {
                if (layoutHint.rowSpan == LayoutHint.RowSpan.MULTIPLE) {
                    gd.heightHint = 55;
                }
                if (layoutHint.columnSpan == LayoutHint.ColumnSpan.SINGLE) {
                    gd.widthHint = 140;
                    gd.horizontalSpan = 1;
                } else {
                    gd.widthHint = 395;
                    gd.horizontalSpan = columnCount - currentColumn + 1;
                }
            } else {
                gd.widthHint = 140;
                gd.horizontalSpan = 1;
            }
            attributeEditor.getControl().setLayoutData((Object)gd);
            this.getTaskEditorPage().getAttributeEditorToolkit().adapt(attributeEditor);
            currentColumn += gd.horizontalSpan;
            currentColumn %= columnCount;
        }
    }

    public void createControl(Composite parent, final FormToolkit toolkit) {
        this.initialize();
        boolean expand = this.getTaskData().isNew() || this.hasIncoming;
        final Section section = this.createSection(parent, toolkit, expand);
        if (expand) {
            this.expandSection(toolkit, section);
        } else {
            section.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

                public void expansionStateChanged(ExpansionEvent event) {
                    if (TaskEditorAttributePart.this.attributesComposite == null) {
                        TaskEditorAttributePart.this.expandSection(toolkit, section);
                        TaskEditorAttributePart.this.getTaskEditorPage().reflow();
                    }
                }
            });
        }
        this.setSection(toolkit, section);
    }

    private void expandSection(FormToolkit toolkit, Section section) {
        this.attributesComposite = toolkit.createComposite((Composite)section);
        this.attributesComposite.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                Control focus = event.display.getFocusControl();
                if (focus instanceof Text && !((Text)focus).getEditable()) {
                    TaskEditorAttributePart.this.getManagedForm().getForm().setFocus();
                }
            }
        });
        GridLayout attributesLayout = new GridLayout();
        attributesLayout.numColumns = 4;
        attributesLayout.horizontalSpacing = 5;
        attributesLayout.verticalSpacing = 6;
        this.attributesComposite.setLayout((Layout)attributesLayout);
        GridData attributesData = new GridData(1808);
        attributesData.horizontalSpan = 1;
        attributesData.grabExcessVerticalSpace = false;
        this.attributesComposite.setLayoutData((Object)attributesData);
        this.createAttributeControls(this.attributesComposite, toolkit, attributesLayout.numColumns);
        toolkit.paintBordersFor(this.attributesComposite);
        section.setClient((Control)this.attributesComposite);
    }

    protected void fillToolBar(ToolBarManager toolBar) {
        UpdateRepositoryConfigurationAction repositoryConfigRefresh = new UpdateRepositoryConfigurationAction(){

            public void run() {
                TaskEditorAttributePart.this.getTaskEditorPage().showEditorBusy(true);
                final TaskJob job = TasksUiInternal.getJobFactory().createUpdateRepositoryConfigurationJob(TaskEditorAttributePart.this.getTaskEditorPage().getConnector(), TaskEditorAttributePart.this.getTaskEditorPage().getTaskRepository());
                job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                    public void done(IJobChangeEvent event) {
                        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                            public void run() {
                                TaskEditorAttributePart.this.getTaskEditorPage().showEditorBusy(false);
                                if (job.getStatus() != null) {
                                    TaskEditorAttributePart.this.getTaskEditorPage().getTaskEditor().setStatus("Updating of repository configuration failed", "Update Failed", job.getStatus());
                                } else {
                                    TaskEditorAttributePart.this.getTaskEditorPage().refreshFormContent();
                                }
                            }
                        });
                    }
                });
                job.setUser(true);
                job.setPriority(10);
                job.schedule();
            }
        };
        repositoryConfigRefresh.setImageDescriptor(TasksUiImages.REPOSITORY_SYNCHRONIZE_SMALL);
        repositoryConfigRefresh.selectionChanged((IStructuredSelection)new StructuredSelection((Object)this.getTaskEditorPage().getTaskRepository()));
        repositoryConfigRefresh.setToolTipText("Refresh Attributes");
        toolBar.add((IAction)repositoryConfigRefresh);
    }

    private void initialize() {
        this.attributeEditors = new ArrayList<AbstractAttributeEditor>();
        this.hasIncoming = false;
        Map attributes = this.getTaskData().getRoot().getAttributes();
        for (TaskAttribute attribute : attributes.values()) {
            AbstractAttributeEditor attributeEditor;
            TaskAttributeMetaData properties = attribute.getMetaData();
            if (!"task.common.kind.default".equals(properties.getKind()) || (attributeEditor = this.createAttributeEditor(attribute)) == null) continue;
            this.attributeEditors.add(attributeEditor);
            if (!this.getModel().hasIncomingChanges(attribute)) continue;
            this.hasIncoming = true;
        }
        Collections.sort(this.attributeEditors, new Comparator<AbstractAttributeEditor>(){

            @Override
            public int compare(AbstractAttributeEditor o1, AbstractAttributeEditor o2) {
                int p1 = o1.getLayoutHint() != null ? o1.getLayoutHint().getPriority() : 10;
                int p2 = o2.getLayoutHint() != null ? o2.getLayoutHint().getPriority() : 10;
                return p1 - p2;
            }
        });
    }
}

