/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.editors;

import java.io.File;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.deprecated.RepositoryTaskData;
import org.eclipse.mylyn.internal.tasks.ui.deprecated.AbstractRepositoryTaskEditor;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.internal.tasks.ui.wizards.NewAttachmentWizard;
import org.eclipse.mylyn.internal.tasks.ui.wizards.NewAttachmentWizardDialog;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.Control;

@Deprecated
public class RepositoryTaskEditorDropListener
implements DropTargetListener {
    private final AbstractRepositoryTaskEditor editor;
    private final FileTransfer fileTransfer;
    private final TextTransfer textTransfer;
    private final Control control;
    private final TaskRepository repository;
    private final RepositoryTaskData taskData;

    public RepositoryTaskEditorDropListener(AbstractRepositoryTaskEditor editor, TaskRepository repository, RepositoryTaskData taskData, FileTransfer fileTransfer, TextTransfer textTransfer, Control control) {
        this.editor = editor;
        this.repository = repository;
        this.taskData = taskData;
        this.fileTransfer = fileTransfer;
        this.textTransfer = textTransfer;
        this.control = control;
    }

    public void dragEnter(DropTargetEvent event) {
        if (event.detail == 16) {
            event.detail = (event.operations & 1) != 0 ? 1 : 0;
        }
        TransferData[] transferDataArray = event.dataTypes;
        int n = event.dataTypes.length;
        int n2 = 0;
        while (n2 < n) {
            TransferData dataType = transferDataArray[n2];
            if (this.fileTransfer.isSupportedType(dataType)) {
                event.currentDataType = dataType;
                if (event.detail == 1) break;
                event.detail = 0;
                break;
            }
            ++n2;
        }
    }

    public void dragOver(DropTargetEvent event) {
        event.feedback = 9;
    }

    public void dragOperationChanged(DropTargetEvent event) {
        event.detail = event.detail == 16 || (event.operations & 1) != 0 ? 1 : 0;
        if (this.fileTransfer.isSupportedType(event.currentDataType) && event.detail != 1) {
            event.detail = 0;
        }
    }

    public void dragLeave(DropTargetEvent event) {
    }

    public void dropAccept(DropTargetEvent event) {
    }

    public void drop(DropTargetEvent event) {
        String[] files;
        NewAttachmentWizard naw;
        AbstractTask task;
        if (this.textTransfer.isSupportedType(event.currentDataType)) {
            String text = (String)event.data;
            task = (AbstractTask)TasksUiInternal.getTaskList().getTask(this.repository.getRepositoryUrl(), this.taskData.getTaskId());
            if (task == null) {
                return;
            }
            this.editor.setGlobalBusy(true);
            naw = new NewAttachmentWizard(this.repository, task, text);
            this.openDialog(naw, null);
        }
        if (this.fileTransfer.isSupportedType(event.currentDataType) && (files = (String[])event.data).length > 0) {
            task = (AbstractTask)TasksUiInternal.getTaskList().getTask(this.repository.getRepositoryUrl(), this.taskData.getTaskId());
            if (task == null) {
                return;
            }
            naw = new NewAttachmentWizard(this.repository, task, new File(files[0]));
            String error = null;
            if (files.length > 1) {
                error = "Note that only the first file dragged will be attached.";
            }
            this.openDialog(naw, error);
        }
    }

    private void openDialog(NewAttachmentWizard naw, String message) {
        int result;
        this.editor.setGlobalBusy(true);
        NewAttachmentWizardDialog dialog = new NewAttachmentWizardDialog(this.control.getShell(), (IWizard)naw, true);
        naw.setDialog(dialog);
        dialog.create();
        if (message != null) {
            dialog.setMessage(message, 2);
        }
        if ((result = dialog.open()) != 0) {
            this.editor.setGlobalBusy(false);
        }
    }
}

