/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.editors;

import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.mylyn.internal.tasks.ui.editors.EditorUtil;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskDataModel;
import org.eclipse.mylyn.tasks.ui.editors.AbstractAttributeEditor;
import org.eclipse.mylyn.tasks.ui.editors.LayoutHint;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class LongTextAttributeEditor
extends AbstractAttributeEditor {
    public LongTextAttributeEditor(TaskDataModel manager, TaskAttribute taskAttribute) {
        super(manager, taskAttribute);
        this.setLayoutHint(new LayoutHint(LayoutHint.RowSpan.MULTIPLE, LayoutHint.ColumnSpan.MULTIPLE));
    }

    public void createControl(Composite parent, FormToolkit toolkit) {
        int style = 8388674;
        if (!this.isReadOnly()) {
            style |= 0x200;
        }
        TextViewer viewer = new TextViewer(parent, style);
        viewer.setDocument((IDocument)new Document(this.getValue()));
        final StyledText text = viewer.getTextWidget();
        toolkit.adapt((Control)text, false, false);
        if (this.isReadOnly()) {
            viewer.setEditable(false);
        } else {
            viewer.setEditable(true);
            text.setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
            text.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    LongTextAttributeEditor.this.setValue(text.getText());
                    EditorUtil.ensureVisible((Control)text);
                }
            });
        }
        this.setControl((Control)text);
    }

    public String getValue() {
        return this.getAttributeMapper().getValue(this.getTaskAttribute());
    }

    public void setValue(String text) {
        this.getAttributeMapper().setValue(this.getTaskAttribute(), text);
        this.attributeChanged();
    }
}

