/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.editors;

import java.lang.reflect.Method;
import java.text.DateFormat;
import java.util.Date;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.internal.tasks.ui.wizards.NewAttachmentWizardDialog;
import org.eclipse.mylyn.internal.tasks.ui.wizards.TaskAttachmentWizard;
import org.eclipse.mylyn.tasks.core.data.AbstractTaskAttachmentSource;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMapper;
import org.eclipse.mylyn.tasks.ui.editors.AbstractTaskEditorPage;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.internal.forms.widgets.FormUtil;

public class EditorUtil {
    @Deprecated
    public static final String DATE_FORMAT = "yyyy-MM-dd";
    @Deprecated
    public static final String DATE_TIME_FORMAT = "yyyy-MM-dd HH:mm";
    static final String KEY_MARKER = "marker";
    static final String KEY_TEXT_VIEWER = "textViewer";
    public static final int MAXIMUM_HEIGHT = 140;
    public static final int MAXIMUM_WIDTH = 500;
    public static final Font TEXT_FONT = JFaceResources.getDefaultFont();

    static boolean canDoGlobalAction(String actionId, TextViewer textViewer) {
        if (actionId.equals(ActionFactory.CUT.getId())) {
            return textViewer.canDoOperation(3);
        }
        if (actionId.equals(ActionFactory.COPY.getId())) {
            return textViewer.canDoOperation(4);
        }
        if (actionId.equals(ActionFactory.PASTE.getId())) {
            return textViewer.canDoOperation(5);
        }
        if (actionId.equals(ActionFactory.DELETE.getId())) {
            return textViewer.canDoOperation(6);
        }
        if (actionId.equals(ActionFactory.UNDO.getId())) {
            return textViewer.canDoOperation(1);
        }
        if (actionId.equals(ActionFactory.REDO.getId())) {
            return textViewer.canDoOperation(2);
        }
        if (actionId.equals(ActionFactory.SELECT_ALL.getId())) {
            return textViewer.canDoOperation(7);
        }
        return false;
    }

    public static boolean canPerformAction(String actionId, Control focusControl) {
        TextViewer viewer = EditorUtil.getTextViewer((Widget)focusControl);
        if (viewer != null) {
            return EditorUtil.canDoGlobalAction(actionId, viewer);
        }
        return !actionId.equals(ActionFactory.UNDO.getId()) && !actionId.equals(ActionFactory.REDO.getId());
    }

    private static boolean canPerformDirectly(String id, Control control) {
        if (control instanceof Text) {
            Text text = (Text)control;
            if (id.equals(ActionFactory.CUT.getId())) {
                text.cut();
                return true;
            }
            if (id.equals(ActionFactory.COPY.getId())) {
                text.copy();
                return true;
            }
            if (id.equals(ActionFactory.PASTE.getId())) {
                text.paste();
                return true;
            }
            if (id.equals(ActionFactory.SELECT_ALL.getId())) {
                text.selectAll();
                return true;
            }
            if (id.equals(ActionFactory.DELETE.getId())) {
                int count = text.getSelectionCount();
                if (count == 0) {
                    int caretPos = text.getCaretPosition();
                    text.setSelection(caretPos, caretPos + 1);
                }
                text.insert("");
                return true;
            }
        }
        return false;
    }

    public static void doAction(String actionId, Control focusControl) {
        if (EditorUtil.canPerformDirectly(actionId, focusControl)) {
            return;
        }
        TextViewer viewer = EditorUtil.getTextViewer((Widget)focusControl);
        if (viewer != null) {
            EditorUtil.doGlobalAction(actionId, viewer);
        }
    }

    private static boolean doGlobalAction(String actionId, TextViewer textViewer) {
        if (actionId.equals(ActionFactory.CUT.getId())) {
            textViewer.doOperation(3);
            return true;
        }
        if (actionId.equals(ActionFactory.COPY.getId())) {
            textViewer.doOperation(4);
            return true;
        }
        if (actionId.equals(ActionFactory.PASTE.getId())) {
            textViewer.doOperation(5);
            return true;
        }
        if (actionId.equals(ActionFactory.DELETE.getId())) {
            textViewer.doOperation(6);
            return true;
        }
        if (actionId.equals(ActionFactory.UNDO.getId())) {
            textViewer.doOperation(1);
            return true;
        }
        if (actionId.equals(ActionFactory.REDO.getId())) {
            textViewer.doOperation(2);
            return true;
        }
        if (actionId.equals(ActionFactory.SELECT_ALL.getId())) {
            textViewer.doOperation(7);
            return true;
        }
        return false;
    }

    private static Control findControl(Composite composite, String key) {
        if (!composite.isDisposed()) {
            Control[] controlArray = composite.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control found;
                Control child = controlArray[n2];
                if (key.equals(EditorUtil.getMarker((Widget)child))) {
                    return child;
                }
                if (child instanceof Composite && (found = EditorUtil.findControl((Composite)child, key)) != null) {
                    return found;
                }
                ++n2;
            }
        }
        return null;
    }

    private static void focusOn(ScrolledForm form, Control control) {
        int pos = 0;
        control.setEnabled(true);
        control.setFocus();
        control.forceFocus();
        while (control != null && control != form.getBody()) {
            pos += control.getLocation().y;
            control = control.getParent();
        }
        pos -= 60;
        if (!form.getBody().isDisposed()) {
            form.setOrigin(0, pos);
        }
    }

    static String formatDate(Date date) {
        return DateFormat.getDateInstance(2).format(date);
    }

    static String formatDateTime(Date date) {
        return DateFormat.getDateTimeInstance(2, 3).format(date);
    }

    public static Control getFocusControl(IFormPage page) {
        if (page == null) {
            return null;
        }
        IManagedForm form = page.getManagedForm();
        if (form == null) {
            return null;
        }
        ScrolledForm control = form.getForm();
        if (control == null || control.isDisposed()) {
            return null;
        }
        Display display = control.getDisplay();
        Control focusControl = display.getFocusControl();
        if (focusControl == null || focusControl.isDisposed()) {
            return null;
        }
        return focusControl;
    }

    public static String getMarker(Widget widget) {
        return (String)widget.getData(KEY_MARKER);
    }

    public static TextViewer getTextViewer(Widget widget) {
        Object data;
        if (widget instanceof StyledText && (data = widget.getData(KEY_TEXT_VIEWER)) instanceof TextViewer) {
            return (TextViewer)data;
        }
        return null;
    }

    public static NewAttachmentWizardDialog openNewAttachmentWizard(final AbstractTaskEditorPage page, TaskAttachmentWizard.Mode mode, AbstractTaskAttachmentSource source) {
        TaskAttributeMapper mapper = page.getModel().getTaskData().getAttributeMapper();
        TaskAttribute attribute = mapper.createTaskAttachment(page.getModel().getTaskData());
        final NewAttachmentWizardDialog dialog = TasksUiInternal.openNewAttachmentWizard(page.getSite().getShell(), page.getTaskRepository(), page.getTask(), attribute, mode, source);
        dialog.getShell().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (dialog.getReturnCode() == 0) {
                    page.getTaskEditor().refreshPages();
                }
            }
        });
        return dialog;
    }

    public static boolean reveal(ScrolledForm form, String key) {
        Control control = EditorUtil.findControl(form.getBody(), key);
        if (control != null) {
            ExpandableComposite ex;
            if (control instanceof ExpandableComposite && !(ex = (ExpandableComposite)control).isExpanded()) {
                EditorUtil.toggleExpandableComposite(true, ex);
            }
            Composite comp = control.getParent();
            while (comp != null) {
                if (comp instanceof Section) {
                    if (!((Section)comp).isExpanded()) {
                        ((Section)comp).setExpanded(true);
                    }
                } else if (comp instanceof ExpandableComposite) {
                    ExpandableComposite ex2 = (ExpandableComposite)comp;
                    if (!ex2.isExpanded()) {
                        EditorUtil.toggleExpandableComposite(true, ex2);
                    }
                    if (ex2.getData() != null && ex2.getData() instanceof Composite) {
                        ((Composite)ex2.getData()).setVisible(true);
                    }
                }
                comp = comp.getParent();
            }
            EditorUtil.focusOn(form, control);
        }
        return true;
    }

    public static void setEnabledState(Composite composite, boolean enabled) {
        if (!composite.isDisposed()) {
            composite.setEnabled(enabled);
            Control[] controlArray = composite.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control control = controlArray[n2];
                control.setEnabled(enabled);
                if (control instanceof Composite) {
                    EditorUtil.setEnabledState((Composite)control, enabled);
                }
                ++n2;
            }
        }
    }

    public static void setMarker(Widget widget, String text) {
        widget.setData(KEY_MARKER, (Object)text);
    }

    public static void setTextViewer(Widget widget, TextViewer textViewer) {
        widget.setData(KEY_TEXT_VIEWER, (Object)textViewer);
    }

    public static void toggleExpandableComposite(boolean expanded, ExpandableComposite comp) {
        if (comp.isExpanded() != expanded) {
            Method method = null;
            try {
                method = ExpandableComposite.class.getDeclaredMethod("programmaticToggleState", new Class[0]);
                method.setAccessible(true);
                method.invoke((Object)comp, new Object[0]);
            }
            catch (Exception exception) {}
        }
    }

    public static void disableScrollingOnFocus(ScrolledForm form) {
        form.setData("focusScrolling", (Object)Boolean.FALSE);
    }

    public static void ensureVisible(Control control) {
        ScrolledComposite form = FormUtil.getScrolledComposite((Control)control);
        if (form != null) {
            FormUtil.ensureVisible((ScrolledComposite)form, (Control)control);
        }
    }
}

