/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.editors;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.mylyn.internal.provisional.commons.ui.CommonImages;
import org.eclipse.mylyn.internal.tasks.core.deprecated.RepositoryAttachment;
import org.eclipse.mylyn.internal.tasks.ui.deprecated.AbstractRepositoryTaskEditor;
import org.eclipse.mylyn.internal.tasks.ui.editors.AttachmentSizeFormatter;
import org.eclipse.mylyn.internal.tasks.ui.util.AttachmentUtil;
import org.eclipse.mylyn.tasks.ui.TasksUiImages;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.themes.IThemeManager;

@Deprecated
public class AttachmentTableLabelProvider
extends ColumnLabelProvider {
    private final AbstractRepositoryTaskEditor AbstractTaskEditor;
    private final AttachmentSizeFormatter sizeFormatter = AttachmentSizeFormatter.getInstance();
    private final IThemeManager themeManager = PlatformUI.getWorkbench().getThemeManager();
    private static final String[] IMAGE_EXTENSIONS = new String[]{"jpg", "gif", "png", "tiff", "tif", "bmp"};

    public AttachmentTableLabelProvider(AbstractRepositoryTaskEditor AbstractTaskEditor, ILabelProvider provider, ILabelDecorator decorator) {
        this.AbstractTaskEditor = AbstractTaskEditor;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        RepositoryAttachment attachment = (RepositoryAttachment)element;
        if (columnIndex == 0) {
            int dotIndex;
            if (AttachmentUtil.isContext(attachment)) {
                return CommonImages.getImage((ImageDescriptor)TasksUiImages.CONTEXT_TRANSFER);
            }
            if (attachment.isPatch()) {
                return CommonImages.getImage((ImageDescriptor)TasksUiImages.TASK_ATTACHMENT_PATCH);
            }
            String filename = attachment.getFilename();
            if (filename != null && (dotIndex = filename.lastIndexOf(46)) != -1) {
                String fileType = filename.substring(dotIndex + 1);
                String[] stringArray = IMAGE_EXTENSIONS;
                int n = IMAGE_EXTENSIONS.length;
                int n2 = 0;
                while (n2 < n) {
                    String element2 = stringArray[n2];
                    if (element2.equalsIgnoreCase(fileType)) {
                        return CommonImages.getImage((ImageDescriptor)CommonImages.IMAGE_FILE);
                    }
                    ++n2;
                }
            }
            return WorkbenchImages.getImage((String)"IMG_OBJ_FILE");
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        RepositoryAttachment attachment = (RepositoryAttachment)element;
        switch (columnIndex) {
            case 0: {
                if (AttachmentUtil.isContext(attachment)) {
                    return " Task Context";
                }
                if (attachment.isPatch()) {
                    return " Patch";
                }
                return " " + attachment.getFilename();
            }
            case 1: {
                return attachment.getDescription();
            }
            case 2: {
                return attachment.getContentType();
            }
            case 3: {
                return this.sizeFormatter.format(attachment.getSize());
            }
            case 4: {
                return attachment.getCreator();
            }
            case 5: {
                if (this.AbstractTaskEditor != null) {
                    return this.AbstractTaskEditor.formatDate(attachment.getDateCreated());
                }
                return attachment.getDateCreated();
            }
        }
        return "unrecognized column";
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public Color getForeground(Object element, int columnIndex) {
        RepositoryAttachment att = (RepositoryAttachment)element;
        if (att.isObsolete()) {
            return this.themeManager.getCurrentTheme().getColorRegistry().get("org.eclipse.mylyn.tasks.ui.colors.foreground.completed");
        }
        return super.getForeground(element);
    }

    public Color getBackground(Object element, int columnIndex) {
        return super.getBackground(element);
    }

    public Font getFont(Object element, int columnIndex) {
        return super.getFont(element);
    }

    public String getToolTipText(Object element) {
        RepositoryAttachment attachment = (RepositoryAttachment)element;
        return "File: " + attachment.getAttributeValue("filename");
    }

    public Point getToolTipShift(Object object) {
        return new Point(5, 5);
    }

    public int getToolTipDisplayDelayTime(Object object) {
        return 200;
    }

    public int getToolTipTimeDisplayed(Object object) {
        return 5000;
    }

    public void update(ViewerCell cell) {
        Object element = cell.getElement();
        cell.setText(this.getColumnText(element, cell.getColumnIndex()));
        Image image = this.getColumnImage(element, cell.getColumnIndex());
        cell.setImage(image);
        cell.setBackground(this.getBackground(element));
        cell.setForeground(this.getForeground(element));
        cell.setFont(this.getFont(element));
    }
}

