/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.dialogs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskListTableSorter;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskListView;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.SelectionDialog;

public class TaskListSortDialog
extends SelectionDialog {
    private Combo[] priorityCombos;
    private Button[] ascendingButtons;
    private Button[] descendingButtons;
    private final String[] propertyText;
    private boolean dirty = false;
    private final TaskListView taskListView;
    private final Comparator<String> columnComparator = new Comparator<String>(){

        @Override
        public int compare(String arg0, String arg1) {
            int index0 = -1;
            int index1 = -1;
            int i = 0;
            while (i < TaskListSortDialog.this.propertyText.length) {
                if (TaskListSortDialog.this.propertyText[i].equals(arg0)) {
                    index0 = i;
                }
                if (TaskListSortDialog.this.propertyText[i].equals(arg1)) {
                    index1 = i;
                }
                ++i;
            }
            return index0 - index1;
        }
    };

    public TaskListSortDialog(IShellProvider parentShell, TaskListView taskListView) {
        super(parentShell.getShell());
        this.propertyText = new String[3];
        this.propertyText[0] = "Priority";
        this.propertyText[1] = "Summary";
        this.propertyText[2] = "Date Created";
        this.taskListView = taskListView;
        this.setTitle("Task List Sorting");
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.initializeDialogUnits((Control)composite);
        Composite prioritiesArea = new Composite(composite, 0);
        prioritiesArea.setLayout((Layout)new GridLayout(3, false));
        Label sortByLabel = new Label(prioritiesArea, 0);
        sortByLabel.setText("Sort order:");
        GridData data = new GridData();
        data.horizontalSpan = 3;
        sortByLabel.setLayoutData((Object)data);
        this.ascendingButtons = new Button[2];
        this.descendingButtons = new Button[2];
        this.priorityCombos = new Combo[2];
        int i = 0;
        while (i < 2) {
            final int index = i;
            Label numberLabel = new Label(prioritiesArea, 0);
            numberLabel.setText(i + 1 + ".");
            this.priorityCombos[i] = new Combo(prioritiesArea, 8);
            this.priorityCombos[i].setLayoutData((Object)new GridData(768));
            Composite directionGroup = new Composite(prioritiesArea, 0);
            directionGroup.setLayout((Layout)new GridLayout(2, false));
            this.ascendingButtons[i] = new Button(directionGroup, 16);
            this.ascendingButtons[i].setText("Ascending");
            this.ascendingButtons[i].addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TaskListSortDialog.this.markDirty();
                }
            });
            this.descendingButtons[i] = new Button(directionGroup, 16);
            this.descendingButtons[i].setText("Descending");
            this.descendingButtons[i].addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TaskListSortDialog.this.markDirty();
                }
            });
            if (i < this.priorityCombos.length - 1) {
                this.priorityCombos[i].addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        String newSelection;
                        int oldSelectionDirection = 1;
                        if (TaskListSortDialog.this.descendingButtons[index].getSelection()) {
                            oldSelectionDirection = -1;
                        }
                        ArrayList oldSelectionList = new ArrayList(Arrays.asList(TaskListSortDialog.this.priorityCombos[index].getItems()));
                        oldSelectionList.removeAll((Collection)Arrays.asList(TaskListSortDialog.this.priorityCombos[index + 1].getItems()));
                        if (oldSelectionList.size() != 1) {
                            return;
                        }
                        String oldSelection = (String)oldSelectionList.get(0);
                        if (oldSelection.equals(newSelection = TaskListSortDialog.this.priorityCombos[index].getItem(TaskListSortDialog.this.priorityCombos[index].getSelectionIndex()))) {
                            return;
                        }
                        int j = index + 1;
                        while (j < TaskListSortDialog.this.priorityCombos.length) {
                            int newSelectionIndex = TaskListSortDialog.this.priorityCombos[j].indexOf(newSelection);
                            if (TaskListSortDialog.this.priorityCombos[j].getSelectionIndex() == newSelectionIndex) {
                                TaskListSortDialog.this.priorityCombos[j].remove(newSelection);
                                int insertionPoint = -1 - Arrays.binarySearch(TaskListSortDialog.this.priorityCombos[j].getItems(), oldSelection, TaskListSortDialog.this.columnComparator);
                                if (insertionPoint >= 0 && insertionPoint <= TaskListSortDialog.this.priorityCombos[j].getItemCount()) {
                                    TaskListSortDialog.this.priorityCombos[j].add(oldSelection, insertionPoint);
                                } else {
                                    TaskListSortDialog.this.priorityCombos[j].add(oldSelection);
                                }
                                TaskListSortDialog.this.priorityCombos[j].select(TaskListSortDialog.this.priorityCombos[j].indexOf(oldSelection));
                                TaskListSortDialog.this.ascendingButtons[index].setSelection(TaskListSortDialog.this.ascendingButtons[j].getSelection());
                                TaskListSortDialog.this.descendingButtons[index].setSelection(TaskListSortDialog.this.descendingButtons[j].getSelection());
                                TaskListSortDialog.this.ascendingButtons[j].setSelection(oldSelectionDirection == 1);
                                TaskListSortDialog.this.descendingButtons[j].setSelection(oldSelectionDirection == -1);
                            } else if (newSelectionIndex >= 0) {
                                String currentText = TaskListSortDialog.this.priorityCombos[j].getText();
                                TaskListSortDialog.this.priorityCombos[j].remove(newSelection);
                                int insertionPoint = -1 - Arrays.binarySearch(TaskListSortDialog.this.priorityCombos[j].getItems(), oldSelection, TaskListSortDialog.this.columnComparator);
                                if (insertionPoint >= 0 && insertionPoint <= TaskListSortDialog.this.priorityCombos[j].getItemCount()) {
                                    TaskListSortDialog.this.priorityCombos[j].add(oldSelection, insertionPoint);
                                    TaskListSortDialog.this.priorityCombos[j].select(TaskListSortDialog.this.priorityCombos[j].indexOf(currentText));
                                } else {
                                    TaskListSortDialog.this.priorityCombos[j].add(oldSelection);
                                }
                            }
                            ++j;
                        }
                        TaskListSortDialog.this.markDirty();
                    }
                });
            } else {
                this.priorityCombos[i].addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        TaskListSortDialog.this.markDirty();
                    }
                });
            }
            ++i;
        }
        int[] a = new int[2];
        int[] b = new int[2];
        switch (this.taskListView.getSorter().getSortByIndex()) {
            case PRIORITY: {
                a[0] = 0;
                break;
            }
            case SUMMARY: {
                a[0] = 1;
                break;
            }
            case DATE_CREATED: {
                a[0] = 2;
            }
        }
        switch (this.taskListView.getSorter().getSortByIndex2()) {
            case PRIORITY: {
                a[1] = 0;
                break;
            }
            case SUMMARY: {
                a[1] = 1;
                break;
            }
            case DATE_CREATED: {
                a[1] = 2;
            }
        }
        b[0] = this.taskListView.getSorter().getSortDirection();
        b[1] = this.taskListView.getSorter().getSortDirection2();
        this.updateUI(a, b);
        return composite;
    }

    protected void okPressed() {
        if (this.isDirty()) {
            this.taskListView.getSorter().setSortByIndex(TaskListTableSorter.SortByIndex.valueOf(this.priorityCombos[0].getItem(this.priorityCombos[0].getSelectionIndex()).replace(' ', '_').toUpperCase()));
            this.taskListView.getSorter().setSortByIndex2(TaskListTableSorter.SortByIndex.valueOf(this.priorityCombos[1].getItem(this.priorityCombos[1].getSelectionIndex()).replace(' ', '_').toUpperCase()));
            if (this.descendingButtons[0].getSelection()) {
                this.taskListView.getSorter().setSortDirection(-1);
            } else {
                this.taskListView.getSorter().setSortDirection(1);
            }
            if (this.descendingButtons[1].getSelection()) {
                this.taskListView.getSorter().setSortDirection2(-1);
            } else {
                this.taskListView.getSorter().setSortDirection2(1);
            }
        }
        super.okPressed();
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void markDirty() {
        this.dirty = true;
    }

    private void updateUI(int[] priorities, int[] directions) {
        ArrayList availablePriorities = new ArrayList(Arrays.asList(this.propertyText));
        int i = 0;
        while (i < this.priorityCombos.length) {
            this.priorityCombos[i].removeAll();
            int j = 0;
            while (j < availablePriorities.size()) {
                this.priorityCombos[i].add((String)availablePriorities.get(j));
                ++j;
            }
            this.priorityCombos[i].select(this.priorityCombos[i].indexOf(this.propertyText[priorities[i]]));
            availablePriorities.remove(this.propertyText[priorities[i]]);
            this.ascendingButtons[i].setSelection(directions[i] == 1);
            this.descendingButtons[i].setSelection(directions[i] == -1);
            ++i;
        }
    }
}

