/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.deprecated;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.jface.text.source.IAnnotationAccessExtension;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISharedTextColors;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.ImageUtilities;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.mylyn.internal.provisional.commons.ui.CommonColors;
import org.eclipse.mylyn.internal.tasks.ui.editors.RepositoryTextViewer;
import org.eclipse.mylyn.internal.tasks.ui.editors.RepositoryTextViewerConfiguration;
import org.eclipse.mylyn.internal.tasks.ui.editors.TaskEditorActionContributor;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditor;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.ActiveShellExpression;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.DefaultMarkerAnnotationAccess;
import org.eclipse.ui.texteditor.MarkerAnnotationPreferences;
import org.eclipse.ui.texteditor.SourceViewerDecorationSupport;
import org.eclipse.ui.themes.IThemeManager;

@Deprecated
public class TaskFormPage
extends FormPage {
    protected boolean isDirty;
    private TaskEditor taskEditor = null;
    private TaskEditorActionContributor actionContributor;
    protected List<TextViewer> textViewers = new ArrayList<TextViewer>();
    private IHandlerActivation handlerActivation;
    private IHandlerActivation handlerCompletion;

    private void addTextViewer(TextViewer viewer) {
        this.textViewers.add(viewer);
    }

    public TaskFormPage(FormEditor editor, String id, String title) {
        super(editor, id, title);
        this.taskEditor = (TaskEditor)editor;
    }

    public boolean canPerformAction(String actionId) {
        Control focusControl = this.getFocusControl();
        if (focusControl instanceof StyledText) {
            StyledText text = (StyledText)focusControl;
            for (TextViewer viewer : this.textViewers) {
                if (viewer.getTextWidget() != text) continue;
                return this.canDoGlobalAction(actionId, viewer);
            }
        } else {
            return !actionId.equals(ActionFactory.UNDO.getId()) && !actionId.equals(ActionFactory.REDO.getId());
        }
        return false;
    }

    public void doAction(String actionId) {
        Control focusControl = this.getFocusControl();
        if (focusControl == null) {
            return;
        }
        if (this.canPerformDirectly(actionId, focusControl)) {
            return;
        }
        if (focusControl instanceof StyledText) {
            StyledText text = (StyledText)focusControl;
            for (TextViewer viewer : this.textViewers) {
                if (viewer.getTextWidget() != text) continue;
                this.doGlobalAction(actionId, viewer);
                return;
            }
        }
    }

    protected boolean canPerformDirectly(String id, Control control) {
        if (control instanceof Text) {
            Text text = (Text)control;
            if (id.equals(ActionFactory.CUT.getId())) {
                text.cut();
                return true;
            }
            if (id.equals(ActionFactory.COPY.getId())) {
                text.copy();
                return true;
            }
            if (id.equals(ActionFactory.PASTE.getId())) {
                text.paste();
                return true;
            }
            if (id.equals(ActionFactory.SELECT_ALL.getId())) {
                text.selectAll();
                return true;
            }
            if (id.equals(ActionFactory.DELETE.getId())) {
                int count = text.getSelectionCount();
                if (count == 0) {
                    int caretPos = text.getCaretPosition();
                    text.setSelection(caretPos, caretPos + 1);
                }
                text.insert("");
                return true;
            }
        }
        return false;
    }

    protected Control getFocusControl() {
        IManagedForm form = this.getManagedForm();
        if (form == null) {
            return null;
        }
        ScrolledForm control = form.getForm();
        if (control == null || control.isDisposed()) {
            return null;
        }
        Display display = control.getDisplay();
        Control focusControl = display.getFocusControl();
        if (focusControl == null || focusControl.isDisposed()) {
            return null;
        }
        return focusControl;
    }

    private boolean doGlobalAction(String actionId, TextViewer textViewer) {
        if (actionId.equals(ActionFactory.CUT.getId())) {
            textViewer.doOperation(3);
            return true;
        }
        if (actionId.equals(ActionFactory.COPY.getId())) {
            textViewer.doOperation(4);
            return true;
        }
        if (actionId.equals(ActionFactory.PASTE.getId())) {
            textViewer.doOperation(5);
            return true;
        }
        if (actionId.equals(ActionFactory.DELETE.getId())) {
            textViewer.doOperation(6);
            return true;
        }
        if (actionId.equals(ActionFactory.UNDO.getId())) {
            textViewer.doOperation(1);
            return true;
        }
        if (actionId.equals(ActionFactory.REDO.getId())) {
            textViewer.doOperation(2);
            return true;
        }
        if (actionId.equals(ActionFactory.SELECT_ALL.getId())) {
            textViewer.doOperation(7);
            return true;
        }
        return false;
    }

    private boolean canDoGlobalAction(String actionId, TextViewer textViewer) {
        if (actionId.equals(ActionFactory.CUT.getId())) {
            return textViewer.canDoOperation(3);
        }
        if (actionId.equals(ActionFactory.COPY.getId())) {
            return textViewer.canDoOperation(4);
        }
        if (actionId.equals(ActionFactory.PASTE.getId())) {
            return textViewer.canDoOperation(5);
        }
        if (actionId.equals(ActionFactory.DELETE.getId())) {
            return textViewer.canDoOperation(6);
        }
        if (actionId.equals(ActionFactory.UNDO.getId())) {
            return textViewer.canDoOperation(1);
        }
        if (actionId.equals(ActionFactory.REDO.getId())) {
            return textViewer.canDoOperation(2);
        }
        if (actionId.equals(ActionFactory.SELECT_ALL.getId())) {
            return textViewer.canDoOperation(7);
        }
        return false;
    }

    protected TextViewer addTextViewer(TaskRepository repository, Composite composite, String text, int style) {
        if (this.actionContributor == null) {
            this.actionContributor = (TaskEditorActionContributor)this.getEditorSite().getActionBarContributor();
        }
        final RepositoryTextViewer commentViewer = new RepositoryTextViewer(repository, composite, style);
        RepositoryTextViewerConfiguration repositoryViewerConfig = new RepositoryTextViewerConfiguration(repository, false);
        commentViewer.configure((SourceViewerConfiguration)repositoryViewerConfig);
        IThemeManager themeManager = this.getSite().getWorkbenchWindow().getWorkbench().getThemeManager();
        commentViewer.getTextWidget().setFont(themeManager.getCurrentTheme().getFontRegistry().get("org.eclipse.mylyn.tasks.ui.fonts.task.editor.comment"));
        commentViewer.addSelectionChangedListener(this.actionContributor);
        commentViewer.getTextWidget().addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                TaskFormPage.this.actionContributor.updateSelectableActions(commentViewer.getSelection());
            }

            public void focusLost(FocusEvent e) {
                StyledText st = (StyledText)e.widget;
                st.setSelectionRange(st.getCaretOffset(), 0);
                TaskFormPage.this.actionContributor.forceActionsEnabled();
            }
        });
        commentViewer.addTextListener(new ITextListener(){

            public void textChanged(TextEvent event) {
                TaskFormPage.this.actionContributor.updateSelectableActions(commentViewer.getSelection());
            }
        });
        commentViewer.setEditable(false);
        MenuManager manager = commentViewer.getMenuManager();
        this.taskEditor.configureContextMenuManager(manager);
        commentViewer.setMenu(manager.createContextMenu((Control)commentViewer.getTextWidget()));
        Document document = new Document(text);
        commentViewer.setDocument((IDocument)document);
        this.addTextViewer((TextViewer)commentViewer);
        return commentViewer;
    }

    protected TextViewer addTextEditor(TaskRepository repository, Composite composite, String text, boolean spellCheck, int style) {
        if (this.actionContributor == null) {
            this.actionContributor = (TaskEditorActionContributor)this.getEditorSite().getActionBarContributor();
        }
        AnnotationModel annotationModel = new AnnotationModel();
        final RepositoryTextViewer commentViewer = new RepositoryTextViewer(null, null, repository, composite, style);
        commentViewer.showAnnotations(false);
        commentViewer.showAnnotationsOverview(false);
        DefaultMarkerAnnotationAccess annotationAccess = new DefaultMarkerAnnotationAccess();
        final SourceViewerDecorationSupport support = new SourceViewerDecorationSupport((ISourceViewer)commentViewer, null, (IAnnotationAccess)annotationAccess, EditorsUI.getSharedTextColors());
        Iterator e = new MarkerAnnotationPreferences().getAnnotationPreferences().iterator();
        while (e.hasNext()) {
            support.setAnnotationPreference((AnnotationPreference)e.next());
        }
        support.install(EditorsUI.getPreferenceStore());
        commentViewer.getTextWidget().setIndent(2);
        commentViewer.getTextWidget().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                support.uninstall();
            }
        });
        final IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
        IThemeManager themeManager = this.getSite().getWorkbenchWindow().getWorkbench().getThemeManager();
        commentViewer.getTextWidget().setFont(themeManager.getCurrentTheme().getFontRegistry().get("org.eclipse.mylyn.tasks.ui.fonts.task.editor.comment"));
        commentViewer.addSelectionChangedListener(this.actionContributor);
        commentViewer.getTextWidget().addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                TaskFormPage.this.actionContributor.updateSelectableActions(commentViewer.getSelection());
                this.activate();
            }

            public void focusLost(FocusEvent e) {
                StyledText st = (StyledText)e.widget;
                st.setSelectionRange(st.getCaretOffset(), 0);
                TaskFormPage.this.actionContributor.forceActionsEnabled();
                this.deactivate();
            }

            private void activate() {
                this.deactivate();
                if (TaskFormPage.this.handlerActivation == null) {
                    TaskFormPage.this.handlerActivation = handlerService.activateHandler("org.eclipse.jdt.ui.edit.text.java.correction.assist.proposals", TaskFormPage.this.createQuickFixActionHandler(commentViewer), (Expression)new ActiveShellExpression(commentViewer.getTextWidget().getShell()));
                }
                if (TaskFormPage.this.handlerCompletion == null) {
                    TaskFormPage.this.handlerCompletion = handlerService.activateHandler("org.eclipse.ui.edit.text.contentAssist.proposals", TaskFormPage.this.createContentAssistActionHandler(commentViewer), (Expression)new ActiveShellExpression(commentViewer.getTextWidget().getShell()));
                }
            }

            private void deactivate() {
                if (TaskFormPage.this.handlerCompletion != null) {
                    handlerService.deactivateHandler(TaskFormPage.this.handlerCompletion);
                    TaskFormPage.this.handlerCompletion = null;
                }
                if (TaskFormPage.this.handlerActivation != null) {
                    handlerService.deactivateHandler(TaskFormPage.this.handlerActivation);
                    TaskFormPage.this.handlerActivation = null;
                }
            }
        });
        commentViewer.addTextListener(new ITextListener(){

            public void textChanged(TextEvent event) {
                TaskFormPage.this.actionContributor.updateSelectableActions(commentViewer.getSelection());
            }
        });
        commentViewer.setEditable(false);
        MenuManager manager = commentViewer.getMenuManager();
        this.taskEditor.configureContextMenuManager(manager);
        commentViewer.setMenu(manager.createContextMenu((Control)commentViewer.getTextWidget()));
        Document document = new Document(text);
        RepositoryTextViewerConfiguration viewerConfig = new RepositoryTextViewerConfiguration(repository, spellCheck);
        commentViewer.configure((SourceViewerConfiguration)viewerConfig);
        commentViewer.setDocument((IDocument)document, (IAnnotationModel)annotationModel);
        this.addTextViewer((TextViewer)commentViewer);
        return commentViewer;
    }

    private IHandler createQuickFixActionHandler(final SourceViewer viewer) {
        Action quickFixAction = new Action(){

            public void run() {
                if (viewer.canDoOperation(22)) {
                    viewer.doOperation(22);
                }
            }
        };
        quickFixAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.correction.assist.proposals");
        return new ActionHandler((IAction)quickFixAction);
    }

    private IHandler createContentAssistActionHandler(final SourceViewer viewer) {
        Action quickFixAction = new Action(){

            public void run() {
                if (viewer.canDoOperation(13)) {
                    viewer.doOperation(13);
                }
            }
        };
        quickFixAction.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.proposals");
        return new ActionHandler((IAction)quickFixAction);
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public void markDirty(boolean dirty) {
        this.isDirty = dirty;
        this.getManagedForm().dirtyStateChanged();
    }

    public String getSelectionText() {
        Control focusControl = this.getFocusControl();
        if (focusControl == null) {
            return null;
        }
        if (focusControl instanceof StyledText) {
            StyledText text = (StyledText)focusControl;
            for (TextViewer viewer : this.textViewers) {
                if (viewer.getTextWidget() != text) continue;
                return text.getSelectionText();
            }
        }
        return null;
    }

    static class AnnotationConfiguration
    implements IInformationControlCreator {
        AnnotationConfiguration() {
        }

        public IInformationControl createInformationControl(Shell shell) {
            return new DefaultInformationControl(shell);
        }
    }

    static class AnnotationHover
    implements IAnnotationHover,
    ITextHover {
        AnnotationModel fAnnotationModel = null;

        public AnnotationHover(AnnotationModel model) {
            this.fAnnotationModel = model;
        }

        public String getHoverInfo(ISourceViewer sourceViewer, int lineNumber) {
            Iterator ite = this.fAnnotationModel.getAnnotationIterator();
            ArrayList<String> all = new ArrayList<String>();
            while (ite.hasNext()) {
                Annotation a = (Annotation)ite.next();
                if (!(a instanceof ErrorAnnotation)) continue;
                all.add(((ErrorAnnotation)a).getText());
            }
            StringBuffer total = new StringBuffer();
            int x = 0;
            while (x < all.size()) {
                String str = (String)all.get(x);
                total.append(" " + str + (x == all.size() - 1 ? "" : "\n"));
                ++x;
            }
            return total.toString();
        }

        public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
            return null;
        }

        public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
            return null;
        }
    }

    static class AnnotationMarkerAccess
    implements IAnnotationAccess,
    IAnnotationAccessExtension {
        AnnotationMarkerAccess() {
        }

        public Object getType(Annotation annotation) {
            return annotation.getType();
        }

        public boolean isMultiLine(Annotation annotation) {
            return true;
        }

        public boolean isTemporary(Annotation annotation) {
            return !annotation.isPersistent();
        }

        public String getTypeLabel(Annotation annotation) {
            if (annotation instanceof ErrorAnnotation) {
                return "Errors";
            }
            return null;
        }

        public int getLayer(Annotation annotation) {
            if (annotation instanceof ErrorAnnotation) {
                return ((ErrorAnnotation)annotation).getLayer();
            }
            return 0;
        }

        public void paint(Annotation annotation, GC gc, Canvas canvas, Rectangle bounds) {
            ImageUtilities.drawImage((Image)((ErrorAnnotation)annotation).getImage(), (GC)gc, (Canvas)canvas, (Rectangle)bounds, (int)0x1000000, (int)128);
        }

        public boolean isPaintable(Annotation annotation) {
            if (annotation instanceof ErrorAnnotation) {
                return ((ErrorAnnotation)annotation).getImage() != null;
            }
            return false;
        }

        public boolean isSubtype(Object annotationType, Object potentialSupertype) {
            return annotationType.equals(potentialSupertype);
        }

        public Object[] getSupertypes(Object annotationType) {
            return new Object[0];
        }
    }

    public static class ErrorAnnotation
    extends Annotation {
        public static String ERROR_TYPE = "spelling.error";
        private final IMarker marker;
        private String text;
        private int line;
        private Position position;

        public ErrorAnnotation(IMarker marker) {
            this.marker = marker;
        }

        public ErrorAnnotation(int line, String text) {
            super(ERROR_TYPE, true, null);
            this.marker = null;
            this.line = line;
            this.text = text;
        }

        public IMarker getMarker() {
            return this.marker;
        }

        public int getLine() {
            return this.line;
        }

        public String getText() {
            return this.text;
        }

        public Image getImage() {
            return null;
        }

        public int getLayer() {
            return 3;
        }

        public String getType() {
            return ERROR_TYPE;
        }

        public Position getPosition() {
            return this.position;
        }

        public void setPosition(Position position) {
            this.position = position;
        }
    }

    static class SharedTextColors
    implements ISharedTextColors {
        public Color getColor(RGB rgb) {
            return CommonColors.TEXT_SPELLING_ERROR;
        }

        public void dispose() {
        }
    }
}

