/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.commands;

import java.util.Collections;
import java.util.Date;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.mylyn.internal.commons.ui.TreeWalker;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.actions.ClearOutgoingAction;
import org.eclipse.mylyn.internal.tasks.ui.commands.AbstractTaskHandler;
import org.eclipse.mylyn.internal.tasks.ui.commands.AbstractTaskListViewHandler;
import org.eclipse.mylyn.internal.tasks.ui.commands.GoToUnreadTaskHandler;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskListView;
import org.eclipse.mylyn.tasks.core.IRepositoryElement;
import org.eclipse.mylyn.tasks.core.ITask;

public abstract class MarkTaskHandler
extends AbstractTaskHandler {

    public static class ClearOutgoingHandler
    extends AbstractTaskHandler {
        protected void execute(ExecutionEvent event, ITask task) throws ExecutionException {
            ClearOutgoingAction action = new ClearOutgoingAction(Collections.singletonList(task));
            if (action.isEnabled()) {
                action.run();
            }
        }
    }

    public static class MarkTaskCompleteHandler
    extends AbstractTaskHandler {
        protected void execute(ExecutionEvent event, ITask task) throws ExecutionException {
            if (TasksUiInternal.hasLocalCompletionState(task)) {
                task.setCompletionDate(new Date());
                TasksUiPlugin.getTaskList().notifyElementChanged((IRepositoryElement)task);
            }
        }
    }

    public static class MarkTaskIncompleteHandler
    extends AbstractTaskHandler {
        protected void execute(ExecutionEvent event, ITask task) throws ExecutionException {
            if (TasksUiInternal.hasLocalCompletionState(task)) {
                task.setCompletionDate(null);
                TasksUiPlugin.getTaskList().notifyElementChanged((IRepositoryElement)task);
            }
        }
    }

    public static class MarkTaskReadGoToNextUnreadTaskHandler
    extends AbstractTaskListViewHandler {
        protected void execute(ExecutionEvent event, TaskListView taskListView, IRepositoryElement item) throws ExecutionException {
            if (item instanceof ITask) {
                ITask task = (ITask)item;
                TasksUiPlugin.getTaskDataManager().setTaskRead(task, true);
                GoToUnreadTaskHandler.execute(event, TreeWalker.Direction.DOWN);
            }
        }
    }

    public static class MarkTaskReadGoToPreviousUnreadTaskHandler
    extends AbstractTaskListViewHandler {
        protected void execute(ExecutionEvent event, TaskListView taskListView, IRepositoryElement item) throws ExecutionException {
            if (item instanceof ITask) {
                ITask task = (ITask)item;
                TasksUiPlugin.getTaskDataManager().setTaskRead(task, true);
                GoToUnreadTaskHandler.execute(event, TreeWalker.Direction.UP);
            }
        }
    }

    public static class MarkTaskReadHandler
    extends AbstractTaskHandler {
        protected void execute(ExecutionEvent event, ITask task) throws ExecutionException {
            TasksUiPlugin.getTaskDataManager().setTaskRead(task, true);
        }
    }

    public static class MarkTaskUnreadHandler
    extends AbstractTaskHandler {
        protected void execute(ExecutionEvent event, ITask task) throws ExecutionException {
            TasksUiPlugin.getTaskDataManager().setTaskRead(task, false);
        }
    }
}

