/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.actions;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskExportAction
extends Action
implements IViewActionDelegate {
    protected ISelection selection;

    public void init(IViewPart view) {
    }

    public void run(IAction action) {
        this.run(this.getSelectedTasks(this.selection));
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection;
        List<AbstractTask> tasks = this.getSelectedTasks(selection);
        action.setEnabled(true);
        if (tasks.size() > 0) {
            action.setEnabled(true);
        } else {
            action.setEnabled(false);
        }
    }

    protected List<AbstractTask> getSelectedTasks(ISelection newSelection) {
        ArrayList<AbstractTask> selectedQueries = new ArrayList<AbstractTask>();
        if (this.selection instanceof StructuredSelection) {
            List selectedObjects = ((StructuredSelection)this.selection).toList();
            for (Object selectedObject : selectedObjects) {
                if (!(selectedObject instanceof ITask)) continue;
                selectedQueries.add((AbstractTask)selectedObject);
            }
        }
        return selectedQueries;
    }

    public void run(List<AbstractTask> tasks) {
        Object file;
        FileDialog dialog;
        HashMap<AbstractTask, Object> taskFiles = new HashMap<AbstractTask, Object>();
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        if (tasks.size() == 1) {
            dialog = new FileDialog(shell, 40960);
            dialog.setFilterExtensions(new String[]{"*.xml.zip"});
            AbstractTask task = tasks.get(0);
            dialog.setFileName(this.encodeName((ITask)task));
            String path = dialog.open();
            if (path != null) {
                file = new File(path);
                if (((File)file).isDirectory()) {
                    MessageDialog.openError((Shell)shell, (String)"Task Export Error", (String)"Could not export task because specified location is a folder");
                    return;
                }
                taskFiles.put(task, file);
            }
        } else {
            dialog = new DirectoryDialog(shell, 40960);
            String path = dialog.open();
            for (AbstractTask task : tasks) {
                File file2 = new File(path, this.encodeName((ITask)task));
                taskFiles.put(task, file2);
            }
        }
        for (Map.Entry entry : taskFiles.entrySet()) {
            AbstractTask task;
            task = (AbstractTask)entry.getKey();
            file = (File)entry.getValue();
            if (((File)file).exists() && !MessageDialog.openQuestion((Shell)shell, (String)"Confirm File Replace", (String)("The file " + ((File)file).getPath() + " already exists. Do you want to overwrite it?"))) continue;
            TasksUiPlugin.getTaskListManager().getTaskListWriter().writeTask(task, (File)file);
        }
    }

    private String encodeName(ITask task) {
        String fileName = task.getSummary();
        if (fileName.length() > 50) {
            fileName = fileName.substring(0, 50);
        }
        fileName = String.valueOf(task.getTaskId()) + " - " + fileName + ".xml.zip";
        return fileName;
    }
}

