/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.actions;

import java.util.Iterator;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.mylyn.internal.provisional.commons.ui.CommonImages;
import org.eclipse.mylyn.internal.tasks.ui.deprecated.AbstractRepositoryTaskEditor;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditor;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.BaseSelectionListenerAction;

public class SynchronizeEditorAction
extends BaseSelectionListenerAction {
    private static final String LABEL = "Synchronize";
    private static final String TOOLTIP = "Synchronize Incoming Changes";
    public static final String ID = "org.eclipse.mylyn.tasklist.actions.synchronize.editor";

    public SynchronizeEditorAction() {
        super(LABEL);
        this.setToolTipText(TOOLTIP);
        this.setId(ID);
        this.setImageDescriptor(CommonImages.REFRESH_SMALL);
    }

    public void run() {
        if (this.getStructuredSelection() != null) {
            Iterator it = this.getStructuredSelection().iterator();
            while (it.hasNext()) {
                this.runWithSelection(it.next());
            }
        }
    }

    private void runWithSelection(final Object selectedObject) {
        ITask task;
        TaskEditor editor;
        if (selectedObject instanceof TaskEditor) {
            editor = (TaskEditor)((Object)selectedObject);
            task = editor.getTaskEditorInput().getTask();
        } else if (selectedObject instanceof AbstractRepositoryTaskEditor) {
            AbstractRepositoryTaskEditor page = (AbstractRepositoryTaskEditor)((Object)selectedObject);
            editor = page.getParentEditor();
            task = page.getRepositoryTask();
        } else {
            return;
        }
        if (task != null) {
            AbstractRepositoryConnector connector = TasksUi.getRepositoryManager().getRepositoryConnector(task.getConnectorKind());
            if (connector != null) {
                TasksUiInternal.synchronizeTask(connector, task, true, (IJobChangeListener)new JobChangeAdapter(){

                    public void done(IJobChangeEvent event) {
                        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                            public void run() {
                                try {
                                    if (selectedObject instanceof TaskEditor) {
                                        TaskEditor editor2 = (TaskEditor)((Object)selectedObject);
                                        editor2.refreshPages();
                                    } else if (selectedObject instanceof AbstractRepositoryTaskEditor) {
                                        ((AbstractRepositoryTaskEditor)((Object)selectedObject)).refreshEditor();
                                    }
                                }
                                finally {
                                    if (editor != null) {
                                        editor.showBusy(false);
                                    }
                                }
                            }
                        });
                    }
                });
            }
            if (editor != null) {
                editor.showBusy(true);
            }
        }
    }
}

