/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.actions;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.mylyn.internal.tasks.core.RepositoryQuery;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryImportAction
extends Action
implements IViewActionDelegate {
    protected ISelection selection;

    public void init(IViewPart view) {
    }

    public void run(IAction action) {
        this.run();
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void run() {
        File file;
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        FileDialog dialog = new FileDialog(shell);
        dialog.setFilterExtensions(new String[]{"*.xml.zip"});
        String path = dialog.open();
        if (path != null && (file = new File(path)).isFile()) {
            try {
                List<RepositoryQuery> queries = TasksUiPlugin.getTaskListManager().getTaskListWriter().readQueries(file);
                Set<TaskRepository> repositories = TasksUiPlugin.getTaskListManager().getTaskListWriter().readRepositories(file);
                if (queries.size() > 0) {
                    this.importQueries(queries, repositories, shell);
                } else {
                    MessageDialog.openError((Shell)shell, (String)"Query Import Error", (String)"The specified file is not an exported query. Please, check that you have provided the correct file.");
                }
            }
            catch (IOException iOException) {
                MessageDialog.openError((Shell)shell, (String)"Query Import Error", (String)"The specified file is not an exported query. Please, check that you have provided the correct file.");
            }
        }
    }

    public void importQueries(List<RepositoryQuery> queries, Set<TaskRepository> repositories, Shell shell) {
        TasksUiPlugin.getRepositoryManager().insertRepositories(repositories, TasksUiPlugin.getDefault().getRepositoriesFilePath());
        List<RepositoryQuery> badQueries = this.insertQueries(queries);
        String message = "The following queries were imported successfully: ";
        for (RepositoryQuery imported : queries) {
            if (badQueries.contains(imported)) continue;
            message = String.valueOf(message) + "\n" + imported.getHandleIdentifier();
        }
        if (badQueries.size() > 0) {
            message = String.valueOf(message) + "\n\n These queries were not imported, since their repository was not found: ";
            for (RepositoryQuery bad : badQueries) {
                message = String.valueOf(message) + "\n" + bad.getHandleIdentifier();
            }
        }
        MessageDialog.openInformation((Shell)shell, (String)"Query Import Completed", (String)message);
    }

    public List<RepositoryQuery> insertQueries(List<RepositoryQuery> queries) {
        ArrayList<RepositoryQuery> badQueries = new ArrayList<RepositoryQuery>();
        for (RepositoryQuery query : queries) {
            TaskRepository repository = TasksUi.getRepositoryManager().getRepository(query.getConnectorKind(), query.getRepositoryUrl());
            if (repository == null) {
                badQueries.add(query);
                continue;
            }
            String handle = QueryImportAction.resolveIdentifiersConflict(query);
            query.setHandleIdentifier(handle);
            TasksUiInternal.getTaskList().addQuery(query);
            AbstractRepositoryConnector connector = TasksUi.getRepositoryManager().getRepositoryConnector(repository.getConnectorKind());
            if (connector == null) continue;
            TasksUiInternal.synchronizeQuery(connector, query, null, true);
        }
        return badQueries;
    }

    public static String resolveIdentifiersConflict(RepositoryQuery query) {
        String patternStr = "\\[(\\d+)\\]$";
        Pattern pattern = Pattern.compile(patternStr);
        Set existingQueries = TasksUiPlugin.getTaskListManager().getTaskList().getQueries();
        HashMap<String, RepositoryQuery> queryMap = new HashMap<String, RepositoryQuery>();
        for (RepositoryQuery existingQuery : existingQueries) {
            queryMap.put(existingQuery.getHandleIdentifier(), existingQuery);
        }
        String handle = query.getHandleIdentifier();
        while (queryMap.get(handle) != null) {
            Matcher matcher = pattern.matcher(handle);
            boolean matchFound = matcher.find();
            if (matchFound) {
                int index = Integer.parseInt(matcher.group(1));
                handle = matcher.replaceAll("[" + ++index + "]");
                continue;
            }
            handle = String.valueOf(handle) + "[1]";
        }
        return handle;
    }
}

