/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.actions;

import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.mylyn.internal.tasks.core.AbstractTaskContainer;
import org.eclipse.mylyn.internal.tasks.ui.AddExistingTaskJob;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.commands.RemoteTaskSelectionDialog;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.tasks.core.IRepositoryElement;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.ui.TasksUiUtil;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;

public class OpenRepositoryTask
extends Action
implements IWorkbenchWindowActionDelegate,
IViewActionDelegate {
    private static final String OPEN_REMOTE_TASK_DIALOG_DIALOG_SETTINGS = "org.eclipse.mylyn.tasks.ui.open.remote";

    public void run(IAction action) {
        RemoteTaskSelectionDialog dlg = new RemoteTaskSelectionDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        dlg.setTitle("Open Repository Task");
        IDialogSettings settings = TasksUiPlugin.getDefault().getDialogSettings();
        IDialogSettings dlgSettings = settings.getSection(OPEN_REMOTE_TASK_DIALOG_DIALOG_SETTINGS);
        if (dlgSettings == null) {
            dlgSettings = settings.addNewSection(OPEN_REMOTE_TASK_DIALOG_DIALOG_SETTINGS);
        }
        dlg.setDialogBoundsSettings(dlgSettings, 3);
        if (dlg.open() == 0) {
            if (dlg.getSelectedTask() != null) {
                this.openExistingTask(dlg);
            } else {
                this.openRemoteTask(dlg);
            }
        }
    }

    private void openExistingTask(RemoteTaskSelectionDialog dlg) {
        if (dlg.shouldAddToTaskList()) {
            TasksUiInternal.getTaskList().addTask((ITask)dlg.getSelectedTask(), (AbstractTaskContainer)dlg.getSelectedCategory());
        }
        TasksUiInternal.refreshAndOpenTaskListElement((IRepositoryElement)dlg.getSelectedTask());
    }

    private void openRemoteTask(RemoteTaskSelectionDialog dlg) {
        String[] selectedIds = dlg.getSelectedIds();
        if (dlg.shouldAddToTaskList()) {
            String[] stringArray = selectedIds;
            int n = selectedIds.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                final IProgressService svc = PlatformUI.getWorkbench().getProgressService();
                final AddExistingTaskJob job = new AddExistingTaskJob(dlg.getSelectedTaskRepository(), id, dlg.getSelectedCategory());
                job.schedule();
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        svc.showInDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (Job)job);
                    }
                });
                ++n2;
            }
        } else {
            boolean openSuccessful = false;
            String[] stringArray = selectedIds;
            int n = selectedIds.length;
            int n3 = 0;
            while (n3 < n) {
                String id = stringArray[n3];
                boolean opened = TasksUiUtil.openTask(dlg.getSelectedTaskRepository(), id);
                if (opened) {
                    openSuccessful = true;
                }
                ++n3;
            }
            if (!openSuccessful) {
                MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Open Task", (String)"Could not find matching repository task.");
            }
        }
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void init(IViewPart view) {
    }
}

