/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.mylyn.internal.tasks.core.deprecated.TaskComment;
import org.eclipse.mylyn.internal.tasks.core.deprecated.TaskSelection;
import org.eclipse.mylyn.internal.tasks.ui.editors.RepositoryTaskSelection;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.IRepositoryManager;
import org.eclipse.mylyn.tasks.core.ITaskComment;
import org.eclipse.mylyn.tasks.core.ITaskMapping;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.mylyn.tasks.ui.TasksUiImages;
import org.eclipse.mylyn.tasks.ui.TasksUiUtil;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class NewTaskFromSelectionAction
extends Action {
    private static final String LABEL = "New Task from Selection";
    public static final String ID = "org.eclipse.mylyn.tasks.ui.actions.newTaskFromSelection";
    private TaskSelection taskSelection;

    public NewTaskFromSelectionAction() {
        super(LABEL);
        this.setId(ID);
        this.setImageDescriptor(TasksUiImages.TASK_NEW);
    }

    public TaskSelection getTaskSelection() {
        return this.taskSelection;
    }

    public void run(IAction action) {
        this.run();
    }

    public void run() {
        if (this.taskSelection == null) {
            MessageDialog.openError(null, (String)LABEL, (String)"Nothing selected to create task from.");
            return;
        }
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        TasksUiUtil.openNewTaskEditor(shell, (ITaskMapping)this.taskSelection, null);
    }

    public void selectionChanged(ISelection selection) {
        Object element;
        if (selection instanceof TextSelection) {
            TextSelection textSelection = (TextSelection)selection;
            String text = textSelection.getText();
            this.taskSelection = text != null && text.length() > 0 ? new TaskSelection("", text) : null;
        } else if (selection instanceof RepositoryTaskSelection) {
            RepositoryTaskSelection repositoryTaskSelection = (RepositoryTaskSelection)selection;
            IRepositoryManager repositoryManager = TasksUi.getRepositoryManager();
            AbstractRepositoryConnector connector = repositoryManager.getRepositoryConnector(repositoryTaskSelection.getRepositoryKind());
            TaskComment comment = repositoryTaskSelection.getComment();
            if (comment != null) {
                StringBuilder sb = new StringBuilder();
                sb.append("\n-- Created from Comment --");
                if (connector != null) {
                    sb.append("\nURL: ");
                    sb.append(connector.getTaskUrl(repositoryTaskSelection.getRepositoryUrl(), repositoryTaskSelection.getId()));
                }
                sb.append("\nComment: ");
                sb.append(comment.getNumber());
                sb.append("\n\n");
                if (this.taskSelection != null) {
                    sb.append(this.taskSelection.getLegacyTaskData().getDescription());
                } else {
                    sb.append(comment.getText());
                }
                this.taskSelection = new TaskSelection("", sb.toString());
            } else if (this.taskSelection != null) {
                StringBuilder sb = new StringBuilder();
                if (connector != null) {
                    sb.append("\n-- Created from Task --");
                    sb.append("\nURL: ");
                    sb.append(connector.getTaskUrl(repositoryTaskSelection.getRepositoryUrl(), repositoryTaskSelection.getId()));
                }
                sb.append("\n\n");
                sb.append(this.taskSelection.getLegacyTaskData().getDescription());
                this.taskSelection = new TaskSelection("", sb.toString());
            }
        } else if (selection instanceof StructuredSelection && (element = ((StructuredSelection)selection).getFirstElement()) instanceof ITaskComment) {
            ITaskComment comment = (ITaskComment)element;
            StringBuilder sb = new StringBuilder();
            sb.append("\n-- Created from Comment --");
            if (comment.getUrl() == null) {
                sb.append("\nURL: ");
                sb.append(comment.getTask().getUrl());
                sb.append("\nComment: ");
                sb.append(comment.getNumber());
            } else {
                sb.append("\nURL: ");
                sb.append(comment.getUrl());
            }
            sb.append("\n\n");
            sb.append(comment.getText());
            this.taskSelection = new TaskSelection("", sb.toString());
        }
        this.setEnabled(this.taskSelection != null);
    }
}

