/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.AbstractTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.LocalTask;
import org.eclipse.mylyn.internal.tasks.core.TaskList;
import org.eclipse.mylyn.internal.tasks.core.deprecated.AbstractAttributeFactory;
import org.eclipse.mylyn.internal.tasks.core.deprecated.AbstractLegacyRepositoryConnector;
import org.eclipse.mylyn.internal.tasks.core.deprecated.AbstractTaskDataHandler;
import org.eclipse.mylyn.internal.tasks.core.deprecated.RepositoryTaskData;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.deprecated.NewTaskEditorInput;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMapper;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.mylyn.tasks.ui.TasksUiImages;
import org.eclipse.mylyn.tasks.ui.TasksUiUtil;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;

public class NewSubTaskAction
extends Action
implements IViewActionDelegate,
IExecutableExtension {
    private static final String TOOLTIP = "Create a new subtask";
    private static final String LABEL = "Subtask";
    public static final String ID = "org.eclipse.mylyn.tasks.ui.new.subtask";
    private AbstractTask selectedTask;

    public NewSubTaskAction() {
        super(LABEL);
        this.setToolTipText(TOOLTIP);
        this.setId(ID);
        this.setImageDescriptor(TasksUiImages.TASK_NEW_SUB);
    }

    public void run() {
        if (this.selectedTask == null) {
            return;
        }
        if (this.selectedTask instanceof LocalTask) {
            TaskList taskList = TasksUiPlugin.getTaskList();
            LocalTask newTask = new LocalTask("" + taskList.getNextLocalTaskId(), "New Task");
            newTask.setPriority(ITask.PriorityLevel.P3.toString());
            TasksUiPlugin.getTaskActivityManager().scheduleNewTask((AbstractTask)newTask);
            taskList.addTask((ITask)newTask, (AbstractTaskContainer)this.selectedTask);
            TasksUiUtil.openTask((ITask)newTask);
            return;
        }
        AbstractRepositoryConnector connector = TasksUi.getRepositoryManager().getRepositoryConnector(this.selectedTask.getConnectorKind());
        if (connector instanceof AbstractLegacyRepositoryConnector) {
            this.createLegacyTask((AbstractLegacyRepositoryConnector)connector);
            return;
        }
        TaskData taskData = this.createTaskData(connector);
        if (taskData != null) {
            try {
                TasksUiInternal.createAndOpenNewTask(taskData);
            }
            catch (CoreException e) {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Failed to open new sub task", (Throwable)e));
                TasksUiInternal.displayStatus("Unable to create subtask", (IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Failed to create new sub task: " + e.getMessage()));
            }
        }
    }

    private TaskData createTaskData(AbstractRepositoryConnector connector) {
        final org.eclipse.mylyn.tasks.core.data.AbstractTaskDataHandler taskDataHandler = connector.getTaskDataHandler();
        if (taskDataHandler == null) {
            return null;
        }
        String repositoryUrl = this.selectedTask.getRepositoryUrl();
        TaskData parentTaskData = null;
        try {
            parentTaskData = TasksUi.getTaskDataManager().getTaskData((ITask)this.selectedTask);
        }
        catch (CoreException e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Could not retrieve task data for task: " + this.selectedTask.getUrl(), (Throwable)e));
        }
        if (parentTaskData == null) {
            TasksUiInternal.displayStatus("Unable to create subtask", (IStatus)new Status(2, "org.eclipse.mylyn.tasks.ui", "Could not retrieve task data for task: " + this.selectedTask.getUrl()));
            return null;
        }
        final TaskRepository taskRepository = TasksUiPlugin.getRepositoryManager().getRepository(repositoryUrl);
        if (!taskDataHandler.canInitializeSubTaskData(taskRepository, (ITask)this.selectedTask)) {
            return null;
        }
        final TaskData selectedTaskData = parentTaskData;
        TaskAttributeMapper attributeMapper = taskDataHandler.getAttributeMapper(taskRepository);
        final TaskData taskData = new TaskData(attributeMapper, taskRepository.getConnectorKind(), taskRepository.getRepositoryUrl(), "");
        final boolean[] result = new boolean[1];
        IProgressService service = PlatformUI.getWorkbench().getProgressService();
        try {
            service.busyCursorWhile(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        result[0] = taskDataHandler.initializeSubTaskData(taskRepository, taskData, selectedTaskData, (IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof CoreException) {
                TasksUiInternal.displayStatus("Unable to create subtask", ((CoreException)e.getCause()).getStatus());
            } else {
                StatusHandler.fail((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Could not initialize sub task data for task: " + this.selectedTask.getUrl(), (Throwable)e));
            }
            return null;
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
        if (result[0]) {
            return taskData;
        }
        TasksUiInternal.displayStatus("Unable to create subtask", (IStatus)new Status(1, "org.eclipse.mylyn.tasks.ui", "The connector does not support creating subtasks for this task"));
        return null;
    }

    @Deprecated
    private void createLegacyTask(AbstractLegacyRepositoryConnector connector) {
        final AbstractTaskDataHandler taskDataHandler = connector.getLegacyTaskDataHandler();
        if (taskDataHandler == null) {
            return;
        }
        String repositoryUrl = this.selectedTask.getRepositoryUrl();
        final RepositoryTaskData selectedTaskData = TasksUiPlugin.getTaskDataStorageManager().getNewTaskData(repositoryUrl, this.selectedTask.getTaskId());
        if (selectedTaskData == null) {
            TasksUiInternal.displayStatus("Unable to create subtask", (IStatus)new Status(2, "org.eclipse.mylyn.tasks.ui", "Could not retrieve task data for task: " + this.selectedTask.getUrl()));
            return;
        }
        if (!taskDataHandler.canInitializeSubTaskData((ITask)this.selectedTask, selectedTaskData)) {
            return;
        }
        final TaskRepository taskRepository = TasksUiPlugin.getRepositoryManager().getRepository(repositoryUrl);
        AbstractAttributeFactory attributeFactory = taskDataHandler.getAttributeFactory(taskRepository.getRepositoryUrl(), taskRepository.getConnectorKind(), "task");
        final RepositoryTaskData taskData = new RepositoryTaskData(attributeFactory, this.selectedTask.getConnectorKind(), taskRepository.getRepositoryUrl(), TasksUiPlugin.getDefault().getNextNewRepositoryTaskId());
        taskData.setNew(true);
        final boolean[] result = new boolean[1];
        IProgressService service = PlatformUI.getWorkbench().getProgressService();
        try {
            service.busyCursorWhile(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        result[0] = taskDataHandler.initializeSubTaskData(taskRepository, taskData, selectedTaskData, (IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            TasksUiInternal.displayStatus("Unable to create subtask", ((CoreException)e.getCause()).getStatus());
            return;
        }
        catch (InterruptedException interruptedException) {
            return;
        }
        if (result[0]) {
            NewTaskEditorInput editorInput = new NewTaskEditorInput(taskRepository, taskData);
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            TasksUiUtil.openEditor(editorInput, "org.eclipse.mylyn.tasks.ui.editors.task", page);
        } else {
            TasksUiInternal.displayStatus("Unable to create subtask", (IStatus)new Status(1, "org.eclipse.mylyn.tasks.ui", "The connector does not support creating subtasks for this task"));
        }
    }

    public void run(IAction action) {
        this.run();
    }

    public void init(IViewPart view) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selectedTask = null;
        if (selection instanceof StructuredSelection) {
            Object selectedObject = ((StructuredSelection)selection).getFirstElement();
            if (selectedObject instanceof LocalTask) {
                if (TasksUiPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.mylyn.tasks.ui.subtasks.local")) {
                    this.selectedTask = (AbstractTask)selectedObject;
                }
            } else if (selectedObject instanceof ITask) {
                this.selectedTask = (AbstractTask)selectedObject;
                AbstractRepositoryConnector connector = TasksUi.getRepositoryManager().getRepositoryConnector(this.selectedTask.getConnectorKind());
                if (connector instanceof AbstractLegacyRepositoryConnector) {
                    AbstractTaskDataHandler taskDataHandler = ((AbstractLegacyRepositoryConnector)connector).getLegacyTaskDataHandler();
                    if (taskDataHandler == null || !taskDataHandler.canInitializeSubTaskData((ITask)this.selectedTask, null)) {
                        this.selectedTask = null;
                    }
                } else {
                    org.eclipse.mylyn.tasks.core.data.AbstractTaskDataHandler taskDataHandler = connector.getTaskDataHandler();
                    if (taskDataHandler == null || !taskDataHandler.canInitializeSubTaskData(null, (ITask)this.selectedTask)) {
                        this.selectedTask = null;
                    }
                }
            }
        }
        action.setEnabled(this.selectedTask != null);
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
    }
}

