/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.actions;

import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.deprecated.AbstractAttachmentHandler;
import org.eclipse.mylyn.internal.tasks.core.deprecated.AbstractLegacyRepositoryConnector;
import org.eclipse.mylyn.internal.tasks.ui.actions.AbstractTaskEditorAction;
import org.eclipse.mylyn.internal.tasks.ui.wizards.NewAttachmentWizard;
import org.eclipse.mylyn.internal.tasks.ui.wizards.NewAttachmentWizardDialog;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchImages;

public class AttachAction
extends AbstractTaskEditorAction {
    public static final String LABEL = "Attach...";

    public AttachAction(String label) {
        super(label);
    }

    public AttachAction() {
        super(LABEL);
        this.setId("org.eclipse.mylyn.tasks.ui.actions.add.attachment");
        this.setImageDescriptor(WorkbenchImages.getImageDescriptor((String)"IMG_OBJ_FILE"));
    }

    public void run() {
        Object selection;
        if (this.editor != null) {
            this.editor.showBusy(true);
        }
        if ((selection = this.getStructuredSelection().getFirstElement()) instanceof ITask) {
            if (this.taskDirty((ITask)selection)) {
                this.openInformationDialog(LABEL, "Submit changes or synchronize task before adding attachments.");
                return;
            }
            AbstractTask repositoryTask = (AbstractTask)selection;
            TaskRepository repository = TasksUi.getRepositoryManager().getRepository(repositoryTask.getConnectorKind(), repositoryTask.getRepositoryUrl());
            NewAttachmentWizard attachmentWizard = new NewAttachmentWizard(repository, repositoryTask);
            NewAttachmentWizardDialog dialog = new NewAttachmentWizardDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)attachmentWizard, false){

                public boolean close() {
                    boolean closed = super.close();
                    if (closed && AttachAction.this.editor != null) {
                        AttachAction.this.editor.showBusy(false);
                    }
                    return closed;
                }
            };
            attachmentWizard.setDialog(dialog);
            dialog.create();
            dialog.open();
        }
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        if (selection.getFirstElement() instanceof ITask) {
            AbstractLegacyRepositoryConnector connector;
            ITask task = (ITask)selection.getFirstElement();
            TaskRepository repository = TasksUi.getRepositoryManager().getRepository(task.getConnectorKind(), task.getRepositoryUrl());
            if (repository != null && (connector = (AbstractLegacyRepositoryConnector)TasksUi.getRepositoryManager().getRepositoryConnector(task.getConnectorKind())) != null) {
                AbstractAttachmentHandler handler = connector.getAttachmentHandler();
                return handler != null && handler.canUploadAttachment(repository, task);
            }
            return false;
        }
        return super.updateSelection(selection);
    }
}

