/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.TaskActivationHistory;
import org.eclipse.mylyn.internal.tasks.ui.TaskHistoryDropDown;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskListView;
import org.eclipse.mylyn.tasks.ui.TasksUiImages;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowPulldownDelegate;

public class ActivateTaskHistoryDropDownAction
extends Action
implements IWorkbenchWindowPulldownDelegate,
IMenuCreator {
    public static final String ID = "org.eclipse.mylyn.tasklist.actions.navigate.previous";
    private static final String LABEL = "Activate Previous Task";
    private Menu dropDownMenu;
    private final TaskActivationHistory taskHistory = TasksUiPlugin.getTaskActivityManager().getTaskActivationHistory();
    private final TaskHistoryDropDown taskHistoryDropDown = new TaskHistoryDropDown(null, this.taskHistory);

    public ActivateTaskHistoryDropDownAction() {
        this.setText(LABEL);
        this.setToolTipText(LABEL);
        this.setId(ID);
        this.setEnabled(true);
        this.setImageDescriptor(TasksUiImages.CONTEXT_HISTORY_PREVIOUS);
    }

    public void dispose() {
    }

    public Menu getMenu(Control parent) {
        if (this.dropDownMenu != null) {
            this.dropDownMenu.dispose();
        }
        this.dropDownMenu = new Menu(parent);
        this.taskHistoryDropDown.fill(this.dropDownMenu, -1);
        return this.dropDownMenu;
    }

    public Menu getMenu(Menu parent) {
        if (this.dropDownMenu != null) {
            this.dropDownMenu.dispose();
        }
        this.dropDownMenu = new Menu(parent);
        this.taskHistoryDropDown.fill(this.dropDownMenu, -1);
        return this.dropDownMenu;
    }

    public void init(IWorkbenchWindow window) {
    }

    public void run() {
        if (this.taskHistory.hasPrevious()) {
            AbstractTask previousTask = this.taskHistory.getPreviousTask();
            if (previousTask != null && !previousTask.isActive()) {
                TasksUiPlugin.getTaskListManager().activateTask(previousTask, false);
                if (TaskListView.getFromActivePerspective() != null) {
                    TaskListView.getFromActivePerspective().refresh();
                }
            }
            this.setEnabled(this.taskHistory.getPreviousTasks() != null && this.taskHistory.getPreviousTasks().size() > 0);
        }
    }

    public void run(IAction action) {
        this.run();
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

