/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.TransferData;

public class TaskTransfer
extends ByteArrayTransfer {
    private static final TaskTransfer INSTANCE = new TaskTransfer();
    private static final String TYPE_NAME = "task-transfer-format:" + System.currentTimeMillis() + ":" + ((Object)((Object)INSTANCE)).hashCode();
    private static final int TYPEID = TaskTransfer.registerType((String)TYPE_NAME);

    private TaskTransfer() {
    }

    public static TaskTransfer getInstance() {
        return INSTANCE;
    }

    protected int[] getTypeIds() {
        return new int[]{TYPEID};
    }

    protected String[] getTypeNames() {
        return new String[]{TYPE_NAME};
    }

    protected void javaToNative(Object data, TransferData transferData) {
        if (!(data instanceof ITask[])) {
            return;
        }
        ITask[] tasks = (ITask[])data;
        int resourceCount = tasks.length;
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            DataOutputStream dataOut = new DataOutputStream(out);
            dataOut.writeInt(resourceCount);
            ITask[] iTaskArray = tasks;
            int n = tasks.length;
            int n2 = 0;
            while (n2 < n) {
                ITask task = iTaskArray[n2];
                this.writeTask(dataOut, task);
                ++n2;
            }
            dataOut.close();
            out.close();
            byte[] bytes = out.toByteArray();
            super.javaToNative((Object)bytes, transferData);
        }
        catch (IOException iOException) {}
    }

    protected Object nativeToJava(TransferData transferData) {
        byte[] bytes = (byte[])super.nativeToJava(transferData);
        if (bytes == null) {
            return null;
        }
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(bytes));
        try {
            int count = in.readInt();
            ITask[] results = new ITask[count];
            int i = 0;
            while (i < count) {
                results[i] = this.readTask(in);
                ++i;
            }
            return results;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private ITask readTask(DataInputStream dataIn) throws IOException {
        String handle = dataIn.readUTF();
        return TasksUiPlugin.getTaskList().getTask(handle);
    }

    private void writeTask(DataOutputStream dataOut, ITask task) throws IOException {
        dataOut.writeUTF(task.getHandleIdentifier());
    }
}

