/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.SortedMap;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.TaskActivityUtil;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.util.TaskDataExportOperation;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskListBackupManager
implements IPropertyChangeListener {
    private static final String OLD_MYLYN_2_BACKUP_FILE_PREFIX = "mylyndata-";
    private static final String BACKUP_FILE_PREFIX = "mylyn-v3-data-";
    private static final Pattern MYLYN_BACKUP_REGEXP = Pattern.compile("^(mylyn-v3-data-)?(mylyndata-)?");
    private static final Pattern DATE_FORMAT_OLD = Pattern.compile("\\d{4}-\\d{2}-\\d{2}");
    private static final Pattern DATE_FORMAT = Pattern.compile("\\d{4}-\\d{2}-\\d{2}-\\d{6}");
    private static final String TITLE_TASKLIST_BACKUP = "Tasklist Backup";
    private static final String BACKUP_JOB_NAME = "Scheduled task data backup";
    public static final String BACKUP_FAILURE_MESSAGE = "Could not backup task data. Check backup preferences.\n";
    private static final long SECOND = 1000L;
    private static final long MINUTE = 60000L;
    private Timer timer;
    private String backupFolderPath;
    private ExportJob export;

    public TaskListBackupManager(String backupFolderPath) {
        this.backupFolderPath = backupFolderPath;
        this.start(1800000L);
    }

    public void start(long delay) {
        this.timer = new Timer();
        this.timer.schedule((TimerTask)new CheckBackupRequired(), delay, 1800000L);
    }

    public void stop() {
        this.timer.cancel();
    }

    public static String getBackupFileName() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd-HHmmss", Locale.ENGLISH);
        String date = format.format(new Date());
        String backupFileName = BACKUP_FILE_PREFIX + date + ".zip";
        return backupFileName;
    }

    public void backupNow(boolean synchronous) {
        File backupFolder = new File(this.backupFolderPath);
        if (!backupFolder.exists()) {
            backupFolder.mkdir();
        }
        if (!synchronous) {
            this.export = new ExportJob(this.backupFolderPath, TaskListBackupManager.getBackupFileName());
            this.export.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    TaskListBackupManager.this.removeOldBackups();
                }
            });
            this.export.schedule();
        } else {
            TaskDataExportOperation backupJob = new TaskDataExportOperation(this.backupFolderPath, true, true, false, true, TaskListBackupManager.getBackupFileName(), new HashSet<AbstractTask>());
            IProgressService service = PlatformUI.getWorkbench().getProgressService();
            try {
                service.run(false, true, (IRunnableWithProgress)backupJob);
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                MessageDialog.openError(null, (String)TITLE_TASKLIST_BACKUP, (String)BACKUP_FAILURE_MESSAGE);
            }
        }
    }

    public SortedMap<Long, File> getBackupFiles() {
        TreeMap<Long, File> filesMap = new TreeMap<Long, File>();
        String destination = this.backupFolderPath;
        File backupFolder = new File(destination);
        if (!backupFolder.exists()) {
            return filesMap;
        }
        File[] files = backupFolder.listFiles();
        if (files == null) {
            return filesMap;
        }
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            block11: {
                File file = fileArray[n2];
                Matcher matcher = MYLYN_BACKUP_REGEXP.matcher(file.getName());
                if (matcher.find()) {
                    Date date = null;
                    try {
                        SimpleDateFormat format = null;
                        String dateText = null;
                        Matcher dateFormatMatcher = DATE_FORMAT.matcher(file.getName());
                        if (dateFormatMatcher.find()) {
                            format = new SimpleDateFormat("yyyy-MM-dd-HHmmss", Locale.ENGLISH);
                            dateText = dateFormatMatcher.group();
                        } else {
                            dateFormatMatcher = DATE_FORMAT_OLD.matcher(file.getName());
                            if (dateFormatMatcher.find()) {
                                format = new SimpleDateFormat("yyyy-MM-dd", Locale.ENGLISH);
                                dateText = dateFormatMatcher.group();
                            }
                        }
                        if (format == null || dateText == null || dateText.length() <= 0) break block11;
                        date = format.parse(dateText);
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        break block11;
                    }
                    catch (ParseException parseException) {
                        break block11;
                    }
                    if (date != null && date.getTime() > 0L) {
                        filesMap.put(new Long(date.getTime()), file);
                    }
                }
            }
            ++n2;
        }
        return filesMap;
    }

    public synchronized void removeOldBackups() {
        SortedMap<Long, File> filesMap = this.getBackupFiles();
        if (filesMap.size() > 0) {
            File toDelete;
            SortedMap<Long, File> subMap;
            Calendar rangeStart = TaskActivityUtil.getCalendar();
            rangeStart.setTimeInMillis(filesMap.lastKey());
            TaskActivityUtil.snapStartOfHour((Calendar)rangeStart);
            int startHour = rangeStart.get(11);
            Calendar rangeEnd = TaskActivityUtil.getCalendar();
            rangeEnd.setTimeInMillis(rangeStart.getTimeInMillis());
            rangeEnd.add(11, 1);
            int x = 0;
            while (x <= startHour && x < 9) {
                subMap = filesMap.subMap(rangeStart.getTimeInMillis(), rangeEnd.getTimeInMillis());
                if (subMap.size() > 1) {
                    while (subMap.size() > 1) {
                        toDelete = (File)subMap.remove(subMap.firstKey());
                        toDelete.delete();
                    }
                }
                rangeStart.add(11, -1);
                rangeEnd.add(11, -1);
                ++x;
            }
            TaskActivityUtil.snapStartOfDay((Calendar)rangeEnd);
            rangeStart.add(6, -1);
            x = 1;
            while (x <= 12) {
                subMap = filesMap.subMap(rangeStart.getTimeInMillis(), rangeEnd.getTimeInMillis());
                if (subMap.size() > 1) {
                    while (subMap.size() > 1) {
                        toDelete = (File)subMap.remove(subMap.firstKey());
                        toDelete.delete();
                    }
                }
                rangeStart.add(6, -1);
                rangeEnd.add(6, -1);
                ++x;
            }
            SortedMap<Long, File> subMap2 = filesMap.subMap(0L, rangeStart.getTimeInMillis());
            if (subMap2.size() > 0) {
                while (subMap2.size() > 0) {
                    File toDelete2 = (File)subMap2.remove(subMap2.firstKey());
                    toDelete2.delete();
                }
            }
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("org.eclipse.mylyn.data.dir")) {
            if (this.export != null) {
                this.export.cancel();
                this.export = null;
            }
            this.backupFolderPath = TasksUiPlugin.getDefault().getBackupFolderPath();
        }
    }

    class CheckBackupRequired
    extends TimerTask {
        CheckBackupRequired() {
        }

        public void run() {
            if (TasksUiPlugin.getTaskList().getAllTasks().size() > 0) {
                TaskListBackupManager.this.backupNow(false);
            }
        }
    }

    static class ExportJob
    extends Job {
        final TaskDataExportOperation backupJob;

        public ExportJob(String destination, String filename) {
            super(TaskListBackupManager.BACKUP_JOB_NAME);
            this.backupJob = new TaskDataExportOperation(destination, true, true, false, true, filename, new HashSet<AbstractTask>());
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                if (Platform.isRunning()) {
                    this.backupJob.run(monitor);
                }
            }
            catch (InvocationTargetException invocationTargetException) {
                MessageDialog.openError(null, (String)TaskListBackupManager.BACKUP_JOB_NAME, (String)"Error occured during scheduled tasklist backup.\nCheck settings on Tasklist preferences page.");
            }
            catch (InterruptedException interruptedException) {
                return Status.CANCEL_STATUS;
            }
            return Status.OK_STATUS;
        }
    }
}

