/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui;

import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.context.core.AbstractContextListener;
import org.eclipse.mylyn.context.core.IInteractionElement;
import org.eclipse.mylyn.internal.context.core.InteractionContextManager;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.TaskActivityManager;
import org.eclipse.mylyn.internal.tasks.core.TaskList;
import org.eclipse.mylyn.internal.tasks.ui.ActivityExternalizationParticipant;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.monitor.core.InteractionEvent;
import org.eclipse.mylyn.tasks.core.ITask;

public class TaskActivityMonitor {
    private final InteractionContextManager contextManager;
    private final TaskActivityManager taskActivityManager;
    private final TaskList taskList;
    private final AbstractContextListener CONTEXT_LISTENER = new AbstractContextListener(){

        public void interestChanged(List<IInteractionElement> elements) {
            List events = TaskActivityMonitor.this.contextManager.getActivityMetaContext().getInteractionHistory();
            InteractionEvent event = (InteractionEvent)events.get(events.size() - 1);
            TaskActivityMonitor.this.parseInteractionEvent(event, false);
        }
    };
    private ActivityExternalizationParticipant externalizationParticipant;

    public TaskActivityMonitor(TaskActivityManager taskActivityManager, InteractionContextManager contextManager) {
        this.taskActivityManager = taskActivityManager;
        this.contextManager = contextManager;
        this.taskList = TasksUiPlugin.getTaskList();
    }

    public void start() {
        this.contextManager.addActivityMetaContextListener(this.CONTEXT_LISTENER);
    }

    public boolean parseInteractionEvent(InteractionEvent event, boolean isReloading) {
        block12: {
            AbstractTask activatedTask;
            if (!event.getKind().equals((Object)InteractionEvent.Kind.COMMAND)) break block12;
            if (event.getDelta().equals("activated") && (activatedTask = this.taskList.getTask(event.getStructureHandle())) != null) {
                this.taskActivityManager.getTaskActivationHistory().addTask(activatedTask);
                return true;
            }
        }
        try {
            if (event.getKind().equals((Object)InteractionEvent.Kind.ATTENTION)) {
                AbstractTask task;
                if (event.getDelta().equals("added") || event.getDelta().equals("add")) {
                    if (event.getStructureKind().equals("workingset")) {
                        this.taskActivityManager.addWorkingSetElapsedTime(event.getStructureHandle(), event.getDate(), event.getEndDate());
                        if (!isReloading) {
                            this.externalizationParticipant.setDirty(true);
                            this.externalizationParticipant.elapsedTimeUpdated(null, 0L);
                        }
                    } else {
                        AbstractTask activatedTask = this.taskList.getTask(event.getStructureHandle());
                        if (activatedTask != null) {
                            this.taskActivityManager.addElapsedTime(activatedTask, event.getDate(), event.getEndDate());
                        }
                    }
                } else if (event.getDelta().equals("removed") && (task = this.taskList.getTask(event.getStructureHandle())) != null) {
                    this.taskActivityManager.removeElapsedTime((ITask)task, event.getDate(), event.getEndDate());
                }
            }
        }
        catch (Throwable t) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.core", "Error parsing interaction event", t));
        }
        return false;
    }

    public void stop() {
        this.contextManager.removeActivityMetaContextListener(this.CONTEXT_LISTENER);
    }

    public void reloadActivityTime() {
        this.taskActivityManager.clearActivity();
        List events = this.contextManager.getActivityMetaContext().getInteractionHistory();
        for (InteractionEvent event : events) {
            this.parseInteractionEvent(event, true);
        }
    }

    protected ITask getHistoryTaskAt(int pos) {
        InteractionEvent event = (InteractionEvent)this.contextManager.getActivityMetaContext().getInteractionHistory().get(pos);
        if (event.getDelta().equals("activated")) {
            return TasksUiPlugin.getTaskList().getTask(event.getStructureHandle());
        }
        return null;
    }

    public void setExternalizationParticipant(ActivityExternalizationParticipant participant) {
        this.externalizationParticipant = participant;
    }
}

