/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.URLDecoder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.context.core.ContextCorePlugin;
import org.eclipse.mylyn.internal.context.core.InteractionContext;
import org.eclipse.mylyn.internal.tasks.core.ITasksCoreConstants;
import org.eclipse.mylyn.internal.tasks.core.RepositoryTaskHandleUtil;
import org.eclipse.mylyn.internal.tasks.core.data.TaskDataManager;
import org.eclipse.mylyn.internal.tasks.ui.TaskListModifyOperation;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.monitor.core.InteractionEvent;
import org.eclipse.mylyn.tasks.core.ITask;

public class RefactorRepositoryUrlOperation
extends TaskListModifyOperation {
    private final String oldUrl;
    private final String newUrl;

    public RefactorRepositoryUrlOperation(String oldUrl, String newUrl) {
        super(ITasksCoreConstants.ROOT_SCHEDULING_RULE);
        this.oldUrl = oldUrl;
        this.newUrl = newUrl;
    }

    protected void operations(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        if (this.oldUrl == null || this.newUrl == null || this.oldUrl.equals(this.newUrl)) {
            return;
        }
        try {
            monitor.beginTask("Repository URL update", -1);
            this.refactorOfflineHandles(this.oldUrl, this.newUrl);
            this.getTaskList().refactorRepositoryUrl(this.oldUrl, this.newUrl);
            this.refactorMetaContextHandles(this.oldUrl, this.newUrl);
            this.refactorContextFileNames();
            TasksUiPlugin.getTaskActivityMonitor().reloadActivityTime();
        }
        finally {
            monitor.done();
        }
    }

    public void refactorContextFileNames() {
        File[] files;
        File dataDir = new File(TasksUiPlugin.getDefault().getDataDirectory(), "contexts");
        if (dataDir.exists() && dataDir.isDirectory() && (files = dataDir.listFiles()) != null) {
            File[] fileArray = dataDir.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                int dotIndex = file.getName().lastIndexOf(".xml");
                if (dotIndex != -1) {
                    try {
                        String storedUrl;
                        String storedHandle = URLDecoder.decode(file.getName().substring(0, dotIndex), "UTF-8");
                        int delimIndex = storedHandle.lastIndexOf("-");
                        if (delimIndex != -1 && this.oldUrl.equals(storedUrl = storedHandle.substring(0, delimIndex))) {
                            String id = RepositoryTaskHandleUtil.getTaskId((String)storedHandle);
                            String newHandle = RepositoryTaskHandleUtil.getHandle((String)this.newUrl, (String)id);
                            File newFile = ContextCorePlugin.getContextStore().getFileForContext(newHandle);
                            file.renameTo(newFile);
                        }
                    }
                    catch (Exception e) {
                        StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Could not move context file: " + file.getName(), (Throwable)e));
                    }
                }
                ++n2;
            }
        }
    }

    private void refactorOfflineHandles(String oldRepositoryUrl, String newRepositoryUrl) throws CoreException {
        TaskDataManager taskDataManager = TasksUiPlugin.getTaskDataManager();
        for (ITask task : this.getTaskList().getAllTasks()) {
            if (!task.getRepositoryUrl().equals(oldRepositoryUrl)) continue;
            taskDataManager.refactorRepositoryUrl(task, newRepositoryUrl);
        }
    }

    private void refactorMetaContextHandles(String oldRepositoryUrl, String newRepositoryUrl) {
        InteractionContext metaContext = ContextCorePlugin.getContextManager().getActivityMetaContext();
        ContextCorePlugin.getContextManager().resetActivityMetaContext();
        InteractionContext newMetaContext = ContextCorePlugin.getContextManager().getActivityMetaContext();
        for (InteractionEvent event : metaContext.getInteractionHistory()) {
            String taskId;
            String storedUrl;
            if (event.getStructureHandle() != null && (storedUrl = RepositoryTaskHandleUtil.getRepositoryUrl((String)event.getStructureHandle())) != null && oldRepositoryUrl.equals(storedUrl) && (taskId = RepositoryTaskHandleUtil.getTaskId((String)event.getStructureHandle())) != null) {
                String newHandle = RepositoryTaskHandleUtil.getHandle((String)newRepositoryUrl, (String)taskId);
                event = new InteractionEvent(event.getKind(), event.getStructureKind(), newHandle, event.getOriginId(), event.getNavigation(), event.getDelta(), event.getInterestContribution(), event.getDate(), event.getEndDate());
            }
            newMetaContext.parseEvent(event);
        }
    }
}

