/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.deprecated.AbstractLegacyRepositoryConnector;
import org.eclipse.mylyn.internal.tasks.core.deprecated.AbstractTaskDataHandler;
import org.eclipse.mylyn.internal.tasks.core.deprecated.RepositoryTaskData;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.mylyn.tasks.ui.TasksUiUtil;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

public class OpenRepositoryTaskJob
extends Job {
    private final String repositoryUrl;
    private final IWorkbenchPage page;
    private final String repositoryKind;
    private final String taskId;
    private final String taskUrl;

    public OpenRepositoryTaskJob(String repositoryKind, String repositoryUrl, String taskId, String taskUrl, IWorkbenchPage page) {
        super("Opening repository task " + taskId);
        this.repositoryKind = repositoryKind;
        this.taskId = taskId;
        this.repositoryUrl = repositoryUrl;
        this.taskUrl = taskUrl;
        this.page = page;
    }

    public IStatus run(IProgressMonitor monitor) {
        block11: {
            monitor.beginTask("Opening Remote Task", 10);
            TaskRepository repository = TasksUi.getRepositoryManager().getRepository(this.repositoryKind, this.repositoryUrl);
            if (repository == null) {
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        MessageDialog.openError(null, (String)"Repository Not Found", (String)("Could not find repository configuration for " + OpenRepositoryTaskJob.this.repositoryUrl + ". \nPlease set up repository via " + "Task Repositories" + "."));
                        TasksUiUtil.openUrl(OpenRepositoryTaskJob.this.taskUrl);
                    }
                });
                return Status.OK_STATUS;
            }
            AbstractRepositoryConnector connector = TasksUi.getRepositoryManager().getRepositoryConnector(this.repositoryKind);
            try {
                try {
                    if (connector instanceof AbstractLegacyRepositoryConnector) {
                        AbstractTaskDataHandler offlineHandler = ((AbstractLegacyRepositoryConnector)connector).getLegacyTaskDataHandler();
                        if (offlineHandler != null) {
                            RepositoryTaskData downloadedTaskData = null;
                            downloadedTaskData = offlineHandler.getTaskData(repository, this.taskId, monitor);
                            if (downloadedTaskData != null) {
                                TasksUiPlugin.getTaskDataStorageManager().setNewTaskData(downloadedTaskData);
                            }
                            this.openEditor(repository, (AbstractLegacyRepositoryConnector)connector, repository, downloadedTaskData);
                        } else {
                            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                                public void run() {
                                    TasksUiUtil.openUrl(OpenRepositoryTaskJob.this.taskUrl);
                                }
                            });
                        }
                        break block11;
                    }
                    TaskData taskData = connector.getTaskData(repository, this.taskId, monitor);
                    if (taskData != null) {
                        final ITask task = TasksUi.getRepositoryModel().createTask(repository, taskData.getTaskId());
                        TasksUiPlugin.getTaskDataManager().putUpdatedTaskData(task, taskData, true);
                        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                            public void run() {
                                TasksUiUtil.openTask(task);
                            }
                        });
                        break block11;
                    }
                    PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            TasksUiUtil.openUrl(OpenRepositoryTaskJob.this.taskUrl);
                        }
                    });
                }
                catch (CoreException e) {
                    PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            TasksUiInternal.displayStatus("Unable to open task", e.getStatus());
                        }
                    });
                    monitor.done();
                }
            }
            finally {
                monitor.done();
            }
        }
        return Status.OK_STATUS;
    }

    private void openEditor(final TaskRepository repository, final AbstractLegacyRepositoryConnector connector, final TaskRepository taskRepository, final RepositoryTaskData taskData) {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            public void run() {
                if (taskData == null) {
                    TasksUiUtil.openUrl(OpenRepositoryTaskJob.this.taskUrl);
                } else {
                    AbstractTask task = connector.createTask(taskData.getRepositoryUrl(), taskData.getTaskId(), taskData.getSummary());
                    connector.updateTaskFromTaskData(taskRepository, (ITask)task, taskData);
                    TaskEditorInput editorInput = new TaskEditorInput(repository, (ITask)task);
                    TasksUiUtil.openEditor(editorInput, "org.eclipse.mylyn.tasks.ui.editors.task", OpenRepositoryTaskJob.this.page);
                }
            }
        });
    }
}

