/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui;

import java.util.Map;
import java.util.Queue;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.tasks.core.ITaskDataStorage;
import org.eclipse.mylyn.internal.tasks.core.TaskDataState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class OfflineCachingStorage
implements ITaskDataStorage {
    private static final int DEFAULT_FLUSH_INTERVAL = 60000;
    private static final int MAX_READ_QUEUE_SIZE = 80;
    private final Map<String, Map<String, TaskDataState>> readCache = new ConcurrentHashMap<String, Map<String, TaskDataState>>();
    private final Map<String, Map<String, TaskDataState>> writeCache = new ConcurrentHashMap<String, Map<String, TaskDataState>>();
    private final Queue<TaskDataState> lruQueue = new ConcurrentLinkedQueue<TaskDataState>();
    private final ITaskDataStorage storage;
    private CacheFlushJob cacheFlushJob;
    private Timer cacheFlushTimer;

    public OfflineCachingStorage(ITaskDataStorage storage) {
        this.storage = storage;
    }

    public void clear() {
        if (this.cacheFlushJob != null) {
            this.cacheFlushJob.waitSaveCompleted();
        }
        this.readCache.clear();
        this.writeCache.clear();
        this.lruQueue.clear();
        this.storage.clear();
    }

    public void flush() {
        this.cacheFlushJob.waitSaveCompleted();
        this.persistToStorage();
    }

    public TaskDataState get(String repositoryUrl, String id) {
        TaskDataState result = null;
        result = this.retrieveFromCache(this.writeCache, repositoryUrl, id);
        if (result == null) {
            result = this.retrieveFromCache(this.readCache, repositoryUrl, id);
        }
        if (result == null) {
            result = this.retrieveFromStorage(repositoryUrl, id);
        }
        if (result != null) {
            this.pushRead(result);
        }
        return result;
    }

    private TaskDataState retrieveFromCache(Map<String, Map<String, TaskDataState>> cache, String repositoryUrl, String id) {
        Map<String, TaskDataState> idMap = cache.get(repositoryUrl);
        if (idMap != null) {
            return idMap.get(id);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TaskDataState retrieveFromStorage(String repositoryUrl, String id) {
        TaskDataState result = null;
        Map<String, Map<String, TaskDataState>> map = this.readCache;
        synchronized (map) {
            Map<String, TaskDataState> idMap = this.readCache.get(repositoryUrl);
            if (idMap == null) {
                idMap = new ConcurrentHashMap<String, TaskDataState>();
                this.readCache.put(repositoryUrl, idMap);
            } else {
                result = idMap.get(id);
            }
            if (result == null && (result = this.storage.get(repositoryUrl, id)) != null) {
                idMap.put(id, result);
            }
        }
        return result;
    }

    public void put(TaskDataState taskDataState) {
        this.putReadCache(taskDataState);
        this.putWriteCache(taskDataState);
        if (this.cacheFlushJob != null) {
            this.cacheFlushJob.requestSave();
        }
    }

    public void remove(String repositoryUrl, String id) {
        Map<String, TaskDataState> idMap = this.writeCache.get(repositoryUrl);
        if (idMap != null) {
            idMap.remove(id);
        }
        if ((idMap = this.readCache.get(repositoryUrl)) != null) {
            idMap.remove(id);
        }
        this.lruQueue.remove(new TaskDataState(repositoryUrl, id));
        this.storage.remove(repositoryUrl, id);
    }

    public void start() throws Exception {
        this.storage.start();
        if (this.cacheFlushTimer == null && this.cacheFlushJob == null) {
            this.cacheFlushTimer = new Timer();
            this.cacheFlushTimer.schedule((TimerTask)new RequestSaveTimerTask(), 60000L, 60000L);
            this.cacheFlushJob = new CacheFlushJob();
            this.cacheFlushJob.schedule();
        }
    }

    public void stop() throws Exception {
        this.cacheFlushTimer.cancel();
        this.cacheFlushJob.cancel();
        this.flush();
        this.cacheFlushTimer = null;
        this.cacheFlushJob = null;
        this.storage.stop();
    }

    private void pushRead(TaskDataState state) {
        this.lruQueue.remove(state);
        this.lruQueue.add(state);
        if (this.lruQueue.size() > 80) {
            this.flushReadCache(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putReadCache(TaskDataState taskDataState) {
        if (taskDataState == null) {
            return;
        }
        Map<String, Map<String, TaskDataState>> map = this.readCache;
        synchronized (map) {
            Map<String, TaskDataState> idMap = this.readCache.get(taskDataState.getUrl());
            if (idMap == null) {
                idMap = new ConcurrentHashMap<String, TaskDataState>();
                this.readCache.put(taskDataState.getUrl(), idMap);
            }
            idMap.put(taskDataState.getId(), taskDataState);
        }
        this.pushRead(taskDataState);
    }

    private synchronized void putWriteCache(TaskDataState taskDataState) {
        if (taskDataState == null) {
            return;
        }
        Map<String, TaskDataState> idMap = this.writeCache.get(taskDataState.getUrl());
        if (idMap == null) {
            idMap = new ConcurrentHashMap<String, TaskDataState>();
            this.writeCache.put(taskDataState.getUrl(), idMap);
        }
        idMap.put(taskDataState.getId(), taskDataState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void persistToStorage() {
        Map<String, Map<String, TaskDataState>> map = this.writeCache;
        synchronized (map) {
            for (Map<String, TaskDataState> idMap : this.writeCache.values()) {
                for (TaskDataState state : idMap.values()) {
                    this.storage.put(state);
                }
                idMap.clear();
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public void flushReadCache(boolean reset) {
        block1: {
            if (!reset) ** GOTO lbl9
            this.lruQueue.clear();
            this.readCache.clear();
            break block1;
lbl-1000:
            // 1 sources

            {
                state = this.lruQueue.poll();
                if (state == null || (tasksMap = this.readCache.get(state.getUrl())) == null) continue;
                tasksMap.remove(state.getId());
lbl9:
                // 3 sources

                ** while (this.lruQueue.size() > 40)
            }
        }
    }

    public Queue<TaskDataState> getReadQueue() {
        return this.lruQueue;
    }

    public Map<String, Map<String, TaskDataState>> getReadCache() {
        return this.readCache;
    }

    public Map<String, Map<String, TaskDataState>> getWriteCache() {
        return this.writeCache;
    }

    private class CacheFlushJob
    extends Job {
        private volatile boolean saveRequested;
        private volatile boolean saveCompleted;

        CacheFlushJob() {
            super("Flush Cache Job");
            this.saveRequested = false;
            this.saveCompleted = true;
            this.setPriority(30);
            this.setSystem(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            while (true) {
                if (this.saveRequested) {
                    this.saveRequested = false;
                    this.saveCompleted = false;
                    try {
                        OfflineCachingStorage.this.persistToStorage();
                    }
                    catch (Throwable t) {
                        StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Error saving offline cache", t));
                    }
                }
                if (this.saveRequested) continue;
                CacheFlushJob cacheFlushJob = this;
                synchronized (cacheFlushJob) {
                    this.saveCompleted = true;
                    ((Object)((Object)this)).notifyAll();
                    try {
                        ((Object)((Object)this)).wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }

        void requestSave() {
            this.saveRequested = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void runRequested() {
            CacheFlushJob cacheFlushJob = this;
            synchronized (cacheFlushJob) {
                ((Object)((Object)this)).notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void waitSaveCompleted() {
            while (!this.saveCompleted) {
                CacheFlushJob cacheFlushJob = this;
                synchronized (cacheFlushJob) {
                    try {
                        ((Object)((Object)this)).wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }

    private class RequestSaveTimerTask
    extends TimerTask {
        private RequestSaveTimerTask() {
        }

        public void run() {
            if (!Platform.isRunning()) {
                return;
            }
            OfflineCachingStorage.this.flushReadCache(false);
            OfflineCachingStorage.this.cacheFlushJob.runRequested();
        }
    }
}

