/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.mylyn.commons.core.AbstractErrorReporter;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public class DialogErrorReporter
extends AbstractErrorReporter {
    private static final String ERROR_MESSAGE = "Please report the following error at:\nhttp://bugs.eclipse.org/bugs/enter_bug.cgi?product=Mylyn\n\nOr via the popup menu in the Error Log view (see Window -> Show View)";
    private boolean errorDialogOpen;

    public int getPriority(IStatus status) {
        return AbstractErrorReporter.PRIORITY_LOW;
    }

    public void handle(final IStatus status) {
        Display display;
        IWorkbench workbench;
        if (Platform.isRunning() && (workbench = PlatformUI.getWorkbench()) != null && (display = workbench.getDisplay()) != null && !display.isDisposed()) {
            display.asyncExec(new Runnable(){

                public void run() {
                    try {
                        if (!DialogErrorReporter.this.errorDialogOpen) {
                            DialogErrorReporter.this.errorDialogOpen = true;
                            Shell shell = Display.getDefault().getActiveShell();
                            ErrorDialog.openError((Shell)shell, (String)"Mylyn Error", (String)DialogErrorReporter.ERROR_MESSAGE, (IStatus)status);
                        }
                    }
                    finally {
                        DialogErrorReporter.this.errorDialogOpen = false;
                    }
                }
            });
        }
    }
}

