/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui;

import java.text.MessageFormat;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.AbstractTaskCategory;
import org.eclipse.mylyn.internal.tasks.core.AbstractTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.DateRange;
import org.eclipse.mylyn.internal.tasks.core.TaskActivityUtil;
import org.eclipse.mylyn.internal.tasks.core.TaskCategory;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskListView;
import org.eclipse.mylyn.tasks.core.IRepositoryElement;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class AddExistingTaskJob
extends Job {
    private final TaskRepository repository;
    private final String taskId;
    private final AbstractTaskCategory taskContainer;

    public AddExistingTaskJob(TaskRepository repository, String taskId) {
        this(repository, taskId, null);
    }

    public AddExistingTaskJob(TaskRepository repository, String taskId, AbstractTaskCategory taskContainer) {
        super(MessageFormat.format("Adding task: \"{0}\"...", taskId));
        this.repository = repository;
        this.taskId = taskId;
        this.taskContainer = taskContainer;
    }

    public IStatus run(IProgressMonitor monitor) {
        block6: {
            try {
                try {
                    final AbstractTask newTask = (AbstractTask)TasksUiInternal.createTask(this.repository, this.taskId, monitor);
                    if (newTask != null) {
                        TasksUiPlugin.getTaskActivityManager().setScheduledFor(newTask, (DateRange)TaskActivityUtil.getCurrentWeek());
                        TasksUiInternal.refreshAndOpenTaskListElement((IRepositoryElement)newTask);
                        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                            public void run() {
                                Object selectedObject;
                                AbstractTaskCategory category = AddExistingTaskJob.this.taskContainer;
                                TaskListView taskListView = TaskListView.getFromActivePerspective();
                                if (category == null && (selectedObject = ((IStructuredSelection)taskListView.getViewer().getSelection()).getFirstElement()) instanceof TaskCategory) {
                                    category = (TaskCategory)selectedObject;
                                }
                                TasksUiInternal.getTaskList().addTask((ITask)newTask, (AbstractTaskContainer)category);
                                taskListView.getViewer().setSelection((ISelection)new StructuredSelection((Object)newTask));
                            }
                        });
                        break block6;
                    }
                    PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                            if (window != null) {
                                MessageDialog.openWarning((Shell)window.getShell(), (String)"Add Existing Task Failed", (String)MessageFormat.format("Unable to retrieve task \"{0}\" from repository.", AddExistingTaskJob.this.taskId));
                            }
                        }
                    });
                }
                catch (CoreException e) {
                    TasksUiInternal.displayStatus("Unable to open task", e.getStatus());
                    monitor.done();
                }
            }
            finally {
                monitor.done();
            }
        }
        return Status.OK_STATUS;
    }
}

