/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.resolution;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.equinox.internal.p2.director.DirectorActivator;
import org.eclipse.equinox.internal.p2.director.RecommendationDescriptor;
import org.eclipse.equinox.internal.p2.resolution.StateMetadataMap;
import org.eclipse.equinox.internal.p2.resolution.Transformer;
import org.eclipse.equinox.internal.p2.resolution.UnsatisfiedCapability;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnitFragment;
import org.eclipse.equinox.internal.provisional.p2.metadata.MetadataFactory;
import org.eclipse.equinox.internal.provisional.p2.metadata.ProvidedCapability;
import org.eclipse.equinox.internal.provisional.p2.metadata.RequiredCapability;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.PlatformAdmin;
import org.eclipse.osgi.service.resolver.ResolverError;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.VersionConstraint;
import org.osgi.framework.ServiceReference;

public class ResolutionHelper {
    private static final IInstallableUnitFragment[] NO_FRAGMENTS = new IInstallableUnitFragment[0];
    private static boolean DEBUG = false;
    private Transformer transformer;
    private State state;
    private Dictionary selectionContext;
    private RecommendationDescriptor recommendations;
    private Map fragmentBindings;
    static /* synthetic */ Class class$0;

    public ResolutionHelper(Dictionary selectionContext, RecommendationDescriptor recommendations) {
        this.selectionContext = selectionContext;
        this.recommendations = recommendations;
    }

    private void initialize() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.osgi.service.resolver.PlatformAdmin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ServiceReference sr = DirectorActivator.context.getServiceReference(clazz.getName());
        PlatformAdmin pa = (PlatformAdmin)DirectorActivator.context.getService(sr);
        this.transformer = new Transformer(pa.getFactory(), this.selectionContext, this.recommendations);
        this.state = pa.getFactory().createState(true);
        this.fragmentBindings = new HashMap();
        if (this.selectionContext != null) {
            this.state.setPlatformProperties(this.selectionContext);
        }
    }

    private void addToState(BundleDescription bd) {
        this.state.addBundle(bd);
    }

    private BundleDescription addInResolution(IInstallableUnit toAdd) {
        this.transformer.visitInstallableUnit(toAdd);
        BundleDescription descriptionToAdd = this.transformer.getResult();
        this.addToState(descriptionToAdd);
        return descriptionToAdd;
    }

    public UnsatisfiedCapability[] install(Set toInstall, Set existingState) {
        this.initialize();
        BundleDescription[] addedBundle = new BundleDescription[toInstall.size()];
        int j = 0;
        Iterator iterator = toInstall.iterator();
        while (iterator.hasNext()) {
            addedBundle[j++] = this.addInResolution((IInstallableUnit)iterator.next());
        }
        iterator = existingState.iterator();
        while (iterator.hasNext()) {
            this.addInResolution((IInstallableUnit)iterator.next());
        }
        this.state.resolve();
        ArrayList results = new ArrayList();
        int i = 0;
        while (i < addedBundle.length) {
            results.addAll(this.createUnsatisfiedCapabilities(this.state.getStateHelper().getUnsatisfiedConstraints(addedBundle[i]), addedBundle[i]));
            ++i;
        }
        return results.toArray(new UnsatisfiedCapability[results.size()]);
    }

    private ArrayList createUnsatisfiedCapabilities(VersionConstraint[] unsatisfied, BundleDescription description) {
        ArrayList<UnsatisfiedCapability> results = new ArrayList<UnsatisfiedCapability>();
        int i = 0;
        while (i < unsatisfied.length) {
            RequiredCapability originalDependency = (RequiredCapability)((StateMetadataMap)description.getUserObject()).getGenericSpecifications().get(unsatisfied[i]);
            results.add(new UnsatisfiedCapability(originalDependency, ((StateMetadataMap)description.getUserObject()).getUnit()));
            ++i;
        }
        return results;
    }

    public Collection attachCUs(Collection toAttach) {
        this.initialize();
        Iterator iterator = toAttach.iterator();
        while (iterator.hasNext()) {
            IInstallableUnit iu = (IInstallableUnit)iterator.next();
            if (iu == null) continue;
            this.addInResolution(iu);
        }
        this.state.resolve();
        BundleDescription[] bds = this.state.getBundles();
        int i = 0;
        while (i < bds.length) {
            if (DEBUG) {
                ResolverError[] re = this.state.getResolverErrors(bds[i]);
                int j = 0;
                while (j < re.length) {
                    System.out.println(re[j]);
                    ++j;
                }
            }
            BundleDescription[] potentialIUFragments = this.state.getStateHelper().getDependentBundles(new BundleDescription[]{bds[i]});
            IInstallableUnit hostIU = ((StateMetadataMap)bds[i].getUserObject()).getUnit();
            ArrayList<IInstallableUnitFragment> applicableFragments = new ArrayList<IInstallableUnitFragment>();
            int k = 0;
            while (k < potentialIUFragments.length) {
                IInstallableUnit dependentIU = ((StateMetadataMap)potentialIUFragments[k].getUserObject()).getUnit();
                if (!hostIU.equals(dependentIU) && dependentIU.isFragment()) {
                    IInstallableUnitFragment potentialFragment = (IInstallableUnitFragment)dependentIU;
                    RequiredCapability[] reqsFromFragment = potentialFragment.getHost();
                    ProvidedCapability[] hostCapabilities = hostIU.getProvidedCapabilities();
                    boolean match = true;
                    boolean requirementMatched = false;
                    int l = 0;
                    while (l < reqsFromFragment.length && match) {
                        requirementMatched = false;
                        int m = 0;
                        while (m < hostCapabilities.length) {
                            if (hostCapabilities[m].isSatisfiedBy(reqsFromFragment[l])) {
                                requirementMatched = true;
                                break;
                            }
                            ++m;
                        }
                        if (!requirementMatched) {
                            match = false;
                            break;
                        }
                        ++l;
                    }
                    if (match) {
                        applicableFragments.add(potentialFragment);
                    }
                }
                ++k;
            }
            IInstallableUnitFragment theFragment = null;
            int specificityLevel = 0;
            Iterator iterator2 = applicableFragments.iterator();
            while (iterator2.hasNext()) {
                IInstallableUnitFragment fragment = (IInstallableUnitFragment)iterator2.next();
                if (fragment.getHost().length <= specificityLevel) continue;
                theFragment = fragment;
                specificityLevel = fragment.getHost().length;
            }
            if (theFragment != null) {
                this.fragmentBindings.put(hostIU, theFragment);
            }
            ++i;
        }
        HashSet<IInstallableUnit> result = new HashSet<IInstallableUnit>(toAttach.size());
        Iterator iterator3 = toAttach.iterator();
        while (iterator3.hasNext()) {
            IInstallableUnit iu = (IInstallableUnit)iterator3.next();
            if (iu == null) continue;
            if (iu.isFragment()) {
                result.add(iu);
                continue;
            }
            IInstallableUnitFragment fragment = (IInstallableUnitFragment)this.fragmentBindings.get(iu);
            IInstallableUnitFragment[] fragments = fragment == null ? NO_FRAGMENTS : new IInstallableUnitFragment[]{fragment};
            result.add(MetadataFactory.createResolvedInstallableUnit((IInstallableUnit)iu, (IInstallableUnitFragment[])fragments));
        }
        return result;
    }

    public boolean isResolved(IInstallableUnit iu) {
        return this.state.getBundle(iu.getId(), iu.getVersion()).isResolved();
    }

    public ArrayList getAllResolved() {
        BundleDescription[] bd = this.state.getResolvedBundles();
        ArrayList<IInstallableUnit> result = new ArrayList<IInstallableUnit>(bd.length);
        int i = 0;
        while (i < bd.length) {
            result.add(this.extractIU(bd[i]));
            ++i;
        }
        return result;
    }

    private IInstallableUnit extractIU(BundleDescription bd) {
        return ((StateMetadataMap)bd.getUserObject()).getUnit();
    }

    public List getSorted() {
        BundleDescription[] toSort = this.state.getResolvedBundles();
        this.state.getStateHelper().sortBundles(toSort);
        ArrayList<IInstallableUnit> result = new ArrayList<IInstallableUnit>(toSort.length);
        int i = 0;
        while (i < toSort.length) {
            result.add(this.extractIU(toSort[i]));
            ++i;
        }
        return result;
    }
}

