/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.director;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.equinox.internal.p2.core.helpers.ServiceHelper;
import org.eclipse.equinox.internal.p2.director.DirectorActivator;
import org.eclipse.equinox.internal.p2.director.Messages;
import org.eclipse.equinox.internal.p2.rollback.FormerState;
import org.eclipse.equinox.internal.provisional.p2.core.location.AgentLocation;
import org.eclipse.equinox.internal.provisional.p2.director.IDirector;
import org.eclipse.equinox.internal.provisional.p2.director.IPlanner;
import org.eclipse.equinox.internal.provisional.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.internal.provisional.p2.director.ProvisioningPlan;
import org.eclipse.equinox.internal.provisional.p2.engine.DefaultPhaseSet;
import org.eclipse.equinox.internal.provisional.p2.engine.IEngine;
import org.eclipse.equinox.internal.provisional.p2.engine.IProfile;
import org.eclipse.equinox.internal.provisional.p2.engine.PhaseSet;
import org.eclipse.equinox.internal.provisional.p2.engine.ProvisioningContext;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleContext;

public class SimpleDirector
implements IDirector {
    private static final String ROLLBACK_LOCATION = "rollback";
    static final int PlanWork = 10;
    static final int EngineWork = 100;
    private IEngine engine;
    private IPlanner planner;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public SimpleDirector() {
        this.initializeRollbackRepository();
        this.engine = (IEngine)ServiceHelper.getService((BundleContext)DirectorActivator.context, (String)IEngine.SERVICE_NAME);
        if (this.engine == null) {
            throw new IllegalStateException("Provisioning engine is not registered");
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.internal.provisional.p2.director.IPlanner");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.planner = (IPlanner)ServiceHelper.getService((BundleContext)DirectorActivator.context, (String)clazz.getName());
        if (this.planner == null) {
            throw new IllegalStateException("Unable to find provisioning planner");
        }
    }

    private void initializeRollbackRepository() {
        new FormerState(this.getRollbackRepositoryLocation());
    }

    public URL getRollbackRepositoryLocation() {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.equinox.internal.provisional.p2.core.location.AgentLocation");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        AgentLocation agentLocation = (AgentLocation)ServiceHelper.getService((BundleContext)DirectorActivator.context, (String)clazz.getName());
        try {
            return new URL(agentLocation.getDataArea("org.eclipse.equinox.p2.director"), ROLLBACK_LOCATION);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public IStatus revert(IInstallableUnit target, IProfile profile, ProvisioningContext context, IProgressMonitor monitor) {
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.Director_Task_Updating, (int)110);
        try {
            ProvisioningPlan plan = this.planner.getRevertPlan(target, context, (IProgressMonitor)sub.newChild(10));
            if (!plan.getStatus().isOK()) {
                IStatus iStatus = plan.getStatus();
                return iStatus;
            }
            IStatus iStatus = this.engine.perform(profile, (PhaseSet)new DefaultPhaseSet(), plan.getOperands(), context, (IProgressMonitor)sub.newChild(100));
            return iStatus;
        }
        finally {
            sub.done();
        }
    }

    public IStatus provision(ProfileChangeRequest request, ProvisioningContext context, IProgressMonitor monitor) {
        String taskName = NLS.bind((String)Messages.Director_Task_Installing, (Object)request.getProfile().getProperty("org.eclipse.equinox.p2.installFolder"));
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (String)taskName, (int)110);
        try {
            IStatus engineResult;
            IInstallableUnit[] installRoots = request.getAddedInstallableUnits();
            int i = 0;
            while (i < installRoots.length) {
                request.setInstallableUnitProfileProperty(installRoots[i], "org.eclipse.equinox.p2.type.root", Boolean.toString(true));
                ++i;
            }
            ProvisioningPlan plan = this.planner.getProvisioningPlan(request, context, (IProgressMonitor)sub.newChild(10));
            if (!plan.getStatus().isOK()) {
                IStatus iStatus = plan.getStatus();
                return iStatus;
            }
            IStatus iStatus = engineResult = this.engine.perform(request.getProfile(), (PhaseSet)new DefaultPhaseSet(), plan.getOperands(), context, (IProgressMonitor)sub.newChild(100));
            return iStatus;
        }
        finally {
            sub.done();
        }
    }
}

