/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.core;

import java.util.Date;
import org.eclipse.mylyn.tasks.core.IAttributeContainer;
import org.eclipse.mylyn.tasks.core.IRepositoryElement;

public interface ITask
extends IRepositoryElement,
IAttributeContainer {
    public Date getCompletionDate();

    public String getConnectorKind();

    public Date getCreationDate();

    public Date getDueDate();

    public String getHandleIdentifier();

    public Date getModificationDate();

    public String getOwner();

    public String getPriority();

    public String getRepositoryUrl();

    public String getSummary();

    public SynchronizationState getSynchronizationState();

    public String getTaskId();

    public String getTaskKey();

    public String getTaskKind();

    public boolean isActive();

    public boolean isCompleted();

    public void setCompletionDate(Date var1);

    public void setCreationDate(Date var1);

    public void setDueDate(Date var1);

    public void setModificationDate(Date var1);

    public void setOwner(String var1);

    public void setPriority(String var1);

    public void setSummary(String var1);

    public void setTaskKind(String var1);

    public void setUrl(String var1);

    public void setTaskKey(String var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PriorityLevel {
        P1,
        P2,
        P3,
        P4,
        P5;


        public String toString() {
            switch (this) {
                case P1: {
                    return "P1";
                }
                case P2: {
                    return "P2";
                }
                case P3: {
                    return "P3";
                }
                case P4: {
                    return "P4";
                }
                case P5: {
                    return "P5";
                }
            }
            return "P3";
        }

        public String getDescription() {
            switch (this) {
                case P1: {
                    return "Very High";
                }
                case P2: {
                    return "High";
                }
                case P3: {
                    return "Normal";
                }
                case P4: {
                    return "Low";
                }
                case P5: {
                    return "Very Low";
                }
            }
            return "";
        }

        public static PriorityLevel fromLevel(int level) {
            if (level <= 1) {
                return P1;
            }
            if (level == 2) {
                return P2;
            }
            if (level == 3) {
                return P3;
            }
            if (level == 4) {
                return P4;
            }
            if (level >= 5) {
                return P5;
            }
            return PriorityLevel.getDefault();
        }

        public static PriorityLevel fromString(String string) {
            if (string.equals("P1")) {
                return P1;
            }
            if (string.equals("P2")) {
                return P2;
            }
            if (string.equals("P3")) {
                return P3;
            }
            if (string.equals("P4")) {
                return P4;
            }
            if (string.equals("P5")) {
                return P5;
            }
            return PriorityLevel.getDefault();
        }

        public static PriorityLevel fromDescription(String string) {
            if (string == null) {
                return null;
            }
            if (string.equals("Very High")) {
                return P1;
            }
            if (string.equals("High")) {
                return P2;
            }
            if (string.equals("Normal")) {
                return P3;
            }
            if (string.equals("Low")) {
                return P4;
            }
            if (string.equals("Very Low")) {
                return P5;
            }
            return PriorityLevel.getDefault();
        }

        public static PriorityLevel getDefault() {
            return P3;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SynchronizationState {
        CONFLICT,
        INCOMING,
        INCOMING_NEW,
        OUTGOING,
        OUTGOING_NEW,
        SYNCHRONIZED;


        public boolean isIncoming() {
            switch (this) {
                case CONFLICT: 
                case INCOMING: 
                case INCOMING_NEW: {
                    return true;
                }
            }
            return false;
        }

        public boolean isOutgoing() {
            switch (this) {
                case CONFLICT: 
                case OUTGOING: 
                case OUTGOING_NEW: {
                    return true;
                }
            }
            return false;
        }

        public boolean isSynchronized() {
            switch (this) {
                case SYNCHRONIZED: {
                    return true;
                }
            }
            return false;
        }
    }
}

