/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.core.sync;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.commons.net.Policy;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.AbstractTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.ITaskList;
import org.eclipse.mylyn.internal.tasks.core.data.TaskDataManager;
import org.eclipse.mylyn.internal.tasks.core.deprecated.AbstractLegacyRepositoryConnector;
import org.eclipse.mylyn.internal.tasks.core.deprecated.AbstractTaskDataHandler;
import org.eclipse.mylyn.internal.tasks.core.deprecated.LegacyTaskDataCollector;
import org.eclipse.mylyn.internal.tasks.core.deprecated.RepositoryTaskData;
import org.eclipse.mylyn.internal.tasks.core.deprecated.TaskFactory;
import org.eclipse.mylyn.internal.tasks.core.sync.SynchronizationSession;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.IRepositoryManager;
import org.eclipse.mylyn.tasks.core.IRepositoryModel;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.ITaskContainer;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.core.data.TaskRelation;
import org.eclipse.mylyn.tasks.core.sync.SynchronizationJob;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SynchronizeTasksJob
extends SynchronizationJob {
    private final AbstractRepositoryConnector connector;
    private final TaskDataManager taskDataManager;
    private final ITaskList taskList;
    private final Set<ITask> allTasks;
    private final IRepositoryManager repositoryManager;
    private TaskRepository taskRepository;
    private Map<String, TaskRelation[]> relationsByTaskId;
    private boolean updateRelations;
    private final IRepositoryModel tasksModel;
    private SynchronizationSession session;
    private final List<IStatus> statuses;

    public SynchronizeTasksJob(ITaskList taskList, TaskDataManager synchronizationManager, IRepositoryModel tasksModel, AbstractRepositoryConnector connector, TaskRepository taskRepository, Set<ITask> tasks) {
        super("Synchronizing Tasks (" + tasks.size() + " tasks)");
        this.taskList = taskList;
        this.taskDataManager = synchronizationManager;
        this.tasksModel = tasksModel;
        this.connector = connector;
        this.taskRepository = taskRepository;
        this.allTasks = tasks;
        this.repositoryManager = null;
        this.statuses = new ArrayList<IStatus>();
    }

    public SynchronizeTasksJob(ITaskList taskList, TaskDataManager synchronizationManager, IRepositoryModel tasksModel, AbstractRepositoryConnector connector, IRepositoryManager repositoryManager, Set<ITask> tasks) {
        super("Synchronizing Tasks (" + tasks.size() + " tasks)");
        this.taskList = taskList;
        this.taskDataManager = synchronizationManager;
        this.tasksModel = tasksModel;
        this.connector = connector;
        this.repositoryManager = repositoryManager;
        this.allTasks = tasks;
        this.statuses = new ArrayList<IStatus>();
    }

    /*
     * Unable to fully structure code
     */
    public IStatus run(IProgressMonitor monitor) {
        block10: {
            try {
                if (this.taskRepository == null) {
                    try {
                        monitor.beginTask("Processing", this.allTasks.size() * 100);
                        tasksByRepository = new HashMap<TaskRepository, HashSet<ITask>>();
                        for (ITask task : this.allTasks) {
                            repository = this.repositoryManager.getRepository(task.getConnectorKind(), task.getRepositoryUrl());
                            tasks = (HashSet<ITask>)tasksByRepository.get((Object)repository);
                            if (tasks == null) {
                                tasks = new HashSet<ITask>();
                                tasksByRepository.put(repository, tasks);
                            }
                            tasks.add(task);
                        }
                        for (TaskRepository taskRepository : tasksByRepository.keySet()) {
                            this.setName("Synchronizing Tasks (" + taskRepository.getRepositoryLabel() + ")");
                            this.taskRepository = taskRepository;
                            repositoryTasks = (Set)tasksByRepository.get((Object)taskRepository);
                            this.run(repositoryTasks, (IProgressMonitor)new SubProgressMonitor(monitor, repositoryTasks.size() * 100));
                        }
                        break block10;
                    }
                    finally {
                        monitor.done();
                    }
                }
                this.run(this.allTasks, monitor);
                break block10;
            }
            catch (OperationCanceledException v0) {
                ** for (task : this.allTasks)
            }
lbl-1000:
            // 1 sources

            {
                ((AbstractTask)task).setSynchronizing(false);
                this.taskList.notifyElementChanged(task);
                continue;
            }
lbl33:
            // 1 sources

            return Status.CANCEL_STATUS;
        }
        return Status.OK_STATUS;
    }

    private void run(Set<ITask> tasks, IProgressMonitor monitor) {
        this.relationsByTaskId = new HashMap<String, TaskRelation[]>();
        this.updateRelations = true;
        this.runInternal(tasks, monitor);
        this.synchronizedTaskRelations(monitor, this.relationsByTaskId);
    }

    public void synchronizedTaskRelations(IProgressMonitor monitor, Map<String, TaskRelation[]> relationsByTaskId) {
        this.updateRelations = false;
        for (String taskId : relationsByTaskId.keySet()) {
            TaskRelation[] relations;
            ITask parentTask = this.taskList.getTask(this.taskRepository.getRepositoryUrl(), taskId);
            if (!(parentTask instanceof ITaskContainer)) continue;
            HashSet<ITask> removedChildTasks = new HashSet<ITask>(((ITaskContainer)((Object)parentTask)).getChildren());
            TaskRelation[] taskRelationArray = relations = relationsByTaskId.get(taskId);
            int n = relations.length;
            int n2 = 0;
            while (n2 < n) {
                TaskRelation relation = taskRelationArray[n2];
                if (relation.getDirection() == TaskRelation.Direction.OUTWARD && relation.getKind() == TaskRelation.Kind.CONTAINMENT) {
                    ITask task = this.taskList.getTask(this.taskRepository.getRepositoryUrl(), relation.getTaskId());
                    if (task == null) {
                        try {
                            task = this.synchronizeTask(monitor, relation.getTaskId());
                        }
                        catch (CoreException e) {
                            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.core", "Synchronization failed", (Throwable)e));
                        }
                    } else {
                        removedChildTasks.remove(task);
                    }
                    if (task != null) {
                        this.taskList.addTask(task, (AbstractTaskContainer)((Object)parentTask));
                    }
                }
                ++n2;
            }
            for (ITask task : removedChildTasks) {
                this.taskList.removeFromContainer((AbstractTaskContainer)((Object)parentTask), task);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void runInternal(Set<ITask> tasks, IProgressMonitor monitor) {
        block14: {
            try {
                try {
                    monitor.beginTask("Processing", tasks.size() * 100);
                    if (this.canGetMultiTaskData(this.taskRepository)) {
                        try {
                            for (ITask task : tasks) {
                                this.resetStatus(task);
                            }
                            this.synchronizeTasks((IProgressMonitor)new SubProgressMonitor(monitor, tasks.size() * 100), this.taskRepository, tasks);
                            break block14;
                        }
                        catch (CoreException e) {
                            ** for (task : tasks)
                        }
lbl-1000:
                        // 1 sources

                        {
                            this.updateStatus(this.taskRepository, task, e.getStatus());
                            continue;
lbl15:
                            // 1 sources

                            break block14;
                        }
                    }
                    for (ITask task : tasks) {
                        Policy.checkCanceled((IProgressMonitor)monitor);
                        this.resetStatus(task);
                        try {
                            this.synchronizeTask((IProgressMonitor)new SubProgressMonitor(monitor, 100), task);
                        }
                        catch (CoreException e) {
                            this.updateStatus(this.taskRepository, task, e.getStatus());
                        }
                    }
                }
                catch (OperationCanceledException e) {
                    throw e;
                }
                catch (Exception e) {
                    StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.core", "Synchronization failed", (Throwable)e));
                    monitor.done();
                }
            }
            finally {
                monitor.done();
            }
        }
    }

    private boolean canGetMultiTaskData(TaskRepository taskRepository) {
        if (this.connector instanceof AbstractLegacyRepositoryConnector) {
            AbstractTaskDataHandler taskDataHandler = ((AbstractLegacyRepositoryConnector)this.connector).getLegacyTaskDataHandler();
            return taskDataHandler != null && taskDataHandler.canGetMultiTaskData();
        }
        org.eclipse.mylyn.tasks.core.data.AbstractTaskDataHandler taskDataHandler = this.connector.getTaskDataHandler();
        return taskDataHandler != null && taskDataHandler.canGetMultiTaskData(taskRepository);
    }

    private void synchronizeTask(IProgressMonitor monitor, ITask task) throws CoreException {
        monitor.subTask("Receiving task " + task.getSummary());
        this.resetStatus(task);
        if (!this.isUser()) {
            monitor = Policy.backgroundMonitorFor((IProgressMonitor)monitor);
        }
        String taskId = task.getTaskId();
        if (this.connector instanceof AbstractLegacyRepositoryConnector) {
            RepositoryTaskData downloadedTaskData = ((AbstractLegacyRepositoryConnector)this.connector).getLegacyTaskData(this.taskRepository, taskId, monitor);
            if (downloadedTaskData != null) {
                try {
                    this.updateFromTaskData(this.taskRepository, task, downloadedTaskData);
                }
                catch (CoreException e) {
                    this.updateStatus(this.taskRepository, task, e.getStatus());
                }
                return;
            }
        } else {
            TaskData taskData = this.connector.getTaskData(this.taskRepository, taskId, monitor);
            if (taskData != null) {
                this.updateFromTaskData(this.taskRepository, task, taskData);
                return;
            }
        }
        throw new CoreException((IStatus)new Status(4, "org.eclipse.mylyn.tasks.core", "Connector failed to return task data for task \"" + task + "\""));
    }

    private ITask synchronizeTask(IProgressMonitor monitor, String taskId) throws CoreException {
        monitor.subTask("Receiving task " + taskId);
        if (!this.isUser()) {
            monitor = Policy.backgroundMonitorFor((IProgressMonitor)monitor);
        }
        if (this.connector instanceof AbstractLegacyRepositoryConnector) {
            RepositoryTaskData downloadedTaskData = ((AbstractLegacyRepositoryConnector)this.connector).getLegacyTaskData(this.taskRepository, taskId, monitor);
            if (downloadedTaskData != null) {
                return this.updateFromTaskData(this.taskRepository, null, downloadedTaskData);
            }
        } else {
            TaskData taskData = this.connector.getTaskData(this.taskRepository, taskId, monitor);
            if (taskData != null) {
                return this.createFromTaskData(this.taskRepository, taskId, taskData);
            }
        }
        throw new CoreException((IStatus)new Status(4, "org.eclipse.mylyn.tasks.core", "Connector failed to return task data for task \"" + taskId + "\""));
    }

    private void resetStatus(ITask task) {
        ((AbstractTask)task).setStatus(null);
        this.taskList.notifySynchronizationStateChanged(task);
    }

    private void synchronizeTasks(IProgressMonitor monitor, final TaskRepository repository, Set<ITask> tasks) throws CoreException {
        monitor.subTask("Receiving " + tasks.size() + " tasks from " + repository.getRepositoryLabel());
        final HashMap<String, ITask> idToTask = new HashMap<String, ITask>();
        for (ITask task : tasks) {
            idToTask.put(task.getTaskId(), task);
        }
        LegacyTaskDataCollector collector = new LegacyTaskDataCollector(){

            public void accept(RepositoryTaskData taskData) {
                ITask task = (ITask)idToTask.remove(taskData.getTaskId());
                if (task != null) {
                    try {
                        SynchronizeTasksJob.this.updateFromTaskData(repository, task, taskData);
                    }
                    catch (CoreException e) {
                        StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.core", "Synchronization failed", (Throwable)e));
                    }
                }
            }

            public void accept(TaskData taskData) {
                ITask task = (ITask)idToTask.remove(taskData.getTaskId());
                if (task != null) {
                    SynchronizeTasksJob.this.updateFromTaskData(repository, task, taskData);
                }
            }
        };
        if (!this.isUser()) {
            monitor = Policy.backgroundMonitorFor((IProgressMonitor)monitor);
        }
        Set<String> taskIds = Collections.unmodifiableSet(new HashSet(idToTask.keySet()));
        if (this.connector instanceof AbstractLegacyRepositoryConnector) {
            ((AbstractLegacyRepositoryConnector)this.connector).getLegacyTaskDataHandler().getMultiTaskData(repository, taskIds, collector, monitor);
        } else {
            this.connector.getTaskDataHandler().getMultiTaskData(repository, taskIds, collector, monitor);
        }
    }

    private ITask updateFromTaskData(TaskRepository repository, ITask task, RepositoryTaskData taskData) throws CoreException {
        TaskFactory factory = new TaskFactory(repository, true, this.isUser(), (AbstractLegacyRepositoryConnector)this.connector, this.taskDataManager, this.taskList);
        task = factory.createTask(taskData, (IProgressMonitor)new NullProgressMonitor());
        ((AbstractTask)task).setSynchronizing(false);
        this.taskList.notifySynchronizationStateChanged(task);
        return task;
    }

    private void updateFromTaskData(TaskRepository taskRepository, ITask task, TaskData taskData) {
        try {
            Collection<TaskRelation> relations;
            this.taskDataManager.putUpdatedTaskData(task, taskData, this.isUser(), this.getSession());
            if (this.updateRelations && (relations = this.connector.getTaskRelations(taskData)) != null) {
                this.relationsByTaskId.put(task.getTaskId(), relations.toArray(new TaskRelation[0]));
            }
        }
        catch (CoreException e) {
            this.updateStatus(taskRepository, task, e.getStatus());
        }
    }

    private ITask createFromTaskData(TaskRepository taskRepository, String taskId, TaskData taskData) throws CoreException {
        ITask task = this.tasksModel.createTask(taskRepository, taskData.getTaskId());
        this.taskDataManager.putUpdatedTaskData(task, taskData, this.isUser(), this.getSession());
        return task;
    }

    private void updateStatus(TaskRepository repository, ITask task, IStatus status) {
        this.statuses.add(status);
        ((AbstractTask)task).setStatus(status);
        if (!this.isUser()) {
            ((AbstractTask)task).setSynchronizing(false);
        }
        this.taskList.notifyElementChanged(task);
    }

    public SynchronizationSession getSession() {
        return this.session;
    }

    public void setSession(SynchronizationSession session) {
        this.session = session;
    }

    public Collection<IStatus> getStatuses() {
        return Collections.unmodifiableCollection(this.statuses);
    }
}

