/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.core.deprecated;

import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.ITaskList;
import org.eclipse.mylyn.internal.tasks.core.TaskDataStorageManager;
import org.eclipse.mylyn.internal.tasks.core.data.TaskDataManager;
import org.eclipse.mylyn.internal.tasks.core.deprecated.AbstractLegacyRepositoryConnector;
import org.eclipse.mylyn.internal.tasks.core.deprecated.AbstractTaskDataHandler;
import org.eclipse.mylyn.internal.tasks.core.deprecated.ITaskFactory;
import org.eclipse.mylyn.internal.tasks.core.deprecated.RepositoryTaskData;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;

@Deprecated
public class TaskFactory
implements ITaskFactory {
    private final AbstractLegacyRepositoryConnector connector;
    private final TaskDataManager taskDataManager;
    private final TaskRepository repository;
    private final ITaskList taskList;
    private final AbstractTaskDataHandler dataHandler;
    private final boolean updateTasklist;
    private final boolean forced;
    private final TaskDataStorageManager taskDataStorageManager;

    public TaskFactory(TaskRepository repository, boolean updateTasklist, boolean forced, AbstractLegacyRepositoryConnector connector, TaskDataManager taskDataManager, ITaskList taskList) {
        this.repository = repository;
        this.updateTasklist = updateTasklist;
        this.forced = forced;
        this.connector = connector;
        this.taskDataManager = taskDataManager;
        this.taskList = taskList;
        this.dataHandler = connector.getLegacyTaskDataHandler();
        this.taskDataStorageManager = taskDataManager.getTaskDataStorageManager();
    }

    public AbstractTask createTask(RepositoryTaskData taskData, IProgressMonitor monitor) throws CoreException {
        AbstractTask repositoryTask = (AbstractTask)this.taskList.getTask(taskData.getRepositoryUrl(), taskData.getTaskId());
        if (repositoryTask == null) {
            repositoryTask = this.createTaskFromTaskData(this.connector, this.repository, taskData, this.updateTasklist, monitor);
            repositoryTask.setSynchronizationState(ITask.SynchronizationState.INCOMING);
            if (!taskData.isPartial()) {
                if (this.updateTasklist) {
                    this.taskList.addTask(repositoryTask);
                    this.taskDataManager.saveIncoming(repositoryTask, taskData, this.forced);
                } else {
                    this.taskDataManager.saveOffline(repositoryTask, taskData);
                }
            }
        } else if (this.updateTasklist) {
            boolean changed;
            if (!taskData.isPartial()) {
                changed = this.taskDataManager.saveIncoming(repositoryTask, taskData, this.forced);
                this.connector.updateTaskFromTaskData(this.repository, (ITask)repositoryTask, taskData);
            } else {
                changed = this.connector.updateTaskFromTaskData(this.repository, (ITask)repositoryTask, taskData);
                if (changed) {
                    switch (repositoryTask.getSynchronizationState()) {
                        case OUTGOING: {
                            repositoryTask.setSynchronizationState(ITask.SynchronizationState.CONFLICT);
                        }
                        case SYNCHRONIZED: {
                            repositoryTask.setSynchronizationState(ITask.SynchronizationState.INCOMING);
                        }
                    }
                }
            }
            if (this.dataHandler != null) {
                for (ITask child : repositoryTask.getChildren()) {
                    this.taskList.removeFromContainer(repositoryTask, child);
                }
                Set<String> subTaskIds = this.dataHandler.getSubTaskIds(taskData);
                if (subTaskIds != null) {
                    for (String subId : subTaskIds) {
                        AbstractTask subTask;
                        if (subId == null || subId.trim().equals("") || (subTask = this.createTaskFromExistingId(this.connector, this.repository, subId, false, (IProgressMonitor)new SubProgressMonitor(monitor, 1))) == null) continue;
                        this.taskList.addTask(subTask, repositoryTask);
                    }
                }
            }
            if (changed) {
                this.taskList.notifyElementChanged(repositoryTask);
            }
        }
        return repositoryTask;
    }

    private AbstractTask createTaskFromTaskData(AbstractLegacyRepositoryConnector connector, TaskRepository repository, RepositoryTaskData taskData, boolean retrieveSubTasks, IProgressMonitor monitor) throws CoreException {
        AbstractTask repositoryTask = null;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            if (taskData != null) {
                repositoryTask = connector.createTask(repository.getRepositoryUrl(), taskData.getTaskId(), String.valueOf(taskData.getTaskId()) + ": " + taskData.getDescription());
                connector.updateTaskFromTaskData(repository, (ITask)repositoryTask, taskData);
                if (!taskData.isPartial()) {
                    this.taskDataStorageManager.setNewTaskData(taskData);
                }
                if (retrieveSubTasks) {
                    monitor.beginTask("Creating task", connector.getLegacyTaskDataHandler().getSubTaskIds(taskData).size());
                    for (String subId : connector.getLegacyTaskDataHandler().getSubTaskIds(taskData)) {
                        AbstractTask subTask;
                        if (subId == null || subId.trim().equals("") || (subTask = this.createTaskFromExistingId(connector, repository, subId, false, (IProgressMonitor)new SubProgressMonitor(monitor, 1))) == null) continue;
                        this.taskList.addTask(subTask, repositoryTask);
                    }
                }
            }
        }
        finally {
            monitor.done();
        }
        return repositoryTask;
    }

    private AbstractTask createTaskFromExistingId(AbstractLegacyRepositoryConnector connector, TaskRepository repository, String id, boolean retrieveSubTasks, IProgressMonitor monitor) throws CoreException {
        AbstractTask repositoryTask = (AbstractTask)this.taskList.getTask(repository.getRepositoryUrl(), id);
        if (repositoryTask == null && connector.getLegacyTaskDataHandler() != null) {
            RepositoryTaskData taskData = null;
            taskData = connector.getLegacyTaskDataHandler().getTaskData(repository, id, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            if (taskData != null && (repositoryTask = this.createTaskFromTaskData(connector, repository, taskData, retrieveSubTasks, (IProgressMonitor)new SubProgressMonitor(monitor, 1))) != null) {
                repositoryTask.setSynchronizationState(ITask.SynchronizationState.INCOMING);
                this.taskList.addTask(repositoryTask);
            }
        }
        return repositoryTask;
    }
}

