/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.core.data;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.tasks.core.data.AbstractTaskAttachmentSource;

public class FileTaskAttachmentSource
extends AbstractTaskAttachmentSource {
    public static final String APPLICATION_OCTET_STREAM = "application/octet-stream";
    private static Map<String, String> extensions2Types = new HashMap<String, String>();
    private String contentType;
    private String description;
    private final File file;
    private String name;

    static {
        extensions2Types.put("txt", "text/plain");
        extensions2Types.put("html", "text/html");
        extensions2Types.put("htm", "text/html");
        extensions2Types.put("jpg", "image/jpeg");
        extensions2Types.put("jpeg", "image/jpeg");
        extensions2Types.put("gif", "image/gif");
        extensions2Types.put("png", "image/png");
        extensions2Types.put("xml", "application/xml");
        extensions2Types.put("zip", APPLICATION_OCTET_STREAM);
        extensions2Types.put("tar", APPLICATION_OCTET_STREAM);
        extensions2Types.put("gz", APPLICATION_OCTET_STREAM);
    }

    public static String getContentTypeFromFilename(String fileName) {
        String ext;
        String type;
        int index = fileName.lastIndexOf(".");
        if (index > 0 && index < fileName.length() && (type = extensions2Types.get((ext = fileName.substring(index + 1)).toLowerCase(Locale.ENGLISH))) != null) {
            return type;
        }
        return APPLICATION_OCTET_STREAM;
    }

    public FileTaskAttachmentSource(File file) {
        this.file = file;
        this.name = file.getName();
        this.contentType = FileTaskAttachmentSource.getContentTypeFromFilename(this.name);
    }

    public InputStream createInputStream(IProgressMonitor monitor) throws CoreException {
        try {
            return new FileInputStream(this.file);
        }
        catch (FileNotFoundException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.mylyn.tasks.core", e.getMessage(), (Throwable)e));
        }
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getDescription() {
        return this.description;
    }

    public long getLength() {
        return this.file.length();
    }

    public String getName() {
        return this.name;
    }

    public boolean isLocal() {
        return true;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setName(String name) {
        this.name = name;
    }
}

