/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.core;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.eclipse.mylyn.internal.tasks.core.DateRange;
import org.eclipse.mylyn.internal.tasks.core.TaskActivityUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeekDateRange
extends DateRange {
    private final List<DateRange> days = new ArrayList<DateRange>();

    public WeekDateRange(Calendar startDate, Calendar endDate) {
        super(startDate, endDate);
    }

    public List<DateRange> getRemainingDays() {
        ArrayList<DateRange> remainingDays = new ArrayList<DateRange>();
        for (DateRange dayDateRange : this.getDaysOfWeek()) {
            if (dayDateRange.isPast()) continue;
            remainingDays.add(dayDateRange);
        }
        return remainingDays;
    }

    public List<DateRange> getDaysOfWeek() {
        if (this.days.isEmpty()) {
            int x = TaskActivityUtil.getStartDay();
            while (x < TaskActivityUtil.getStartDay() + 7) {
                Calendar dayStart = TaskActivityUtil.getCalendar();
                dayStart.setTime(this.getStartDate().getTime());
                TaskActivityUtil.snapStartOfDay(dayStart);
                Calendar dayEnd = TaskActivityUtil.getCalendar();
                dayEnd.setTime(this.getStartDate().getTime());
                TaskActivityUtil.snapEndOfDay(dayEnd);
                if (x > 7) {
                    dayStart.set(7, x % 7);
                    dayEnd.set(7, x % 7);
                } else {
                    dayStart.set(7, x);
                    dayEnd.set(7, x);
                }
                this.days.add(new DateRange(dayStart, dayEnd));
                ++x;
            }
        }
        return this.days;
    }

    public DateRange getToday() {
        DateRange today = null;
        Calendar now = TaskActivityUtil.getCalendar();
        for (DateRange range : this.getDaysOfWeek()) {
            if (!range.includes(now)) continue;
            today = range;
            break;
        }
        if (today == null) {
            Calendar todayStart = TaskActivityUtil.getCalendar();
            TaskActivityUtil.snapStartOfDay(todayStart);
            Calendar todayEnd = TaskActivityUtil.getCalendar();
            TaskActivityUtil.snapEndOfDay(todayEnd);
            today = new DateRange(todayStart, todayEnd);
        }
        return today;
    }

    public boolean isCurrentWeekDay(DateRange range) {
        if (range == null) {
            return false;
        }
        return this.getDaysOfWeek().contains(range);
    }

    public DateRange getDayOfWeek(int dayNum) {
        if (dayNum > 0 && dayNum <= 7) {
            for (DateRange day : this.getDaysOfWeek()) {
                if (day.getStartDate().get(7) != dayNum) continue;
                return day;
            }
        }
        return null;
    }
}

