/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.core;

import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.SocketAddress;
import org.eclipse.core.net.proxy.IProxyData;
import org.eclipse.core.net.proxy.IProxyService;
import org.eclipse.mylyn.commons.net.AbstractWebLocation;
import org.eclipse.mylyn.commons.net.AuthenticationCredentials;
import org.eclipse.mylyn.commons.net.AuthenticationType;
import org.eclipse.mylyn.internal.commons.net.AuthenticatedProxy;
import org.eclipse.mylyn.internal.commons.net.CommonsNetPlugin;
import org.eclipse.mylyn.tasks.core.TaskRepository;

public class TaskRepositoryLocation
extends AbstractWebLocation {
    protected final TaskRepository taskRepository;

    public TaskRepositoryLocation(TaskRepository taskRepository) {
        super(taskRepository.getRepositoryUrl());
        this.taskRepository = taskRepository;
    }

    public Proxy getProxyForHost(String host, String proxyType) {
        IProxyData data;
        if (!this.taskRepository.isDefaultProxyEnabled()) {
            String proxyHost = this.taskRepository.getProperty("org.eclipse.mylyn.tasklist.repositories.proxy.hostname");
            String proxyPort = this.taskRepository.getProperty("org.eclipse.mylyn.tasklist.repositories.proxy.port");
            String proxyUsername = "";
            String proxyPassword = "";
            AuthenticationCredentials credentials = this.taskRepository.getCredentials(AuthenticationType.PROXY);
            if (proxyHost != null && proxyHost.length() > 0 && credentials != null) {
                proxyUsername = credentials.getUserName();
                proxyPassword = credentials.getPassword();
            }
            return TaskRepositoryLocation.getProxy(proxyHost, proxyPort, proxyUsername, proxyPassword);
        }
        IProxyService service = CommonsNetPlugin.getProxyService();
        if (service != null && service.isProxiesEnabled() && (data = service.getProxyDataForHost(host, proxyType)) != null && data.getHost() != null) {
            String proxyHost = data.getHost();
            int proxyPort = data.getPort();
            if (proxyPort == -1) {
                proxyPort = 0;
            }
            InetSocketAddress sockAddr = new InetSocketAddress(proxyHost, proxyPort);
            if (data.isRequiresAuthentication()) {
                return new AuthenticatedProxy(this.getJavaProxyType(proxyType), (SocketAddress)sockAddr, data.getUserId(), data.getPassword());
            }
            return new Proxy(this.getJavaProxyType(proxyType), sockAddr);
        }
        return null;
    }

    private static Proxy getProxy(String proxyHost, String proxyPort, String proxyUsername, String proxyPassword) {
        boolean authenticated;
        boolean bl = authenticated = proxyUsername != null && proxyPassword != null && proxyUsername.length() > 0 && proxyPassword.length() > 0;
        if (proxyHost != null && proxyHost.length() > 0 && proxyPort != null && proxyPort.length() > 0) {
            int proxyPortNum = Integer.parseInt(proxyPort);
            InetSocketAddress sockAddr = new InetSocketAddress(proxyHost, proxyPortNum);
            if (authenticated) {
                return new AuthenticatedProxy(Proxy.Type.HTTP, (SocketAddress)sockAddr, proxyUsername, proxyPassword);
            }
            return new Proxy(Proxy.Type.HTTP, sockAddr);
        }
        return Proxy.NO_PROXY;
    }

    private Proxy.Type getJavaProxyType(String type) {
        return "SOCKS".equals(type) ? Proxy.Type.SOCKS : Proxy.Type.HTTP;
    }

    public AuthenticationCredentials getCredentials(AuthenticationType type) {
        return this.taskRepository.getCredentials(type);
    }
}

