/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.core;

import java.util.Calendar;
import java.util.Date;
import org.eclipse.mylyn.internal.tasks.core.DateRange;
import org.eclipse.mylyn.internal.tasks.core.WeekDateRange;

public class TaskActivityUtil {
    private static int startDay = 2;
    private static int endHour = 17;

    public static Calendar snapStartOfDay(Calendar cal) {
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        cal.getTime();
        return cal;
    }

    public static Calendar snapStartOfHour(Calendar cal) {
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        cal.getTime();
        return cal;
    }

    public static Calendar snapEndOfHour(Calendar cal) {
        cal.set(12, cal.getActualMaximum(12));
        cal.set(13, cal.getActualMaximum(13));
        cal.set(14, cal.getActualMaximum(14));
        cal.getTime();
        return cal;
    }

    public static Calendar snapEndOfDay(Calendar cal) {
        cal.set(11, cal.getActualMaximum(11));
        cal.set(12, cal.getActualMaximum(12));
        cal.set(13, cal.getActualMaximum(13));
        cal.set(14, cal.getActualMaximum(14));
        cal.getTime();
        return cal;
    }

    public static void snapToNextDay(Calendar cal) {
        cal.add(5, 1);
        TaskActivityUtil.snapStartOfDay(cal);
    }

    public static Calendar snapNextDay(Calendar cal) {
        cal.add(5, 1);
        TaskActivityUtil.snapStartOfDay(cal);
        return cal;
    }

    public static Calendar snapStartOfWorkWeek(Calendar cal) {
        cal.set(7, startDay);
        TaskActivityUtil.snapStartOfDay(cal);
        return cal;
    }

    public static Calendar snapEndOfWeek(Calendar cal) {
        if (cal.getFirstDayOfWeek() == 2) {
            cal.set(7, 1);
        } else {
            cal.set(7, 7);
        }
        TaskActivityUtil.snapEndOfDay(cal);
        return cal;
    }

    public static Calendar snapEndOfNextWeek(Calendar cal) {
        if (cal.getFirstDayOfWeek() == 2) {
            cal.set(7, 1);
        } else {
            cal.set(7, 7);
        }
        TaskActivityUtil.snapEndOfWeek(cal);
        cal.add(4, 1);
        return cal;
    }

    public static Calendar snapForwardNumDays(Calendar calendar, int days) {
        calendar.add(5, days);
        calendar.set(11, endHour);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar;
    }

    public static Calendar snapEndOfWorkDay(Calendar calendar) {
        calendar.set(11, endHour);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar;
    }

    public static Calendar snapNextWorkWeek(Calendar calendar) {
        calendar.add(4, 1);
        TaskActivityUtil.snapStartOfWorkWeek(calendar);
        return calendar;
    }

    public static boolean isAfterCurrentWeek(Calendar time) {
        if (time != null) {
            Calendar cal = TaskActivityUtil.getCalendar();
            return time.compareTo(TaskActivityUtil.snapNextWorkWeek(cal)) > -1;
        }
        return false;
    }

    public static boolean isFuture(Calendar time) {
        if (time != null) {
            Calendar cal = TaskActivityUtil.getCalendar();
            cal.add(4, 2);
            TaskActivityUtil.snapStartOfWorkWeek(cal);
            return time.compareTo(cal) > -1;
        }
        return false;
    }

    public static boolean isThisWeek(Calendar time) {
        if (time != null) {
            Calendar weekStart = TaskActivityUtil.getCalendar();
            TaskActivityUtil.snapStartOfWorkWeek(weekStart);
            Calendar weekEnd = TaskActivityUtil.getCalendar();
            TaskActivityUtil.snapEndOfWeek(weekEnd);
            return time.compareTo(weekStart) >= 0 && time.compareTo(weekEnd) <= 0;
        }
        return false;
    }

    public static boolean isNextWeek(Calendar time) {
        if (time != null) {
            Calendar weekStart = TaskActivityUtil.getCalendar();
            TaskActivityUtil.snapNextWorkWeek(weekStart);
            Calendar weekEnd = TaskActivityUtil.getCalendar();
            TaskActivityUtil.snapNextWorkWeek(weekEnd);
            TaskActivityUtil.snapEndOfWeek(weekEnd);
            return time.compareTo(weekStart) >= 0 && time.compareTo(weekEnd) <= 0;
        }
        return false;
    }

    public static boolean isToday(Calendar time) {
        if (time != null) {
            Calendar dayStart = TaskActivityUtil.getCalendar();
            TaskActivityUtil.snapStartOfDay(dayStart);
            Calendar midnight = TaskActivityUtil.getCalendar();
            TaskActivityUtil.snapEndOfDay(midnight);
            return time.compareTo(dayStart) >= 0 && time.compareTo(midnight) <= 0;
        }
        return false;
    }

    public static boolean isToday(DateRange time) {
        if (time != null) {
            return TaskActivityUtil.getCurrentWeek().getToday().compareTo(time) == 0;
        }
        return false;
    }

    public static Calendar getCalendar() {
        Calendar cal = Calendar.getInstance();
        cal.setFirstDayOfWeek(startDay);
        cal.getTime();
        return cal;
    }

    public static Calendar getStartOfCurrentWeek() {
        Calendar cal = TaskActivityUtil.getCalendar();
        return TaskActivityUtil.snapStartOfWorkWeek(cal);
    }

    public static Calendar getStartOfNextWeek() {
        Calendar cal = TaskActivityUtil.getCalendar();
        TaskActivityUtil.snapNextWorkWeek(cal);
        return TaskActivityUtil.snapStartOfWorkWeek(cal);
    }

    public static Calendar getEndOfCurrentWeek() {
        Calendar cal = TaskActivityUtil.getCalendar();
        return TaskActivityUtil.snapEndOfWeek(cal);
    }

    public static boolean isBetween(Calendar time, Calendar start, Calendar end) {
        return time.compareTo(start) >= 0 && time.compareTo(end) <= 0;
    }

    protected static void setStartDay(int startDay) {
        TaskActivityUtil.startDay = startDay;
    }

    protected static int getStartDay() {
        return startDay;
    }

    public static void setEndHour(int endHour) {
        TaskActivityUtil.endHour = endHour;
    }

    public static WeekDateRange getCurrentWeek() {
        Calendar weekStart = TaskActivityUtil.getCalendar();
        TaskActivityUtil.snapStartOfWorkWeek(weekStart);
        Calendar weekEnd = TaskActivityUtil.getCalendar();
        TaskActivityUtil.snapEndOfWeek(weekEnd);
        return new WeekDateRange(weekStart, weekEnd);
    }

    public static WeekDateRange getNextWeek() {
        Calendar weekStart = TaskActivityUtil.getCalendar();
        TaskActivityUtil.snapNextWorkWeek(weekStart);
        Calendar weekEnd = TaskActivityUtil.getCalendar();
        weekEnd.setTimeInMillis(weekStart.getTimeInMillis());
        TaskActivityUtil.snapEndOfWeek(weekEnd);
        return new WeekDateRange(weekStart, weekEnd);
    }

    public static DateRange getWeekOf(Date date) {
        Calendar weekStart = TaskActivityUtil.getCalendar();
        weekStart.setTime(date);
        Calendar weekEnd = TaskActivityUtil.getCalendar();
        weekEnd.setTime(date);
        TaskActivityUtil.snapStartOfWorkWeek(weekStart);
        TaskActivityUtil.snapEndOfWeek(weekEnd);
        return new WeekDateRange(weekStart, weekEnd);
    }

    public static DateRange getDayOf(Date date) {
        Calendar dayStart = TaskActivityUtil.getCalendar();
        dayStart.setTime(date);
        Calendar dayEnd = TaskActivityUtil.getCalendar();
        dayEnd.setTime(date);
        TaskActivityUtil.snapStartOfDay(dayStart);
        TaskActivityUtil.snapEndOfDay(dayEnd);
        return new DateRange(dayStart, dayEnd);
    }
}

