/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.core;

import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.mylyn.internal.tasks.core.RepositoryQuery;
import org.eclipse.mylyn.internal.tasks.core.RepositoryTaskHandleUtil;
import org.eclipse.mylyn.internal.tasks.core.TaskAttachment;
import org.eclipse.mylyn.internal.tasks.core.TaskComment;
import org.eclipse.mylyn.internal.tasks.core.TaskList;
import org.eclipse.mylyn.internal.tasks.core.TaskRepositoryAdapter;
import org.eclipse.mylyn.internal.tasks.core.TaskTask;
import org.eclipse.mylyn.internal.tasks.core.UnmatchedTaskContainer;
import org.eclipse.mylyn.tasks.core.IRepositoryManager;
import org.eclipse.mylyn.tasks.core.IRepositoryModel;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.ITaskAttachment;
import org.eclipse.mylyn.tasks.core.ITaskComment;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskData;

public class RepositoryModel
implements IRepositoryModel {
    private final IRepositoryManager repositoryManager;
    private final Map<String, ITask> taskByHandle = new WeakHashMap<String, ITask>();
    private final TaskList taskList;

    public RepositoryModel(TaskList taskList, IRepositoryManager repositoryManager) {
        this.taskList = taskList;
        this.repositoryManager = repositoryManager;
        this.initialize();
    }

    private void initialize() {
        this.repositoryManager.addListener(new TaskRepositoryAdapter(){

            public void repositoryAdded(TaskRepository repository) {
                RepositoryModel.this.taskList.addUnmatchedContainer(new UnmatchedTaskContainer(repository.getConnectorKind(), repository.getRepositoryUrl()));
            }

            public void repositoryRemoved(TaskRepository repository) {
            }
        });
    }

    public IRepositoryQuery createRepositoryQuery(TaskRepository taskRepository) {
        String handle = this.taskList.getUniqueHandleIdentifier();
        RepositoryQuery query = new RepositoryQuery(taskRepository.getConnectorKind(), handle);
        query.setRepositoryUrl(taskRepository.getRepositoryUrl());
        return query;
    }

    public synchronized ITask createTask(TaskRepository taskRepository, String taskId) {
        String handle = this.getTaskHandle(taskRepository, taskId);
        ITask task = this.taskByHandle.get(handle);
        if (task == null) {
            task = new TaskTask(taskRepository.getConnectorKind(), taskRepository.getRepositoryUrl(), taskId);
            this.taskByHandle.put(handle, task);
        }
        return task;
    }

    public ITaskAttachment createTaskAttachment(TaskAttribute taskAttribute) {
        TaskData taskData = taskAttribute.getTaskData();
        TaskRepository taskRepository = this.repositoryManager.getRepository(taskData.getConnectorKind(), taskData.getRepositoryUrl());
        ITask task = this.getTask(taskRepository, taskData.getTaskId());
        if (task == null) {
            return null;
        }
        TaskAttachment taskAttachment = new TaskAttachment(taskRepository, task, taskAttribute);
        taskData.getAttributeMapper().updateTaskAttachment(taskAttachment, taskAttribute);
        return taskAttachment;
    }

    public ITaskComment createTaskComment(TaskAttribute taskAttribute) {
        TaskData taskData = taskAttribute.getTaskData();
        TaskRepository taskRepository = this.repositoryManager.getRepository(taskData.getConnectorKind(), taskData.getRepositoryUrl());
        ITask task = this.getTask(taskRepository, taskData.getTaskId());
        if (task == null) {
            return null;
        }
        TaskComment taskComment = new TaskComment(taskRepository, task, taskAttribute);
        taskData.getAttributeMapper().updateTaskComment(taskComment, taskAttribute);
        return taskComment;
    }

    public synchronized ITask getTask(String handleIdentifier) {
        ITask task = this.taskByHandle.get(handleIdentifier);
        if (task == null) {
            task = this.taskList.getTask(handleIdentifier);
        }
        return task;
    }

    public synchronized ITask getTask(TaskRepository taskRepository, String taskId) {
        return this.getTask(this.getTaskHandle(taskRepository, taskId));
    }

    private String getTaskHandle(TaskRepository taskRepository, String taskId) {
        return RepositoryTaskHandleUtil.getHandle(taskRepository.getRepositoryUrl(), taskId);
    }

    public TaskRepository getTaskRepository(String connectorKind, String repositoryUrl) {
        TaskRepository taskRepository = this.repositoryManager.getRepository(connectorKind, repositoryUrl);
        if (taskRepository == null) {
            taskRepository = new TaskRepository(connectorKind, repositoryUrl);
            this.repositoryManager.addRepository(taskRepository);
        }
        return taskRepository;
    }

    public synchronized void clear() {
        this.taskByHandle.clear();
    }
}

