/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.core;

import java.text.DateFormat;
import java.util.Calendar;
import org.eclipse.core.runtime.Assert;
import org.eclipse.mylyn.internal.tasks.core.TaskActivityUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DateRange
implements Comparable<DateRange> {
    private static final long DAY = 86400000L;
    private static final String DESCRIPTION_PREVIOUS_WEEK = "Previous Week";
    private static final String DESCRIPTION_THIS_WEEK = "This Week";
    private static final String DESCRIPTION_NEXT_WEEK = "Next Week";
    private static final String DESCRIPTION_WEEK_AFTER_NEXT = "Two Weeks";
    private final Calendar startDate;
    private final Calendar endDate;

    public DateRange(Calendar time) {
        this.startDate = time;
        this.endDate = time;
    }

    public DateRange(Calendar startDate, Calendar endDate) {
        Assert.isNotNull((Object)startDate);
        Assert.isNotNull((Object)endDate);
        this.startDate = startDate;
        this.endDate = endDate;
    }

    public boolean includes(DateRange range) {
        return this.startDate.getTimeInMillis() <= range.getStartDate().getTimeInMillis() && this.endDate.getTimeInMillis() >= range.getEndDate().getTimeInMillis();
    }

    public boolean includes(Calendar cal) {
        return this.startDate.getTimeInMillis() <= cal.getTimeInMillis() && this.endDate.getTimeInMillis() >= cal.getTimeInMillis();
    }

    public Calendar getStartDate() {
        return this.startDate;
    }

    public Calendar getEndDate() {
        return this.endDate;
    }

    public String toString() {
        boolean isThisWeek = TaskActivityUtil.getCurrentWeek().includes(this);
        boolean isNextWeek = TaskActivityUtil.getNextWeek().includes(this);
        if (this.isDay() && (isThisWeek || isNextWeek)) {
            String day = "";
            switch (this.getStartDate().get(7)) {
                case 2: {
                    day = "Monday";
                    break;
                }
                case 3: {
                    day = "Tuesday";
                    break;
                }
                case 4: {
                    day = "Wednesday";
                    break;
                }
                case 5: {
                    day = "Thursday";
                    break;
                }
                case 6: {
                    day = "Friday";
                    break;
                }
                case 7: {
                    day = "Saturday";
                    break;
                }
                case 1: {
                    day = "Sunday";
                }
            }
            if (Calendar.getInstance().get(7) == this.getStartDate().get(7)) {
                return String.valueOf(day) + " - Today";
            }
            return day;
        }
        if (this.isThisWeek()) {
            return DESCRIPTION_THIS_WEEK;
        }
        if (this.isNextWeek()) {
            return DESCRIPTION_NEXT_WEEK;
        }
        if (this.isWeekAfterNext()) {
            return DESCRIPTION_WEEK_AFTER_NEXT;
        }
        if (this.isPreviousWeek()) {
            return DESCRIPTION_PREVIOUS_WEEK;
        }
        return DateFormat.getDateInstance(2).format(this.startDate.getTime());
    }

    private boolean isWeekAfterNext() {
        return TaskActivityUtil.getCurrentWeek().next().next().compareTo(this) == 0;
    }

    public DateRange next() {
        if (this.isDay()) {
            return this.create(6, 1);
        }
        if (this.isWeek()) {
            return this.create(3, 1);
        }
        return null;
    }

    public DateRange previous() {
        if (this.isDay()) {
            return this.create(6, -1);
        }
        if (this.isWeek()) {
            return this.create(3, -1);
        }
        return null;
    }

    private DateRange create(int field, int multiplier) {
        Calendar previousStart = (Calendar)this.getStartDate().clone();
        Calendar previousEnd = (Calendar)this.getEndDate().clone();
        previousStart.add(field, 1 * multiplier);
        previousEnd.add(field, 1 * multiplier);
        return new DateRange(previousStart, previousEnd);
    }

    private boolean isNextWeek() {
        return TaskActivityUtil.getCurrentWeek().next().compareTo(this) == 0;
    }

    public boolean isThisWeek() {
        if (this.isWeek()) {
            return this.includes(Calendar.getInstance());
        }
        return false;
    }

    private boolean isPreviousWeek() {
        if (this.isWeek()) {
            Calendar cal = Calendar.getInstance();
            cal.add(3, -1);
            return this.includes(cal);
        }
        return false;
    }

    public boolean isDay() {
        return this.getEndDate().getTimeInMillis() - this.getStartDate().getTimeInMillis() == 86399999L;
    }

    public boolean isWeek() {
        return this.getEndDate().getTimeInMillis() - this.getStartDate().getTimeInMillis() == 604799999L;
    }

    public boolean isPast() {
        return this.getEndDate().compareTo(Calendar.getInstance()) < 0;
    }

    public boolean isBefore(DateRange scheduledDate) {
        return this.getEndDate().compareTo(scheduledDate.getStartDate()) < 0;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.endDate == null ? 0 : this.endDate.hashCode());
        result = 31 * result + (this.startDate == null ? 0 : this.startDate.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DateRange)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        DateRange other = (DateRange)obj;
        if (this.endDate == null ? other.endDate != null : !this.endDate.equals(other.endDate)) {
            return false;
        }
        return !(this.startDate == null ? other.startDate != null : !this.startDate.equals(other.startDate));
    }

    public boolean before(Calendar cal) {
        return this.getEndDate().before(cal);
    }

    public boolean after(Calendar cal) {
        return cal.before(this.getEndDate());
    }

    @Override
    public int compareTo(DateRange range) {
        if (range.getStartDate().equals(this.startDate) && range.getEndDate().equals(this.endDate)) {
            return 0;
        }
        if (this.includes(range)) {
            return 1;
        }
        if (this.before(range.getStartDate())) {
            return -1;
        }
        if (this.after(range.getEndDate())) {
            return 1;
        }
        return -1;
    }
}

