/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.commons.net;

import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.UnknownHostException;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.NTCredentials;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.params.DefaultHttpParams;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.eclipse.core.net.proxy.IProxyData;
import org.eclipse.core.net.proxy.IProxyService;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.mylyn.commons.net.AbstractWebLocation;
import org.eclipse.mylyn.commons.net.AuthenticationCredentials;
import org.eclipse.mylyn.commons.net.AuthenticationType;
import org.eclipse.mylyn.commons.net.WebUtil;
import org.eclipse.mylyn.internal.commons.net.AuthenticatedProxy;
import org.eclipse.mylyn.internal.commons.net.CommonsNetPlugin;
import org.eclipse.mylyn.internal.commons.net.SslProtocolSocketFactory;

@Deprecated
public class WebClientUtil {
    public static final String USER_AGENT;
    public static final String CONTENT_ENCODING_GZIP = "gzip";
    public static final int CONNNECT_TIMEOUT = 60000;
    public static final int SOCKET_TIMEOUT = 60000;
    private static final int HTTP_PORT = 80;
    private static final int HTTPS_PORT = 443;
    private static final int SOCKS_PORT = 1080;
    private static OutputStream logOutputStream;
    private static boolean loggingEnabled;
    private static final String USER_AGENT_PREFIX;
    private static final String USER_AGENT_POSTFIX;

    static {
        logOutputStream = System.err;
        loggingEnabled = false;
        WebClientUtil.initCommonsLoggingSettings();
        StringBuilder sb = new StringBuilder();
        sb.append("Mylyn");
        sb.append(WebClientUtil.getBundleVersion(CommonsNetPlugin.getDefault()));
        USER_AGENT_PREFIX = sb.toString();
        sb.setLength(0);
        if (System.getProperty("org.osgi.framework.vendor") != null) {
            sb.append(" ");
            sb.append(System.getProperty("org.osgi.framework.vendor"));
            sb.append(WebClientUtil.stripQualifier(System.getProperty("osgi.framework.version")));
            if (System.getProperty("eclipse.product") != null) {
                sb.append(" (");
                sb.append(System.getProperty("eclipse.product"));
                sb.append(")");
            }
        }
        sb.append(" ");
        sb.append(DefaultHttpParams.getDefaultParams().getParameter("http.useragent").toString().split("-")[1]);
        sb.append(" Java/");
        sb.append(System.getProperty("java.version"));
        sb.append(" (");
        sb.append(System.getProperty("java.vendor").split(" ")[0]);
        sb.append(") ");
        sb.append(System.getProperty("os.name"));
        sb.append("/");
        sb.append(System.getProperty("os.version"));
        sb.append(" (");
        sb.append(System.getProperty("os.arch"));
        if (System.getProperty("osgi.nl") != null) {
            sb.append("; ");
            sb.append(System.getProperty("osgi.nl"));
        }
        sb.append(")");
        USER_AGENT_POSTFIX = sb.toString();
        USER_AGENT = String.valueOf(USER_AGENT_PREFIX) + USER_AGENT_POSTFIX;
    }

    private static String stripQualifier(String longVersion) {
        if (longVersion == null) {
            return "";
        }
        String[] parts = longVersion.split("\\.");
        StringBuilder version = new StringBuilder();
        if (parts.length > 0) {
            version.append("/");
            version.append(parts[0]);
            if (parts.length > 1) {
                version.append(".");
                version.append(parts[1]);
                if (parts.length > 2) {
                    version.append(".");
                    version.append(parts[2]);
                }
            }
        }
        return version.toString();
    }

    private static String getBundleVersion(Plugin plugin) {
        if (plugin == null) {
            return "";
        }
        Object bundleVersion = plugin.getBundle().getHeaders().get("Bundle-Version");
        if (bundleVersion == null) {
            return "";
        }
        return WebClientUtil.stripQualifier((String)bundleVersion);
    }

    public static void initCommonsLoggingSettings() {
        System.setProperty("org.apache.commons.logging.Log", "org.apache.commons.logging.impl.SimpleLog");
        System.setProperty("org.apache.commons.logging.simplelog.defaultlog", "off");
        System.setProperty("org.apache.commons.logging.simplelog.log.httpclient.wire.header", "off");
        System.setProperty("org.apache.commons.logging.simplelog.log.org.apache.commons.httpclient", "off");
    }

    public static OutputStream getLogStream() {
        return logOutputStream;
    }

    public static void setLogStream(OutputStream stream) {
        logOutputStream = stream;
    }

    public static void setLoggingEnabled(boolean enabled) {
        loggingEnabled = enabled;
    }

    static boolean isRepositoryHttps(String repositoryUrl) {
        return repositoryUrl.matches("https.*");
    }

    public static int getPort(String repositoryUrl) {
        int colonSlashSlash = repositoryUrl.indexOf("://");
        int firstSlash = repositoryUrl.indexOf("/", colonSlashSlash + 3);
        int colonPort = repositoryUrl.indexOf(58, colonSlashSlash + 1);
        if (firstSlash == -1) {
            firstSlash = repositoryUrl.length();
        }
        if (colonPort < 0 || colonPort > firstSlash) {
            return WebClientUtil.isRepositoryHttps(repositoryUrl) ? 443 : 80;
        }
        int requestPath = repositoryUrl.indexOf(47, colonPort + 1);
        int end = requestPath < 0 ? repositoryUrl.length() : requestPath;
        String port = repositoryUrl.substring(colonPort + 1, end);
        if (port.length() == 0) {
            return WebClientUtil.isRepositoryHttps(repositoryUrl) ? 443 : 80;
        }
        return Integer.parseInt(port);
    }

    public static String getDomain(String repositoryUrl) {
        String result = repositoryUrl;
        int colonSlashSlash = repositoryUrl.indexOf("://");
        if (colonSlashSlash >= 0) {
            result = repositoryUrl.substring(colonSlashSlash + 3);
        }
        int colonPort = result.indexOf(58);
        int requestPath = result.indexOf(47);
        int substringEnd = colonPort > 0 && requestPath > 0 ? Math.min(colonPort, requestPath) : (colonPort > 0 ? colonPort : (requestPath > 0 ? requestPath : result.length()));
        return result.substring(0, substringEnd);
    }

    public static String getRequestPath(String repositoryUrl) {
        int colonSlashSlash = repositoryUrl.indexOf("://");
        int requestPath = repositoryUrl.indexOf(47, colonSlashSlash + 3);
        if (requestPath < 0) {
            return "";
        }
        return repositoryUrl.substring(requestPath);
    }

    @Deprecated
    public static void setupHttpClient(HttpClient client, Proxy proxySettings, String repositoryUrl, String user, String password) {
        WebUtil.configureHttpClient(client, null);
        if (proxySettings != null && !Proxy.NO_PROXY.equals(proxySettings) && proxySettings.address() instanceof InetSocketAddress) {
            InetSocketAddress address = (InetSocketAddress)proxySettings.address();
            client.getHostConfiguration().setProxy(WebClientUtil.getDomain(address.getHostName()), address.getPort());
            if (proxySettings instanceof AuthenticatedProxy) {
                AuthenticatedProxy authProxy = (AuthenticatedProxy)proxySettings;
                Credentials credentials = WebClientUtil.getCredentials(authProxy.getUserName(), authProxy.getPassword(), address.getAddress());
                AuthScope proxyAuthScope = new AuthScope(address.getHostName(), address.getPort(), AuthScope.ANY_REALM);
                client.getState().setProxyCredentials(proxyAuthScope, credentials);
            }
        }
        if (user != null && password != null) {
            AuthScope authScope = new AuthScope(WebClientUtil.getDomain(repositoryUrl), WebClientUtil.getPort(repositoryUrl), AuthScope.ANY_REALM);
            try {
                client.getState().setCredentials(authScope, WebClientUtil.getCredentials(user, password, InetAddress.getLocalHost()));
            }
            catch (UnknownHostException unknownHostException) {
                client.getState().setCredentials(authScope, WebClientUtil.getCredentials(user, password, null));
            }
        }
        if (WebClientUtil.isRepositoryHttps(repositoryUrl)) {
            Protocol acceptAllSsl = new Protocol("https", (ProtocolSocketFactory)SslProtocolSocketFactory.getInstance(), WebClientUtil.getPort(repositoryUrl));
            client.getHostConfiguration().setHost(WebClientUtil.getDomain(repositoryUrl), WebClientUtil.getPort(repositoryUrl), acceptAllSsl);
            Protocol.registerProtocol((String)"https", (Protocol)acceptAllSsl);
        } else {
            client.getHostConfiguration().setHost(WebClientUtil.getDomain(repositoryUrl), WebClientUtil.getPort(repositoryUrl));
        }
    }

    public static Credentials getCredentials(AuthenticatedProxy authProxy, InetSocketAddress address) {
        return WebClientUtil.getCredentials(authProxy.getUserName(), authProxy.getPassword(), address.getAddress());
    }

    private static Credentials getCredentials(String username, String password, InetAddress address) {
        int i = username.indexOf("\\");
        if (i > 0 && i < username.length() - 1 && address != null) {
            return new NTCredentials(username.substring(i + 1), password, address.getHostName(), username.substring(0, i));
        }
        return new UsernamePasswordCredentials(username, password);
    }

    public static Credentials getHttpClientCredentials(AuthenticationCredentials credentials, String host) {
        String username = credentials.getUserName();
        String password = credentials.getPassword();
        int i = username.indexOf("\\");
        if (i > 0 && i < username.length() - 1 && host != null) {
            return new NTCredentials(username.substring(i + 1), password, host, username.substring(0, i));
        }
        return new UsernamePasswordCredentials(username, password);
    }

    public static Proxy getProxy(String proxyHost, String proxyPort, String proxyUsername, String proxyPassword) {
        boolean authenticated;
        boolean bl = authenticated = proxyUsername != null && proxyPassword != null && proxyUsername.length() > 0 && proxyPassword.length() > 0;
        if (proxyHost != null && proxyHost.length() > 0 && proxyPort != null && proxyPort.length() > 0) {
            int proxyPortNum = Integer.parseInt(proxyPort);
            InetSocketAddress sockAddr = new InetSocketAddress(proxyHost, proxyPortNum);
            if (authenticated) {
                return new AuthenticatedProxy(Proxy.Type.HTTP, sockAddr, proxyUsername, proxyPassword);
            }
            return new Proxy(Proxy.Type.HTTP, sockAddr);
        }
        return Proxy.NO_PROXY;
    }

    public static Proxy getPlatformProxy() {
        IProxyData data;
        Proxy proxy = Proxy.NO_PROXY;
        IProxyService service = CommonsNetPlugin.getProxyService();
        if (service != null && service.isProxiesEnabled() && (data = service.getProxyData("HTTP")).getHost() != null) {
            String proxyHost = data.getHost();
            int proxyPort = data.getPort();
            if (proxyPort == -1) {
                proxyPort = 0;
            }
            InetSocketAddress sockAddr = new InetSocketAddress(proxyHost, proxyPort);
            proxy = new Proxy(Proxy.Type.HTTP, sockAddr);
        }
        return proxy;
    }

    public static Proxy getPlatformProxy(String url) {
        Proxy proxy = Proxy.NO_PROXY;
        Proxy.Type proxyType = Proxy.Type.DIRECT;
        IProxyService service = CommonsNetPlugin.getProxyService();
        if (service != null && service.isProxiesEnabled()) {
            IProxyData proxyDataInUse = null;
            IProxyData httpProxy = service.getProxyDataForHost(WebClientUtil.getDomain(url), "HTTP");
            IProxyData httpsProxy = service.getProxyDataForHost(WebClientUtil.getDomain(url), "HTTPS");
            if (url.startsWith("https")) {
                if (httpsProxy != null) {
                    proxyDataInUse = httpsProxy;
                } else if (httpProxy != null) {
                    proxyDataInUse = httpProxy;
                }
            } else if (url.startsWith("http") && httpProxy != null) {
                proxyDataInUse = httpProxy;
            }
            if (proxyDataInUse != null) {
                int proxyPort = proxyDataInUse.getPort();
                if (proxyDataInUse.getType().equals("HTTP")) {
                    proxyType = Proxy.Type.HTTP;
                    if (proxyPort == -1) {
                        proxyPort = 80;
                    }
                } else if (proxyDataInUse.getType().equals("HTTPS")) {
                    proxyType = Proxy.Type.HTTP;
                    if (proxyPort == -1) {
                        proxyPort = 443;
                    }
                } else {
                    proxyType = Proxy.Type.SOCKS;
                    if (proxyPort == -1) {
                        proxyPort = 1080;
                    }
                }
                String proxyHost = proxyDataInUse.getHost();
                String proxyUserName = proxyDataInUse.getUserId();
                String proxyPassword = proxyDataInUse.getPassword();
                InetSocketAddress sockAddr = new InetSocketAddress(proxyHost, proxyPort);
                proxy = proxyUserName != null && proxyUserName.length() > 0 && proxyPassword != null && proxyPassword.length() > 0 ? new AuthenticatedProxy(proxyType, sockAddr, proxyUserName, proxyPassword) : new Proxy(proxyType, sockAddr);
            }
        }
        return proxy;
    }

    public static boolean isLoggingEnabled() {
        return loggingEnabled;
    }

    @Deprecated
    public static void setupHttpClient(HttpClient client, String userAgent, AbstractWebLocation location) {
        if (client == null || location == null) {
            throw new IllegalArgumentException();
        }
        String url = location.getUrl();
        String host = WebClientUtil.getDomain(url);
        int port = WebClientUtil.getPort(url);
        WebUtil.configureHttpClient(client, userAgent);
        WebClientUtil.setupHttpClientProxy(client, client.getHostConfiguration(), location);
        AuthenticationCredentials credentials = location.getCredentials(AuthenticationType.HTTP);
        if (credentials != null) {
            AuthScope authScope = new AuthScope(host, port, AuthScope.ANY_REALM);
            client.getState().setCredentials(authScope, WebClientUtil.getHttpClientCredentials(credentials, host));
        }
        if (WebClientUtil.isRepositoryHttps(url)) {
            Protocol acceptAllSsl = new Protocol("https", (ProtocolSocketFactory)SslProtocolSocketFactory.getInstance(), port);
            client.getHostConfiguration().setHost(host, port, acceptAllSsl);
            Protocol.registerProtocol((String)"https", (Protocol)acceptAllSsl);
        } else {
            client.getHostConfiguration().setHost(host, port);
        }
    }

    @Deprecated
    public static HostConfiguration createHostConfiguration(HttpClient client, String userAgent, AbstractWebLocation location, IProgressMonitor monitor) {
        WebUtil.configureHttpClient(client, userAgent);
        return WebClientUtil.createHostConfiguration(client, userAgent, location, monitor);
    }

    private static void setupHttpClientProxy(HttpClient client, HostConfiguration hostConfiguration, AbstractWebLocation location) {
        String host = WebClientUtil.getDomain(location.getUrl());
        Proxy proxy = WebClientUtil.isRepositoryHttps(location.getUrl()) ? location.getProxyForHost(host, "HTTP") : location.getProxyForHost(host, "HTTPS");
        if (proxy != null && !Proxy.NO_PROXY.equals(proxy)) {
            InetSocketAddress address = (InetSocketAddress)proxy.address();
            hostConfiguration.setProxy(address.getHostName(), address.getPort());
            if (proxy instanceof AuthenticatedProxy) {
                AuthenticatedProxy authProxy = (AuthenticatedProxy)proxy;
                Credentials credentials = WebClientUtil.getCredentials(authProxy.getUserName(), authProxy.getPassword(), address.getAddress());
                AuthScope proxyAuthScope = new AuthScope(address.getHostName(), address.getPort(), AuthScope.ANY_REALM);
                client.getState().setProxyCredentials(proxyAuthScope, credentials);
            }
        } else {
            hostConfiguration.setProxyHost(null);
        }
    }

    public static String getUserAgent(String product) {
        if (product != null && product.length() > 0) {
            StringBuilder sb = new StringBuilder();
            sb.append(USER_AGENT_PREFIX);
            sb.append(" ");
            sb.append(product);
            sb.append(USER_AGENT_POSTFIX);
            return sb.toString();
        }
        return USER_AGENT;
    }
}

